/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.figures;

import java.util.List;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Label;
import org.eclipse.draw2dl.LayoutManager;
import org.eclipse.draw2dl.ToolbarLayout;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.commands.Command;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.figures.CustomCheckBoxFigure;
import org.jkiss.dbeaver.erd.ui.figures.EditableLabel;
import org.jkiss.dbeaver.erd.ui.model.ERDDecorator;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class AttributeItemFigure
extends Figure {
    protected final AttributePart part;
    private IFigure rightPanel;

    public AttributeItemFigure(AttributePart part) {
        DBPImage labelImage;
        this.part = part;
        ERDEntityAttribute attribute = part.getAttribute();
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setSpacing(3);
        this.setLayoutManager((LayoutManager)layout);
        EntityDiagram diagram = part.getDiagramPart().getDiagram();
        boolean showCheckboxes = diagram.getDecorator().showCheckboxes();
        if (showCheckboxes) {
            CustomCheckBoxFigure attrCheckbox = new CustomCheckBoxFigure();
            attrCheckbox.setSelected(attribute.isChecked());
            attrCheckbox.addChangeListener(changeEvent -> {
                boolean newChecked;
                boolean oldChecked = attribute.isChecked();
                if (oldChecked != (newChecked = attrCheckbox.isSelected())) {
                    part.getDiagramPart().getViewer().getEditDomain().getCommandStack().execute((Command)part.createAttributeCheckCommand(newChecked));
                }
            });
            this.add((IFigure)attrCheckbox);
        }
        EditableLabel attrNameLabel = new EditableLabel(part.getAttributeLabel());
        if (diagram.hasAttributeStyle(ERDViewStyle.ICONS) && (labelImage = attribute.getLabelImage()) != null) {
            attrNameLabel.setIcon(DBeaverIcons.getImage((DBPImage)labelImage));
        }
        this.add((IFigure)attrNameLabel);
        DiagramPart diagramPart = part.getDiagramPart();
        Font columnFont = diagramPart.getNormalFont();
        Color columnColor = this.getColumnForegroundColor();
        if (part.getAttribute().isInPrimaryKey()) {
            columnFont = diagramPart.getBoldFont();
        }
        attrNameLabel.setFont(columnFont);
        attrNameLabel.setForegroundColor(columnColor);
        if (this.rightPanel != null) {
            this.rightPanel.setFont(columnFont);
            this.rightPanel.setForegroundColor(columnColor);
        }
    }

    protected Color getColumnForegroundColor() {
        return UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.attributes.foreground");
    }

    public ERDEntityAttribute getAttribute() {
        return this.part.getAttribute();
    }

    @Nullable
    public CustomCheckBoxFigure getCheckBox() {
        if (this.getChildren().size() < 2) {
            return null;
        }
        return (CustomCheckBoxFigure)((Object)this.getChildren().get(0));
    }

    @NotNull
    public EditableLabel getLabel() {
        List children;
        return (EditableLabel)((Object)children.get((children = this.getChildren()).size() == 1 ? 0 : 1));
    }

    public IFigure getRightPanel() {
        return this.rightPanel;
    }

    void setRightPanel(IFigure attrExtra) {
        this.rightPanel = attrExtra;
    }

    public void updateLabels() {
        DBPImage labelImage;
        this.getLabel().setText(this.part.getAttributeLabel());
        EntityDiagram diagram = this.part.getDiagram();
        ERDDecorator decorator = diagram.getDecorator();
        if (decorator.supportsAttributeStyle(ERDViewStyle.ICONS) && diagram.hasAttributeStyle(ERDViewStyle.ICONS) && (labelImage = this.part.getAttribute().getLabelImage()) != null) {
            this.getLabel().setIcon(DBeaverIcons.getImage((DBPImage)labelImage));
        }
        if (this.rightPanel instanceof Label) {
            String rightText = "";
            if (decorator.supportsAttributeStyle(ERDViewStyle.TYPES) && diagram.hasAttributeStyle(ERDViewStyle.TYPES)) {
                rightText = ((DBSEntityAttribute)this.part.getAttribute().getObject()).getFullTypeName();
            }
            if (decorator.supportsAttributeStyle(ERDViewStyle.NULLABILITY) && diagram.hasAttributeStyle(ERDViewStyle.NULLABILITY) && ((DBSEntityAttribute)this.part.getAttribute().getObject()).isRequired()) {
                rightText = String.valueOf(rightText) + " NOT NULL";
            }
            ((Label)this.rightPanel).setText(rightText);
        }
    }

    public Rectangle getBounds() {
        IFigure parent = this.getParent();
        if (parent != null && parent.getBorder() != null) {
            Insets insets = parent.getBorder().getInsets((IFigure)this);
            Rectangle bounds = parent.getBounds();
            return super.getBounds().getCopy().setX(bounds.x + insets.left).setWidth(bounds.width - insets.left - insets.right);
        }
        return super.getBounds();
    }
}

