/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.elasticache;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.CacheNode;
import software.amazon.awssdk.services.elasticache.model.Endpoint;

public class AWSCloudElasticacheRedisCluster
extends AWSCloudAbstractInstance {
    public static final String REDIS_AWS_ENGINE_NAME = "redis";
    private final CacheCluster cluster;

    public AWSCloudElasticacheRedisCluster(@NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, @NotNull CacheCluster cacheCluster) {
        super(session, zone);
        this.cluster = cacheCluster;
    }

    @NotNull
    public String getNodeId() {
        List nodes = this.cluster.cacheNodes();
        if (nodes.size() > 0) {
            return ((CacheNode)nodes.get(0)).cacheNodeId();
        }
        return "";
    }

    @NotNull
    public String getNodeName() {
        return this.cluster.cacheClusterId();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.cluster.configurationEndpoint().address();
    }

    @Override
    @NotNull
    public String getNodeDisplayName() {
        return this.cluster.cacheClusterId();
    }

    @Override
    protected void setDataSourceConfiguration(@NotNull DBPConnectionConfiguration configuration) throws DBException {
        Endpoint endpoint;
        configuration.setDatabaseName(this.cluster.cacheClusterId());
        List nodes = this.cluster.cacheNodes();
        if (nodes.size() > 0 && (endpoint = ((CacheNode)nodes.get(0)).endpoint()) != null) {
            configuration.setHostName(endpoint.address());
            configuration.setHostPort(CommonUtils.toString((Object)endpoint.port()));
        }
        if (super.getInstanceUserName() != null) {
            configuration.setUserName(this.getInstanceUserName());
        }
        configuration.setAuthModelId("iam_simple");
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    @NotNull
    protected AWSCloudService getCloudService() {
        return AWSCloudService.ELASTICACHE_REDIS;
    }

    @Override
    @NotNull
    protected String getInstanceARN() {
        return this.cluster.arn();
    }

    @Override
    protected String getResourceId() {
        return this.cluster.cacheClusterId();
    }

    @Override
    @NotNull
    protected String getExternalLink() {
        return String.valueOf(this.getLinkPrefix()) + "cluster-details?cluster=" + this.cluster.cacheClusterId();
    }

    @Property(viewable=true)
    @NotNull
    public String getElasticacheRedisClusterStatus() {
        return this.cluster.cacheClusterStatus();
    }

    @Property(viewable=true)
    @NotNull
    public String getRedisNode() {
        List nodes = this.cluster.cacheNodes();
        StringBuilder sb = new StringBuilder();
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            CacheNode cfr_ignored_0 = (CacheNode)iterator.next();
            sb.append("id: ");
            sb.append(((CacheNode)nodes.get(0)).cacheNodeId());
            sb.append(" status: ");
            sb.append(((CacheNode)nodes.get(0)).cacheNodeStatus());
            sb.append("; ");
        }
        return sb.toString();
    }

    @Property(viewable=true)
    @NotNull
    public String getElasticacheRedisNodeType() {
        return this.cluster.cacheNodeType();
    }
}

