/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.config;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.registry.BaseCloudConfigurationProvider;
import com.dbeaver.ee.runtime.core.DBeaverEnterprisePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.utils.CommonUtils;

public class AwsLocalConfigurationProvider
extends BaseCloudConfigurationProvider<AWSCloudConfiguration> {
    private static final Log log = Log.getLog(AwsLocalConfigurationProvider.class);

    protected String getCloudTypeId() {
        return "aws";
    }

    protected Class<AWSCloudConfiguration> getCloudConfigurationClass() {
        return AWSCloudConfiguration.class;
    }

    protected void loadSecureProperties(AWSCloudConfiguration cfg) {
        if (this.useSecureStorage()) {
            try {
                DBSSecretController secretController = this.getSecretController();
                String accessKey = secretController.getSecretValue(AwsLocalConfigurationProvider.getSecretId(cfg, "access-key"));
                String secretKey = secretController.getSecretValue(AwsLocalConfigurationProvider.getSecretId(cfg, "secret-key"));
                String sessionToken = secretController.getSecretValue(AwsLocalConfigurationProvider.getSecretId(cfg, "session-token"));
                if (!CommonUtils.isEmpty((String)accessKey)) {
                    cfg.getCredentials().setAwsAccessKey(accessKey);
                }
                if (!CommonUtils.isEmpty((String)secretKey)) {
                    cfg.getCredentials().setAwsSecretKey(secretKey);
                }
                if (!CommonUtils.isEmpty((String)sessionToken)) {
                    cfg.getCredentials().setAwsSessionToken(sessionToken);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected boolean saveSecureProperties(AWSCloudConfiguration cfg) {
        if (!this.useSecureStorage()) {
            return false;
        }
        try {
            String sessionToken;
            String secretKey;
            DBSSecretController secretController = this.getSecretController();
            String accessKey = cfg.getCredentials().getAwsAccessKey();
            if (!CommonUtils.isEmpty((String)accessKey)) {
                secretController.setSecretValue(AwsLocalConfigurationProvider.getSecretId(cfg, "access-key"), accessKey);
            }
            if (!CommonUtils.isEmpty((String)(secretKey = cfg.getCredentials().getAwsSecretKey()))) {
                secretController.setSecretValue(AwsLocalConfigurationProvider.getSecretId(cfg, "secret-key"), secretKey);
            }
            if (!CommonUtils.isEmpty((String)(sessionToken = cfg.getCredentials().getAwsSessionToken()))) {
                secretController.setSecretValue(AwsLocalConfigurationProvider.getSecretId(cfg, "session-token"), sessionToken);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    private boolean useSecureStorage() {
        return DBeaverEnterprisePreferences.useSecurePreferences();
    }

    @NotNull
    private static String getSecretId(AWSCloudConfiguration cfg, String key) {
        return "aws/credentials/" + cfg.getCloudId() + "/" + key;
    }

    @NotNull
    private DBSSecretController getSecretController() {
        return DBSSecretController.getGlobalSecretController();
    }
}

