/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;

public enum AWSCloudService {
    RDS_POSTGRESQL("postgresql", "rds", "postgresql", "postgres-jdbc", "rds"),
    RDS_MYSQL("mysql", "rds", "mysql", "mysql8", "rds"),
    RDS_MARIADB("mariadb", "rds", "mysql", "mariaDB", "rds"),
    RDS_ORACLE("oracle", "rds", "oracle", "oracle_thin", "rds"),
    RDS_SQLSERVER("sqlserver", "rds", "sqlserver-ee", "microsoft", "rds"),
    REDSHIFT("redshift", "redshift", "redshift", "redshift-jdbc", "redshiftv2"),
    ATHENA("athena", "athena", "athena", "aws_athena_jdbc_simba", "athena"),
    DYNAMODB("dynamodb", "dynamodb", "dynamodb", "dynamodb", "dynamodb"),
    DOCUMENTDB("docdb", "documentdb", "aws-documentdb", "documentdb", "docdb"),
    KEYSPACES("keyspaces", "keyspaces", "aws_keyspaces", "keyspaces", "keyspaces"),
    ELASTICACHE_REDIS("elasticache", "elasticache", "redis", "redis_jedis", "redis"),
    UNKNOWN("unknown", "", "", "", "unknown");

    private final String id;
    private final String serviceId;
    private final String providerId;
    private final String driverId;
    private final String prefix;

    private AWSCloudService(String id, String serviceId, String providerId, String driverId, String prefix) {
        this.id = id;
        this.serviceId = serviceId;
        this.providerId = providerId;
        this.driverId = driverId;
        this.prefix = prefix;
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String getServiceId() {
        return this.serviceId;
    }

    @NotNull
    public String getProviderId() {
        return this.providerId;
    }

    @NotNull
    public String getDriverId() {
        return this.driverId;
    }

    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    public DBPDriver getInstanceDriver() throws DBException {
        DataSourceProviderDescriptor dsProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(this.providerId);
        if (dsProvider == null) {
            throw new DBException("Datasource provider '" + this.providerId + "' not found");
        }
        DriverDescriptor driver = dsProvider.getDriver(this.driverId);
        if (driver == null) {
            throw new DBException("Driver '" + this.driverId + "' not found");
        }
        return driver;
    }

    @Nullable
    public static AWSCloudService getServiceByDriver(DBPDriver driver) {
        AWSCloudService[] aWSCloudServiceArray = AWSCloudService.values();
        int n = aWSCloudServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            AWSCloudService service = aWSCloudServiceArray[n2];
            if (service.providerId.equals(driver.getProviderId()) && service.driverId.equals(driver.getId())) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    public static AWSCloudService getServiceById(String id) {
        AWSCloudService[] aWSCloudServiceArray = AWSCloudService.values();
        int n = aWSCloudServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            AWSCloudService service = aWSCloudServiceArray[n2];
            if (service.getId().equals(id)) {
                return service;
            }
            ++n2;
        }
        return null;
    }
}

