/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudExplorer;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AWSCloudDataSourceOrigin
extends DataSourceOriginCloud<AWSCloud, AWSCloudZone>
implements DBACredentialsProvider {
    private static final Log log = Log.getLog(AWSCloudDataSourceOrigin.class);
    public static final String PROPERTY_RESOURCE_ID = "aws-resource";

    public AWSCloudDataSourceOrigin(@NotNull CloudProviderDescriptor awsCloudProvider, @NotNull Map<String, Object> configuration, @Nullable DBPExternalConfiguration externalConfiguration) {
        super(awsCloudProvider, configuration, externalConfiguration);
    }

    public String getResourceId() {
        return CommonUtils.toString(this.getDataSourceConfiguration().get(PROPERTY_RESOURCE_ID));
    }

    @Nullable
    public DBPObject getObjectDetails(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext sessionContext, @NotNull DBPDataSourceContainer dataSource) throws DBException {
        AWSCloudService service = AWSCloudService.getServiceByDriver(dataSource.getDriver());
        if (service == null) {
            log.error((Object)("Cannot detect AWS service for driver " + dataSource.getDriver().getFullName()));
            return null;
        }
        AWSCloudAbstractInstance instance = this.getDatabaseInstance(monitor, sessionContext, service);
        if (instance == null) {
            log.error((Object)(String.valueOf(service.getServiceId()) + " instance '" + this.getResourceId() + "' not found"));
        }
        return instance;
    }

    public AWSCloudAbstractInstance getDatabaseInstance(DBRProgressMonitor monitor, SMSessionContext sessionContext, AWSCloudService service) throws DBException {
        AWSCloud cloud = (AWSCloud)this.getCloud();
        AWSCloudZone zone = (AWSCloudZone)this.getZone();
        SMSession cloudSession = sessionContext.getSpaceSession(monitor, (SMAuthSpace)cloud, true);
        if (cloudSession instanceof AWSCloudSession) {
            AWSCloudExplorer cloudExplorer = cloud.createExplorer(monitor, (AWSCloudSession)cloudSession);
            return cloudExplorer.getDatabaseInstance(monitor, service.getServiceId(), (CPDatabaseFolder)null, zone, this.getResourceId());
        }
        throw new DBException("AWS cloud session not found");
    }

    public boolean provideAuthParameters(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        SMSession cloudSession = DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession(monitor, (SMAuthSpace)this.getCloud(), true);
        if (cloudSession instanceof AWSCloudSession) {
            return ((AWSCloudSession)cloudSession).provideAuthParameters(monitor, dataSourceContainer, configuration);
        }
        return false;
    }

    @NotNull
    public String getAuthContextType() {
        return "aws";
    }

    public static AWSCloudDataSourceOrigin createOrigin(String cloudId, String regionId, String resourceId) {
        CloudProviderDescriptor awsCloudProvider = AWSCloudUtils.getAwsCloudProvider();
        LinkedHashMap<String, Object> dsConfiguration = new LinkedHashMap<String, Object>();
        dsConfiguration.put("cloud-provider", awsCloudProvider.getId());
        dsConfiguration.put("cloud-id", cloudId);
        dsConfiguration.put("cloud-zone-id", regionId);
        dsConfiguration.put(PROPERTY_RESOURCE_ID, resourceId);
        return new AWSCloudDataSourceOrigin(awsCloudProvider, dsConfiguration, null);
    }
}

