/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import software.amazon.awssdk.regions.Region;

public class AWSCloudConfiguration
implements CPCloudConfiguration {
    private String cloudId;
    private String cloudName;
    private String[] defaultRegions = new String[]{Region.US_EAST_1.id()};
    private String[] enabledServices = new String[]{"rds", "redshift", "athena", "dynamodb", "documentdb", "keyspaces"};
    private boolean govRegionsEnabled;
    private boolean isoRegionsEnabled;
    private boolean s3Disabled;
    private boolean autoRegistrationEnabled = false;
    private String[] autoRegistrationAccounts = null;
    private boolean federatedAccessEnabled;
    private String proxyAccessKey;
    private String proxySecretKey;
    private String proxyDefaultRole;
    private boolean readAllRegions = true;
    private AuthModelAWSCredentials credentials = new AuthModelAWSCredentials();

    @Nullable
    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(@NotNull String cloudId) {
        this.cloudId = cloudId;
    }

    @Nullable
    public String getCloudName() {
        return this.cloudName;
    }

    public void setCloudName(@NotNull String cloudName) {
        this.cloudName = cloudName;
    }

    public boolean isAutoRegistrationEnabled() {
        return this.autoRegistrationEnabled;
    }

    public void setAutoRegistrationEnabled(boolean autoRegistrationEnabled) {
        this.autoRegistrationEnabled = autoRegistrationEnabled;
    }

    public String[] getAutoRegistrationAccounts() {
        return this.autoRegistrationAccounts;
    }

    public void setAutoRegistrationAccounts(String[] autoRegistrationAccounts) {
        this.autoRegistrationAccounts = autoRegistrationAccounts;
    }

    public String[] getDefaultRegions() {
        return this.defaultRegions;
    }

    public void setDefaultRegions(String[] defaultRegions) {
        this.defaultRegions = defaultRegions;
    }

    public String[] getEnabledServices() {
        return this.enabledServices;
    }

    public void setEnabledServices(String[] enabledServices) {
        this.enabledServices = enabledServices;
    }

    public boolean isGovRegionsEnabled() {
        return this.govRegionsEnabled;
    }

    public boolean isIsoRegionsEnabled() {
        return this.isoRegionsEnabled;
    }

    public boolean isS3Disabled() {
        return this.s3Disabled;
    }

    public AuthModelAWSCredentials getCredentials() {
        return this.credentials;
    }

    public boolean isFederatedAccessEnabled() {
        return this.federatedAccessEnabled;
    }

    public void setFederatedAccessEnabled(boolean federatedAccessEnabled) {
        this.federatedAccessEnabled = federatedAccessEnabled;
    }

    @Deprecated
    public String getProxyAccessKey() {
        return this.proxyAccessKey;
    }

    public void setProxyAccessKey(String proxyAccessKey) {
        this.proxyAccessKey = proxyAccessKey;
    }

    @Deprecated
    public String getProxySecretKey() {
        return this.proxySecretKey;
    }

    public void setProxySecretKey(String proxySecretKey) {
        this.proxySecretKey = proxySecretKey;
    }

    @Deprecated
    public String getProxyDefaultRole() {
        return this.proxyDefaultRole;
    }

    public void setProxyDefaultRole(String proxyDefaultRole) {
        this.proxyDefaultRole = proxyDefaultRole;
    }

    public boolean isReadAllRegions() {
        return this.readAllRegions;
    }

    public void setReadAllRegions(boolean readAllRegions) {
        this.readAllRegions = readAllRegions;
    }

    public void mergeCloudSettings(AWSCloudConfiguration config) {
        this.cloudName = config.cloudName;
        this.autoRegistrationEnabled = config.autoRegistrationEnabled;
        this.autoRegistrationAccounts = config.autoRegistrationAccounts;
        this.defaultRegions = config.defaultRegions;
        this.enabledServices = config.enabledServices;
        this.govRegionsEnabled = config.govRegionsEnabled;
        this.isoRegionsEnabled = config.isoRegionsEnabled;
        this.s3Disabled = config.s3Disabled;
    }

    public boolean isCloudSettingsEqual(AWSCloudConfiguration cfg) {
        return Objects.equals(this.cloudName, cfg.cloudName) && this.autoRegistrationEnabled == cfg.autoRegistrationEnabled && Objects.deepEquals(this.autoRegistrationAccounts, cfg.autoRegistrationAccounts) && Objects.deepEquals(this.defaultRegions, cfg.defaultRegions) && Objects.deepEquals(this.enabledServices, cfg.enabledServices) && Objects.equals(this.govRegionsEnabled, cfg.govRegionsEnabled) && Objects.equals(this.isoRegionsEnabled, cfg.isoRegionsEnabled) && this.s3Disabled == cfg.s3Disabled;
    }

    public String toString() {
        return this.getCloudName();
    }
}

