/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreArrayValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreBitStringValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreDateTimeValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreGeometryValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreHStoreValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreIntervalValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreJSONValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreMoneyValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreRefCursorValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreStringValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreStructValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreTemporalAccessorValueHandler;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.PostgreServerRedshift;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftGeometryValueHandler;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCContentValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCNumberValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStandardValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreValueHandlerProvider
extends JDBCStandardValueHandlerProvider {
    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        int typeID = typedObject.getTypeID();
        switch (typeID) {
            case 2003: {
                return PostgreArrayValueHandler.INSTANCE;
            }
            case 2002: {
                return PostgreStructValueHandler.INSTANCE;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                if (((PostgreDataSource)dataSource).getServerType().supportsTemporalAccessor()) {
                    return new PostgreTemporalAccessorValueHandler(preferences);
                }
                return new PostgreDateTimeValueHandler(preferences);
            }
        }
        switch (typedObject.getTypeName()) {
            case "varbyte": {
                return JDBCContentValueHandler.INSTANCE;
            }
            case "json": 
            case "jsonb": {
                return PostgreJSONValueHandler.INSTANCE;
            }
            case "hstore": {
                return PostgreHStoreValueHandler.INSTANCE;
            }
            case "varbit": 
            case "bit": {
                return PostgreBitStringValueHandler.INSTANCE;
            }
            case "refcursor": {
                return PostgreRefCursorValueHandler.INSTANCE;
            }
            case "money": {
                return PostgreMoneyValueHandler.INSTANCE;
            }
            case "geography": 
            case "geometry": {
                if (((PostgreDataSource)dataSource).getServerType() instanceof PostgreServerRedshift) {
                    return RedshiftGeometryValueHandler.INSTANCE;
                }
                return PostgreGeometryValueHandler.INSTANCE;
            }
            case "interval": {
                return PostgreIntervalValueHandler.INSTANCE;
            }
        }
        if (PostgreConstants.SERIAL_TYPES.containsKey(typedObject.getTypeName())) {
            return new JDBCNumberValueHandler(typedObject, preferences);
        }
        if (typeID == 1111 || typedObject.getDataKind() == DBPDataKind.STRING) {
            return PostgreStringValueHandler.INSTANCE;
        }
        return super.getValueHandler(dataSource, preferences, typedObject);
    }
}

