/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class QMMStatementExecuteInfo
extends QMMObject {
    private final QMMStatementInfo statement;
    private QMMTransactionSavepointInfo savepoint;
    private final String queryString;
    private long fetchRowCount;
    private long updateRowCount = -1L;
    private int errorCode;
    private String errorMessage;
    private long fetchBeginTime;
    private long fetchEndTime;
    private boolean transactional;
    private QMMStatementExecuteInfo previous;

    QMMStatementExecuteInfo(QMMStatementInfo statement, QMMTransactionSavepointInfo savepoint, String queryString, QMMStatementExecuteInfo previous) {
        SQLDialect sqlDialect;
        this.statement = statement;
        this.previous = previous;
        this.savepoint = savepoint;
        this.queryString = queryString;
        if (savepoint != null) {
            savepoint.setLastExecute(this);
        }
        this.transactional = (sqlDialect = statement.getConnection().getSQLDialect()) != null && queryString != null ? statement.getPurpose() != DBCExecutionPurpose.META && sqlDialect.isTransactionModifyingQuery(queryString) : false;
    }

    public QMMStatementExecuteInfo(long openTime, long closeTime, QMMStatementInfo stmt, String queryString, long rowCount, int errorCode, String errorMessage, long fetchBeginTime, long fetchEndTime, boolean transactional) {
        super(openTime, closeTime);
        this.statement = stmt;
        this.queryString = queryString;
        this.fetchRowCount = rowCount;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.fetchBeginTime = fetchBeginTime;
        this.fetchEndTime = fetchEndTime;
        this.transactional = transactional;
    }

    private QMMStatementExecuteInfo(Builder builder) {
        super(builder.openTime, builder.closeTime);
        this.statement = builder.statement;
        this.savepoint = builder.savepoint;
        this.queryString = builder.queryString;
        this.fetchRowCount = builder.fetchRowCount;
        this.updateRowCount = builder.updateRowCount;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.fetchBeginTime = builder.fetchBeginTime;
        this.fetchEndTime = builder.fetchEndTime;
        this.transactional = builder.transactional;
        this.previous = builder.previous;
    }

    public static Builder builder() {
        return new Builder();
    }

    void close(long rowCount, Throwable error) {
        if (error != null) {
            if (error instanceof SQLException) {
                this.errorCode = ((SQLException)error).getErrorCode();
            }
            this.errorMessage = error.getMessage();
            this.transactional = true;
        }
        this.updateRowCount = rowCount;
        if (!this.transactional) {
            this.transactional = this.updateRowCount >= 0L;
        }
        super.close();
    }

    void beginFetch() {
        this.fetchBeginTime = QMMStatementExecuteInfo.getTimeStamp();
    }

    void endFetch(long rowCount) {
        this.fetchEndTime = QMMStatementExecuteInfo.getTimeStamp();
        this.fetchRowCount = rowCount;
    }

    public QMMStatementInfo getStatement() {
        return this.statement;
    }

    public QMMTransactionSavepointInfo getSavepoint() {
        return this.savepoint;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public long getFetchRowCount() {
        return this.fetchRowCount;
    }

    public long getUpdateRowCount() {
        return this.updateRowCount;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean hasError() {
        return this.errorCode != 0 || this.errorMessage != null;
    }

    public long getFetchBeginTime() {
        return this.fetchBeginTime;
    }

    public long getFetchEndTime() {
        return this.fetchEndTime;
    }

    public boolean isFetching() {
        return this.fetchBeginTime > 0L && this.fetchEndTime == 0L;
    }

    public boolean isTransactional() {
        return this.transactional || this.updateRowCount > 0L;
    }

    public QMMStatementExecuteInfo getPrevious() {
        return this.previous;
    }

    public String toString() {
        return String.valueOf('\"') + this.queryString + '\"';
    }

    @Override
    public String getText() {
        return this.queryString;
    }

    @Override
    public QMMObject.ObjectType getObjectType() {
        return QMMObject.ObjectType.StatementExecuteInfo;
    }

    @Override
    public long getDuration() {
        if (!this.isClosed()) {
            return -1L;
        }
        long execTime = this.getCloseTime() - this.getOpenTime();
        long fetchTime = this.isFetching() ? 0L : this.getFetchEndTime() - this.getFetchBeginTime();
        return execTime + fetchTime;
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this.statement.getConnection();
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> serializedInfo = new LinkedHashMap<String, Object>();
        serializedInfo.put("query", this.getQueryString());
        serializedInfo.put("statement", this.getStatement().toMap());
        serializedInfo.put("updateRowCount", this.getUpdateRowCount());
        serializedInfo.put("fetchRowCount", this.getFetchRowCount());
        serializedInfo.put("errorCode", this.getErrorCode());
        serializedInfo.put("errorMessage", this.getErrorMessage());
        serializedInfo.put("openTime", this.getOpenTime());
        serializedInfo.put("closeTime", this.getCloseTime());
        serializedInfo.put("fetchBeginTime", this.getFetchBeginTime());
        serializedInfo.put("fetchEndTime", this.getFetchEndTime());
        return serializedInfo;
    }

    public static QMMStatementExecuteInfo fromMap(Map<String, Object> objectMap) {
        String query = CommonUtils.toString((Object)objectMap.get("query"));
        QMMStatementInfo statement = QMMStatementInfo.fromMap(JSONUtils.getObject(objectMap, "statement"));
        long updateRowCount = CommonUtils.toLong((Object)objectMap.get("updateRowCount"));
        long fetchRowCount = CommonUtils.toLong((Object)objectMap.get("fetchRowCount"));
        int errorCode = CommonUtils.toInt((Object)objectMap.get("errorCode"));
        String errorMessage = CommonUtils.toString((Object)objectMap.get("errorMessage"), null);
        long openTime = CommonUtils.toLong((Object)objectMap.get("openTime"));
        long closeTime = CommonUtils.toLong((Object)objectMap.get("closeTime"));
        long fetchBeginTime = CommonUtils.toLong((Object)objectMap.get("fetchBeginTime"));
        long fetchEndTime = CommonUtils.toLong((Object)objectMap.get("fetchEndTime"));
        return QMMStatementExecuteInfo.builder().setQueryString(query).setStatement(statement).setUpdateRowCount(updateRowCount).setFetchRowCount(fetchRowCount).setErrorCode(errorCode).setErrorMessage(errorMessage).setOpenTime(openTime).setCloseTime(closeTime).setFetchBeginTime(fetchBeginTime).setFetchEndTime(fetchEndTime).build();
    }

    public static final class Builder {
        private QMMStatementInfo statement;
        private QMMTransactionSavepointInfo savepoint;
        private String queryString;
        private long fetchRowCount;
        private long updateRowCount;
        private int errorCode;
        private String errorMessage;
        private long openTime;
        private long closeTime;
        private long fetchBeginTime;
        private long fetchEndTime;
        private boolean transactional;
        private QMMStatementExecuteInfo previous;

        private Builder() {
        }

        public Builder setStatement(QMMStatementInfo statement) {
            this.statement = statement;
            return this;
        }

        public Builder setSavepoint(QMMTransactionSavepointInfo savepoint) {
            this.savepoint = savepoint;
            return this;
        }

        public Builder setQueryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder setFetchRowCount(long fetchRowCount) {
            this.fetchRowCount = fetchRowCount;
            return this;
        }

        public Builder setUpdateRowCount(long updateRowCount) {
            this.updateRowCount = updateRowCount;
            return this;
        }

        public Builder setErrorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder setOpenTime(long openTime) {
            this.openTime = openTime;
            return this;
        }

        public Builder setCloseTime(long closeTime) {
            this.closeTime = closeTime;
            return this;
        }

        public Builder setFetchBeginTime(long fetchBeginTime) {
            this.fetchBeginTime = fetchBeginTime;
            return this;
        }

        public Builder setFetchEndTime(long fetchEndTime) {
            this.fetchEndTime = fetchEndTime;
            return this;
        }

        public Builder setTransactional(boolean transactional) {
            this.transactional = transactional;
            return this;
        }

        public Builder setPrevious(QMMStatementExecuteInfo previous) {
            this.previous = previous;
            return this;
        }

        public QMMStatementExecuteInfo build() {
            return new QMMStatementExecuteInfo(this);
        }
    }
}

