/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.sql.SQLDialectQueryGenerator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSContextBoundAttribute;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class StandardSQLDialectQueryGenerator
implements SQLDialectQueryGenerator {
    private Log log = Log.getLog(StandardSQLDialectQueryGenerator.class);
    private static final String NESTED_QUERY_AlIAS = "z_q";
    public static StandardSQLDialectQueryGenerator INSTANCE = new StandardSQLDialectQueryGenerator();
    public static final Pattern PATTERN_COLUMN_NAME = Pattern.compile("(([a-z_][a-z0-9_]*)|(\\\"([a-z_][a-z0-9_]*)\\\"))(\\.(([a-z_][a-z0-9_]*)|(\\\"([a-z_][a-z0-9_]*)\\\")))*", 2);

    @Override
    public void appendQueryConditions(DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) {
        if (dataFilter != null && dataFilter.hasConditions()) {
            query.append("\nWHERE ");
            this.appendConditionString(dataFilter, dataSource, tableAlias, query, true);
        }
    }

    @Override
    public void appendQueryOrder(DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) {
        if (dataFilter != null && dataFilter.hasOrdering()) {
            query.append("\nORDER BY ");
            this.appendOrderString(dataFilter, dataSource, tableAlias, false, query);
        }
    }

    @Override
    public void appendConditionString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria) {
        this.appendConditionString(filter, dataSource, conditionTable, query, inlineCriteria, false);
    }

    @Override
    public void appendConditionString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) {
        List<DBDAttributeConstraint> constraints = filter.getConstraints().stream().filter(x -> x.getCriteria() != null || x.getOperator() != null).collect(Collectors.toList());
        this.appendConditionString(filter, constraints, dataSource, conditionTable, query, inlineCriteria, subQuery);
    }

    @Override
    public void appendConditionString(@NotNull DBDDataFilter filter, @NotNull List<DBDAttributeConstraint> constraints, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) {
        String operator = filter.isAnyConstraint() ? " OR " : " AND ";
        int index = 0;
        while (index < constraints.size()) {
            String attrName;
            DBSAttributeBase cAttr;
            DBDAttributeConstraint constraint = constraints.get(index);
            if (index > 0) {
                query.append(operator);
            }
            if (constraints.size() > 1) {
                query.append('(');
            }
            if ((cAttr = constraint.getAttribute()) instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)cAttr;
                if (binding.getEntityAttribute() != null && binding.getMetaAttribute() != null && binding.getEntityAttribute().getName().equals(binding.getMetaAttribute().getName()) || binding instanceof DBDAttributeBindingType) {
                    if (binding.getEntityAttribute() instanceof DBSContextBoundAttribute) {
                        DBSContextBoundAttribute entityAttribute = (DBSContextBoundAttribute)binding.getEntityAttribute();
                        attrName = entityAttribute.formatMemberReference(true, conditionTable, DBPAttributeReferencePurpose.DATA_SELECTION);
                    } else {
                        attrName = DBUtils.getObjectFullName(dataSource, binding, DBPEvaluationContext.DML, DBPAttributeReferencePurpose.DATA_SELECTION);
                    }
                } else {
                    attrName = binding.getMetaAttribute() == null || binding.getEntityAttribute() != null ? DBUtils.getQuotedIdentifier(dataSource, subQuery ? constraint.getAttributeLabel() : constraint.getAttributeName()) : binding.getMetaAttribute().getName();
                }
            } else {
                attrName = cAttr != null ? DBUtils.getObjectFullName(dataSource, cAttr, DBPEvaluationContext.DML, DBPAttributeReferencePurpose.DATA_SELECTION) : DBUtils.getQuotedIdentifier(dataSource, constraint.getAttributeName());
            }
            query.append(attrName).append(' ').append(this.getConstraintCondition(dataSource, constraint, conditionTable, inlineCriteria));
            if (constraints.size() > 1) {
                query.append(')');
            }
            ++index;
        }
        if (!CommonUtils.isEmpty((String)filter.getWhere())) {
            if (constraints.size() > 0) {
                query.append(operator).append('(').append(filter.getWhere()).append(')');
            } else {
                query.append(filter.getWhere());
            }
        }
    }

    @Override
    @NotNull
    public String getQueryWithAppliedFilters(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) {
        boolean isForceFilterSubQuery;
        boolean bl = isForceFilterSubQuery = dataSource.getSQLDialect().supportsSubqueries() && dataSource.getContainer().getPreferenceStore().getBoolean("sql.query.filter.force.subselect");
        if (isForceFilterSubQuery) {
            return this.getWrappedFilterQuery(dataSource, sqlQuery, dataFilter);
        }
        String newQuery = SQLSemanticProcessor.injectFiltersToQuery(monitor, dataSource, sqlQuery, dataFilter);
        if (newQuery == null) {
            return this.getWrappedFilterQuery(dataSource, sqlQuery, dataFilter);
        }
        return newQuery;
    }

    @Override
    @NotNull
    public String getWrappedFilterQuery(@NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) {
        StringBuilder modifiedQuery = new StringBuilder(sqlQuery.length() + 100);
        modifiedQuery.append("SELECT * FROM (\n");
        modifiedQuery.append(sqlQuery);
        modifiedQuery.append("\n) ").append(NESTED_QUERY_AlIAS);
        if (dataFilter.hasConditions()) {
            modifiedQuery.append(" WHERE ");
            SQLUtils.appendConditionString(dataFilter, dataSource, NESTED_QUERY_AlIAS, modifiedQuery, true, true);
        }
        if (dataFilter.hasOrdering()) {
            modifiedQuery.append(" ORDER BY ");
            SQLUtils.appendOrderString(dataFilter, dataSource, NESTED_QUERY_AlIAS, true, modifiedQuery);
        }
        return modifiedQuery.toString();
    }

    @Override
    public void appendOrderString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, boolean subQuery, @NotNull StringBuilder query) {
        boolean hasOrder = false;
        for (DBDAttributeConstraint co : filter.getOrderConstraints()) {
            if (hasOrder) {
                query.append(',');
            }
            String orderString = null;
            if (co.isPlainNameReference() || co.getAttribute() == null || co.getAttribute() instanceof DBDAttributeBindingMeta || co.getAttribute() instanceof DBDAttributeBindingType) {
                String orderColumn;
                String string = orderColumn = subQuery ? co.getAttributeLabel() : co.getAttributeName();
                if (StandardSQLDialectQueryGenerator.canOrderByName(dataSource, co, orderColumn) && !filter.hasNameDuplicates(orderColumn)) {
                    DBSAttributeBase attr = co.getAttribute();
                    if (attr instanceof DBDAttributeBinding && ((DBDAttributeBinding)attr).getEntityAttribute() instanceof DBSContextBoundAttribute) {
                        DBDAttributeBinding attrBinding = (DBDAttributeBinding)attr;
                        DBSContextBoundAttribute entityAttribute = (DBSContextBoundAttribute)attrBinding.getEntityAttribute();
                        orderString = entityAttribute.formatMemberReference(true, conditionTable, DBPAttributeReferencePurpose.DATA_SELECTION);
                    } else {
                        orderString = co.getFullAttributeName();
                        if (conditionTable != null) {
                            orderString = String.valueOf(conditionTable) + '.' + orderString;
                        }
                    }
                }
            }
            if (orderString == null) {
                int orderIndex = SQLUtils.getConstraintOrderIndex(filter, co);
                if (orderIndex == -1) {
                    this.log.debug("Can't generate column order: no name and no position found");
                    continue;
                }
                orderString = String.valueOf(orderIndex);
            }
            query.append(orderString);
            if (co.isOrderDescending()) {
                query.append(" DESC");
            }
            hasOrder = true;
        }
        if (!CommonUtils.isEmpty((String)filter.getOrder())) {
            if (hasOrder) {
                query.append(',');
            }
            query.append(filter.getOrder());
        }
    }

    private static boolean canOrderByName(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, @NotNull String constraintName) {
        if (constraint.getAttribute() == null) {
            return true;
        }
        if (!dataSource.getSQLDialect().supportsOrderByIndex()) {
            return true;
        }
        return PATTERN_COLUMN_NAME.matcher(constraintName).matches();
    }

    @Override
    @Nullable
    public String getConstraintCondition(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, @Nullable String conditionTable, boolean inlineCriteria) {
        String criteria = constraint.getCriteria();
        if (!CommonUtils.isEmpty((String)criteria)) {
            char firstChar = criteria.trim().charAt(0);
            if (!Character.isLetter(firstChar) && firstChar != '=' && firstChar != '>' && firstChar != '<' && firstChar != '!') {
                return String.valueOf('=') + criteria;
            }
            return criteria;
        }
        if (constraint.getOperator() != null) {
            DBCLogicalOperator operator = constraint.getOperator();
            StringBuilder conString = new StringBuilder();
            Object[] value = constraint.getValue();
            if (DBUtils.isNullValue(value)) {
                if (operator.getArgumentCount() == 0) {
                    return operator.getExpression();
                }
                conString.append("IS ");
                if (constraint.isReverseOperator()) {
                    conString.append("NOT ");
                }
                conString.append("NULL");
                return conString.toString();
            }
            if (constraint.isReverseOperator()) {
                conString.append("NOT ");
            }
            if (operator.getArgumentCount() > 0) {
                if (operator.equals((Object)DBCLogicalOperator.EQUALS) && value instanceof Object[]) {
                    Object[] array = value;
                    int i = 0;
                    while (i < array.length) {
                        if (i > 0) {
                            conString.append(" OR");
                            conString.append(' ').append(DBUtils.getQuotedIdentifier(dataSource, constraint.getAttributeLabel())).append(' ');
                        }
                        conString.append(operator.getExpression());
                        String strValue = StandardSQLDialectQueryGenerator.getStringValue(dataSource, constraint, inlineCriteria, array[i]);
                        conString.append(' ').append(strValue);
                        ++i;
                    }
                } else {
                    conString.append(operator.getExpression());
                    int i = 0;
                    while (i < operator.getArgumentCount()) {
                        if (i > 0) {
                            conString.append(" AND");
                        }
                        String strValue = StandardSQLDialectQueryGenerator.getStringValue(dataSource, constraint, inlineCriteria, value);
                        conString.append(' ').append(strValue);
                        ++i;
                    }
                }
            } else if (operator.getArgumentCount() < 0) {
                int valueCount = Array.getLength(value);
                boolean hasNull = false;
                boolean hasNotNull = false;
                int i = 0;
                while (i < valueCount) {
                    boolean isNull = DBUtils.isNullValue(Array.get(value, i));
                    if (isNull && !hasNull) {
                        hasNull = true;
                    }
                    if (!isNull && !hasNotNull) {
                        hasNotNull = true;
                    }
                    ++i;
                }
                if (!hasNotNull) {
                    return "IS NULL";
                }
                if (hasNull) {
                    conString.append("IS NULL OR ");
                    DBSAttributeBase attr = constraint.getAttribute();
                    if (attr instanceof DBDAttributeBinding && ((DBDAttributeBinding)attr).getEntityAttribute() instanceof DBSContextBoundAttribute) {
                        DBDAttributeBinding attrBinding = (DBDAttributeBinding)attr;
                        DBSContextBoundAttribute entityAttribute = (DBSContextBoundAttribute)attrBinding.getEntityAttribute();
                        conString.append(entityAttribute.formatMemberReference(true, conditionTable, DBPAttributeReferencePurpose.DATA_SELECTION));
                    } else {
                        if (constraint.getEntityAlias() != null) {
                            conString.append(constraint.getEntityAlias()).append('.');
                        } else if (conditionTable != null) {
                            conString.append(conditionTable).append('.');
                        }
                        conString.append(DBUtils.getObjectFullName(dataSource, constraint.getAttribute(), DBPEvaluationContext.DML, DBPAttributeReferencePurpose.DATA_SELECTION));
                    }
                    conString.append(" ");
                }
                Pair<String, String> brackets = dataSource.getSQLDialect().getInClauseParentheses();
                conString.append(operator.getExpression());
                conString.append(' ').append((String)brackets.getFirst());
                if (!value.getClass().isArray()) {
                    value = new Object[]{value};
                }
                boolean hasValue = false;
                int i2 = 0;
                while (i2 < valueCount) {
                    Object itemValue = Array.get(value, i2);
                    if (!DBUtils.isNullValue(itemValue)) {
                        if (hasValue) {
                            conString.append(",");
                        }
                        hasValue = true;
                        if (inlineCriteria) {
                            conString.append(SQLUtils.convertValueToSQL(dataSource, constraint.getAttribute(), itemValue));
                        } else {
                            conString.append(dataSource.getSQLDialect().getTypeCastClause(constraint.getAttribute(), "?", true));
                        }
                    }
                    ++i2;
                }
                conString.append((String)brackets.getSecond());
            }
            return conString.toString();
        }
        return null;
    }

    private static String getStringValue(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, boolean inlineCriteria, Object value) {
        String strValue = constraint.getAttribute() == null ? (value instanceof CharSequence ? dataSource.getSQLDialect().getQuotedString(value.toString()) : CommonUtils.toString((Object)value)) : (inlineCriteria ? SQLUtils.convertValueToSQL(dataSource, constraint.getAttribute(), value) : dataSource.getSQLDialect().getTypeCastClause(constraint.getAttribute(), "?", true));
        return strValue;
    }

    private StandardSQLDialectQueryGenerator() {
    }
}

