/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.stub.BigtableStub;
import com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.GrpcBigtableCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@InternalApi
public class GrpcBigtableStub
extends BigtableStub {
    private static final MethodDescriptor<ReadRowsRequest, ReadRowsResponse> readRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/ReadRows").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/SampleRowKeys").setRequestMarshaller(ProtoUtils.marshaller((Message)SampleRowKeysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SampleRowKeysResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateRowRequest, MutateRowResponse> mutateRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/MutateRow").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateRowResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateRowsRequest, MutateRowsResponse> mutateRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/MutateRows").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/CheckAndMutateRow").setRequestMarshaller(ProtoUtils.marshaller((Message)CheckAndMutateRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CheckAndMutateRowResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/ReadModifyWriteRow").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadModifyWriteRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadModifyWriteRowResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable;
    private final ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysCallable;
    private final UnaryCallable<MutateRowRequest, MutateRowResponse> mutateRowCallable;
    private final ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> mutateRowsCallable;
    private final UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowCallable;
    private final UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBigtableStub create(BigtableStubSettings settings) throws IOException {
        return new GrpcBigtableStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBigtableStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigtableStub(BigtableStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigtableStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigtableStub(BigtableStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigtableStub(BigtableStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigtableCallableFactory());
    }

    protected GrpcBigtableStub(BigtableStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings readRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readRowsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadRowsRequest>(){

            public Map<String, String> extract(ReadRowsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"table_name", (Object)String.valueOf(request.getTableName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings sampleRowKeysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(sampleRowKeysMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SampleRowKeysRequest>(){

            public Map<String, String> extract(SampleRowKeysRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"table_name", (Object)String.valueOf(request.getTableName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateRowMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateRowRequest>(){

            public Map<String, String> extract(MutateRowRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"table_name", (Object)String.valueOf(request.getTableName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateRowsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateRowsRequest>(){

            public Map<String, String> extract(MutateRowsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"table_name", (Object)String.valueOf(request.getTableName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings checkAndMutateRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(checkAndMutateRowMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CheckAndMutateRowRequest>(){

            public Map<String, String> extract(CheckAndMutateRowRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"table_name", (Object)String.valueOf(request.getTableName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings readModifyWriteRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readModifyWriteRowMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadModifyWriteRowRequest>(){

            public Map<String, String> extract(ReadModifyWriteRowRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"table_name", (Object)String.valueOf(request.getTableName()));
                return params.build();
            }
        }).build();
        this.readRowsCallable = callableFactory.createServerStreamingCallable(readRowsTransportSettings, settings.readRowsSettings(), clientContext);
        this.sampleRowKeysCallable = callableFactory.createServerStreamingCallable(sampleRowKeysTransportSettings, settings.sampleRowKeysSettings(), clientContext);
        this.mutateRowCallable = callableFactory.createUnaryCallable(mutateRowTransportSettings, settings.mutateRowSettings(), clientContext);
        this.mutateRowsCallable = callableFactory.createServerStreamingCallable(mutateRowsTransportSettings, settings.mutateRowsSettings(), clientContext);
        this.checkAndMutateRowCallable = callableFactory.createUnaryCallable(checkAndMutateRowTransportSettings, settings.checkAndMutateRowSettings(), clientContext);
        this.readModifyWriteRowCallable = callableFactory.createUnaryCallable(readModifyWriteRowTransportSettings, settings.readModifyWriteRowSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.readRowsCallable;
    }

    @Override
    public ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    @Override
    public UnaryCallable<MutateRowRequest, MutateRowResponse> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    @Override
    public ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> mutateRowsCallable() {
        return this.mutateRowsCallable;
    }

    @Override
    public UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    @Override
    public UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

