/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigtable.data.v2.models.AutoValue_MutateRowsException_FailedMutation;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MutateRowsException
extends ApiException {
    private static final StatusCode LOCAL_STATUS = new StatusCode(){

        public StatusCode.Code getCode() {
            return StatusCode.Code.INTERNAL;
        }

        public Object getTransportCode() {
            return null;
        }
    };
    private final List<FailedMutation> failedMutations;

    @InternalApi
    public MutateRowsException(@Nullable Throwable rpcError, @Nonnull List<FailedMutation> failedMutations, boolean retryable) {
        super("Some mutations failed to apply", rpcError, LOCAL_STATUS, retryable);
        Preconditions.checkNotNull(failedMutations);
        Preconditions.checkArgument((!failedMutations.isEmpty() ? 1 : 0) != 0, (Object)"failedMutations can't be empty");
        this.failedMutations = failedMutations;
    }

    @Nonnull
    public List<FailedMutation> getFailedMutations() {
        return this.failedMutations;
    }

    public static abstract class FailedMutation {
        @InternalApi
        @Nonnull
        public static FailedMutation create(int index, ApiException error) {
            return new AutoValue_MutateRowsException_FailedMutation(index, error);
        }

        public abstract int getIndex();

        @Nonnull
        public abstract ApiException getError();
    }
}

