/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.model.InfluxDataType;
import com.dbeaver.ee.influxdb.model.InfluxMeasurement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;

public class InfluxMeasurementField
implements DBSTableColumn,
DBSTypedObjectEx {
    private static final Log log = Log.getLog(InfluxMeasurementField.class);
    private final InfluxMeasurement table;
    private String name;
    private int position;
    private InfluxDataType dataType;

    public InfluxMeasurementField(InfluxMeasurement table, int position, String name, InfluxDataType dataType) {
        this.table = table;
        this.position = position;
        this.name = name;
        this.dataType = dataType;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, editable=true, order=2)
    public int getOrdinalPosition() {
        return this.position;
    }

    public int getTypeID() {
        return this.dataType.getTypeID();
    }

    public DBPDataKind getDataKind() {
        return this.dataType.getDataKind();
    }

    @Property(viewable=true, editable=true, order=3)
    public String getTypeName() {
        return this.dataType.getTypeName();
    }

    public String getFullTypeName() {
        return this.dataType.getFullTypeName();
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @NotNull
    public InfluxMeasurement getParentObject() {
        return this.table;
    }

    public String getDefaultValue() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Integer getScale() {
        return 0;
    }

    public Integer getPrecision() {
        return 0;
    }

    public long getMaxLength() {
        return 0L;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    public String toString() {
        return this.name;
    }

    public InfluxDataType getDataType() {
        return this.dataType;
    }
}

