/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxResultSet;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import java.util.List;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class InfluxBaseStatement
implements DBCStatement {
    private static final Log log = Log.getLog(InfluxBaseStatement.class);
    protected final InfluxSession session;
    protected final InfluxDatabase database;
    protected final String query;
    protected DBCExecutionSource source;
    protected QueryResult queryResult;
    protected int curResultsIndex;
    protected int curSeriesIndex;
    protected Throwable executeError;
    protected int offset;
    protected int limit;

    protected InfluxBaseStatement(InfluxSession session, InfluxDatabase database, String query) {
        this.session = session;
        this.database = database;
        this.query = query;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public InfluxDatabase getCurrentDatabase() {
        return this.database != null ? this.database : this.getSession().getExecutionContext().getDefaultCatalog();
    }

    @NotNull
    public InfluxSession getSession() {
        return this.session;
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public void addToBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public InfluxResultSet openResultSet() throws DBCException {
        QueryResult.Result result = (QueryResult.Result)this.queryResult.getResults().get(this.curResultsIndex);
        return new InfluxResultSet(this, result.getSeries() == null ? null : (QueryResult.Series)result.getSeries().get(this.curSeriesIndex));
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public long getUpdateRowCount() {
        return -1L;
    }

    public boolean nextResults() throws DBCException {
        List series;
        List results = this.queryResult.getResults();
        if (results.size() > this.curResultsIndex && (series = ((QueryResult.Result)results.get(this.curResultsIndex)).getSeries()) != null && series.size() > this.curSeriesIndex + 1) {
            ++this.curSeriesIndex;
            return true;
        }
        if (results.size() > this.curResultsIndex + 1) {
            ++this.curResultsIndex;
            this.curSeriesIndex = 0;
            return true;
        }
        return false;
    }

    public void close() {
        this.queryResult = null;
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = (int)offset;
        this.limit = (int)limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBCFeatureNotSupportedException();
        }
        blockThread.interrupt();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)this.session.getExecutionContext());
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), this.executeError);
        }
    }

    protected void startBlock() {
        this.session.getProgressMonitor().startBlock((DBRBlockingObject)this, this.getClass().getSimpleName());
    }

    protected void endBlock() {
        this.session.getProgressMonitor().endBlock();
    }

    protected void setQueryResult(QueryResult queryResult) {
        this.queryResult = queryResult;
    }
}

