/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.data;

import java.time.Instant;
import java.time.ZoneId;
import org.influxdb.impl.TimeUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.DateTimeCustomValueHandler;
import org.jkiss.dbeaver.model.impl.data.formatters.DateTimeDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;

public class InfluxDateTimeHandler
extends DateTimeCustomValueHandler {
    public InfluxDateTimeHandler(@NotNull DBDFormatSettings preferences) {
        super(preferences);
    }

    @Nullable
    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        return this.getValueFromObject(session, type, resultSet.getAttributeValue(index), false, false);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (this.formatSettings.isUseNativeDateTimeFormat()) {
            return object;
        }
        DateTimeDataFormatter formatter = (DateTimeDataFormatter)this.getFormatter(type);
        ZoneId zoneId = formatter.getZone();
        if (zoneId == null) {
            zoneId = formatter.getDateFormat().getTimeZone().toZoneId();
        }
        try {
            if (object instanceof String) {
                return Instant.ofEpochMilli(TimeUtil.fromInfluxDBTimeFormat((String)((String)object))).atZone(zoneId).toLocalDateTime();
            }
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }
        catch (Exception exception) {
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    protected String getFormatterId(DBSTypedObject column) {
        return "timestamp";
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        Object[] supportedOperators = super.getSupportedOperators(attribute);
        supportedOperators = (DBCLogicalOperator[])ArrayUtils.remove(DBCLogicalOperator.class, (Object[])supportedOperators, (Object)DBCLogicalOperator.IN);
        return supportedOperators;
    }
}

