/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.transactions.TransactionGetResult;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import com.couchbase.client.java.transactions.TransactionQueryResult;
import com.couchbase.client.java.transactions.internal.ConverterUtil;
import com.couchbase.client.java.transactions.internal.OptionsUtil;
import java.util.Objects;

public class TransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;
    private final JsonSerializer serializer;

    TransactionAttemptContext(CoreTransactionAttemptContext internal, JsonSerializer serializer) {
        this.internal = Objects.requireNonNull(internal);
        this.serializer = Objects.requireNonNull(serializer);
    }

    @Stability.Internal
    CoreTransactionAttemptContext ctx() {
        return this.internal;
    }

    @Stability.Internal
    CoreTransactionLogger logger() {
        return this.ctx().logger();
    }

    public TransactionGetResult get(Collection collection, String id) {
        return (TransactionGetResult)this.internal.get(ConverterUtil.makeCollectionIdentifier(collection.async()), id).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer())).publishOn(this.internal.core().context().environment().transactionsSchedulers().schedulerBlocking()).block();
    }

    public TransactionGetResult replace(TransactionGetResult doc, Object content) {
        byte[] encoded = this.serializer().serialize(content);
        return (TransactionGetResult)this.internal.replace(doc.internal(), encoded).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer())).publishOn(this.internal.core().context().environment().transactionsSchedulers().schedulerBlocking()).block();
    }

    private JsonSerializer serializer() {
        return this.serializer;
    }

    public TransactionGetResult insert(Collection collection, String id, Object content) {
        byte[] encoded = this.serializer().serialize(content);
        return (TransactionGetResult)this.internal.insert(ConverterUtil.makeCollectionIdentifier(collection.async()), id, encoded).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer())).publishOn(this.internal.core().context().environment().transactionsSchedulers().schedulerBlocking()).block();
    }

    public void remove(TransactionGetResult doc) {
        this.internal.remove(doc.internal()).publishOn(this.internal.core().context().environment().transactionsSchedulers().schedulerBlocking()).block();
    }

    public TransactionQueryResult query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public TransactionQueryResult query(String statement) {
        return this.query(null, statement, null);
    }

    public TransactionQueryResult query(Scope scope, String statement, TransactionQueryOptions options) {
        ObjectNode opts = OptionsUtil.createTransactionOptions(scope == null ? null : scope.reactive(), statement, options);
        return (TransactionQueryResult)this.internal.queryBlocking(statement, scope == null ? null : scope.bucketName(), scope == null ? null : scope.name(), opts, false).publishOn(this.internal.core().context().environment().transactionsSchedulers().schedulerBlocking()).map(response -> new TransactionQueryResult(response.header, response.rows, response.trailer, this.serializer())).block();
    }

    public TransactionQueryResult query(Scope scope, String statement) {
        return this.query(scope, statement, null);
    }
}

