/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.facet;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.facet.DateRange;
import com.couchbase.client.java.search.facet.SearchFacet;
import java.util.List;

public class DateRangeFacet
extends SearchFacet {
    private final List<DateRange> dateRanges;

    DateRangeFacet(String field, int limit, List<DateRange> dateRanges) {
        super(field, limit);
        this.dateRanges = dateRanges;
    }

    @Override
    public void injectParams(JsonObject queryJson) {
        super.injectParams(queryJson);
        JsonArray dateRange = JsonArray.create();
        for (DateRange dr : this.dateRanges) {
            JsonObject drJson = JsonObject.create();
            drJson.put("name", dr.name());
            if (dr.start() != null) {
                drJson.put("start", dr.start());
            }
            if (dr.end() != null) {
                drJson.put("end", dr.end());
            }
            dateRange.add(drJson);
        }
        queryJson.put("date_ranges", dateRange);
    }
}

