/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.Objects;

public class CollectionSpec {
    private final String name;
    private final String scopeName;
    private final Duration maxExpiry;

    private CollectionSpec(String name, String scopeName, Duration maxExpiry) {
        this.name = Validators.notNullOrEmpty((String)name, (String)"Name");
        this.scopeName = Validators.notNullOrEmpty((String)scopeName, (String)"Scope Name");
        this.maxExpiry = (Duration)Validators.notNull((Object)maxExpiry, (String)"Max Expiry");
    }

    public static CollectionSpec create(String name) {
        return CollectionSpec.create(name, "_default");
    }

    public static CollectionSpec create(String name, String scopeName) {
        return new CollectionSpec(name, scopeName, Duration.ZERO);
    }

    @Stability.Volatile
    public static CollectionSpec create(String name, Duration maxExpiry) {
        return CollectionSpec.create(name, "_default", maxExpiry);
    }

    @Stability.Volatile
    public static CollectionSpec create(String name, String scopeName, Duration maxExpiry) {
        return new CollectionSpec(name, scopeName, maxExpiry);
    }

    public String name() {
        return this.name;
    }

    public String scopeName() {
        return this.scopeName;
    }

    @Stability.Volatile
    public Duration maxExpiry() {
        return this.maxExpiry;
    }

    public String toString() {
        return "CollectionSpec{name='" + RedactableArgument.redactMeta((Object)this.name) + '\'' + ", scopeName='" + RedactableArgument.redactMeta((Object)this.scopeName) + '\'' + ", maxExpiry=" + RedactableArgument.redactMeta((Object)this.maxExpiry.getSeconds()) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionSpec that = (CollectionSpec)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.scopeName, that.scopeName) && Objects.equals(this.maxExpiry, that.maxExpiry);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.scopeName, this.maxExpiry);
    }
}

