/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.Expiry;
import java.time.Duration;
import java.time.Instant;

public class ReplaceOptions
extends CommonDurabilityOptions<ReplaceOptions> {
    private Expiry expiry = Expiry.none();
    private boolean preserveExpiry;
    private Transcoder transcoder;
    private long cas;

    private ReplaceOptions() {
    }

    public static ReplaceOptions replaceOptions() {
        return new ReplaceOptions();
    }

    public ReplaceOptions expiry(Duration expiry) {
        this.expiry = Expiry.relative(expiry);
        return this;
    }

    public ReplaceOptions expiry(Instant expiry) {
        this.expiry = Expiry.absolute(expiry);
        return this;
    }

    @Stability.Uncommitted
    public ReplaceOptions preserveExpiry(boolean preserveExpiry) {
        this.preserveExpiry = preserveExpiry;
        return this;
    }

    public ReplaceOptions transcoder(Transcoder transcoder) {
        this.transcoder = (Transcoder)Validators.notNull((Object)transcoder, (String)"Transcoder");
        return this;
    }

    public ReplaceOptions cas(long cas) {
        this.cas = cas;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonDurabilityOptions.BuiltCommonDurabilityOptions {
        Built() {
            super(ReplaceOptions.this);
        }

        public Expiry expiry() {
            return ReplaceOptions.this.expiry;
        }

        public boolean preserveExpiry() {
            return ReplaceOptions.this.preserveExpiry;
        }

        public Transcoder transcoder() {
            return ReplaceOptions.this.transcoder;
        }

        public long cas() {
            return ReplaceOptions.this.cas;
        }
    }
}

