/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.model;

import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class CheckSettingsConfig {
    private List<AbstractConfigurableRule> rules;
    private List<AbstractConfigurableRule> unrecognizedRules = new ArrayList<AbstractConfigurableRule>();
    private String warningMessage;

    public CheckSettingsConfig() {
    }

    public CheckSettingsConfig(List<AbstractConfigurableRule> list) {
        this.rules = list;
    }

    public List<AbstractConfigurableRule> getRules() {
        return this.rules;
    }

    public void setRules(List<AbstractConfigurableRule> list) {
        this.rules = list;
    }

    public void setUnrecognizedRules(List<AbstractConfigurableRule> list) {
        this.unrecognizedRules = list;
    }

    public List<AbstractConfigurableRule> accessUnrecognizedRules() {
        return this.unrecognizedRules;
    }

    public AbstractConfigurableRule getRuleById(UUID uUID) {
        for (AbstractConfigurableRule abstractConfigurableRule : this.rules) {
            if (!abstractConfigurableRule.getId().equals(uUID)) continue;
            return abstractConfigurableRule;
        }
        return null;
    }

    public List<AbstractConfigurableRule> getExecutableRulesByRuleId(UUID uUID) {
        return this.rules.stream().filter(abstractConfigurableRule -> abstractConfigurableRule.getId().equals(uUID) || abstractConfigurableRule instanceof DynamicRule && uUID.equals(((DynamicRule)abstractConfigurableRule).getParentRuleId())).sorted(Comparator.comparing(abstractConfigurableRule -> ((DynamicRule)abstractConfigurableRule).getShortName())).collect(Collectors.toList());
    }

    public DynamicRule getDynamicRuleByShortName(String string) {
        return this.rules.stream().filter(abstractConfigurableRule -> abstractConfigurableRule instanceof DynamicRule && ((DynamicRule)abstractConfigurableRule).getShortName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public AbstractConfigurableRule getRuleByShortName(String string) {
        try {
            AbstractLiquibaseRule abstractLiquibaseRule = AbstractChecksCommandStep.findRuleByShortName(string);
            return this.rules.stream().filter(abstractConfigurableRule -> abstractConfigurableRule.getId().equals(abstractLiquibaseRule.getId())).findFirst().orElse(null);
        }
        catch (CommandExecutionException commandExecutionException) {
            return this.getDynamicRuleByShortName(string);
        }
    }

    public DynamicRule getDynamicConfigurableRuleByShortName(String string, String string2) {
        DynamicRule dynamicRule = this.getDynamicRuleByShortName(string);
        if (dynamicRule == null) {
            if (!AbstractChecksCommandStep.findRuleByShortName(string).isConfigurable()) {
                throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + string + "' " + string2 + "." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
            }
            throw new CommandExecutionException("Check appears to be configurable, but cannot be located in the check settings configuration file.");
        }
        return dynamicRule;
    }

    public String getUnrecognizedRulesWarningMessage() {
        if (this.unrecognizedRules != null && !this.unrecognizedRules.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Unknown Checks Skipped (Upgrade Liquibase to use more official checks):" + System.lineSeparator());
            for (AbstractConfigurableRule abstractConfigurableRule : this.unrecognizedRules) {
                stringBuilder.append("  ");
                if (abstractConfigurableRule.isConfigurable()) {
                    stringBuilder.append(((DynamicRule)abstractConfigurableRule).getShortName());
                } else {
                    stringBuilder.append(abstractConfigurableRule.getId());
                }
                stringBuilder.append(System.lineSeparator());
            }
            stringBuilder.append(System.lineSeparator());
            return stringBuilder.toString();
        }
        return "";
    }

    public static CheckSettingsConfig generateDefaultConfigFromRules(List<AbstractLiquibaseRule> object) {
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
            arrayList.add(AbstractConfigurableRule.fromRuleImplementation(abstractLiquibaseRule));
        }
        return new CheckSettingsConfig(arrayList);
    }

    public static Optional<AbstractConfigurableRule> findRuleById(List<AbstractConfigurableRule> list, UUID uUID) {
        return list.stream().filter(abstractConfigurableRule -> uUID.equals(abstractConfigurableRule.getId())).findFirst();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (CheckSettingsConfig)object;
        return Objects.equals(this.rules, ((CheckSettingsConfig)object).rules);
    }

    public int hashCode() {
        return Objects.hash(this.rules);
    }

    public void outputWarningMessage() {
        if (StringUtil.isNotEmpty(this.warningMessage)) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(this.warningMessage);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + this.warningMessage);
        }
    }

    public void setWarningMessage(String string) {
        this.warningMessage = string;
    }

    public static CheckSettingsConfig fromFileAccessorDTO(FileAccessorDTO fileAccessorDTO) {
        CheckSettingsConfig checkSettingsConfig = (CheckSettingsConfig)new Yaml().loadAs(fileAccessorDTO.contents, CheckSettingsConfig.class);
        checkSettingsConfig.setWarningMessage(fileAccessorDTO.warningMessage);
        return checkSettingsConfig;
    }
}

