/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.cache.ClassAnalizer;
import com.intersys.cache.ClassGenerationConstants;
import com.intersys.cache.NameConversionUtil;
import com.intersys.cache.jdbcutil.SQLReservedWords;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.SList;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.MappingToolInterface;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultMappingProvider
implements Java2DBMapping {
    private static Map SPECIAL_CLASSES_MAP = null;
    private final NameConversionUtil mNameConversionUtil = new NameConversionUtil();
    private MappingToolInterface mClassNameMapper;
    private boolean mUpperCaseNames = false;
    private boolean mUseGettersOnly;
    private boolean mIgnoreNestedGenerics = false;
    private int mDefaultAccessLevel = 1;
    private int mDefaultAccessType = -1;
    private String mDefaultJavaProjectionPackage = null;
    Method mGetCollectionElementType;

    public DefaultMappingProvider(MappingToolInterface mappingToolInterface) {
        this.mClassNameMapper = mappingToolInterface;
        this.mGetCollectionElementType = this.lookupGenericProcessor();
    }

    @Override
    public int getAccessLevel(Class clazz) {
        return this.mDefaultAccessLevel;
    }

    @Override
    public int getAccessType(Class clazz) {
        if (this.mDefaultAccessType > 0) {
            return this.mDefaultAccessType;
        }
        if (this.mUseGettersOnly) {
            return 12002;
        }
        return 12006;
    }

    public void setUseGettersOnly(boolean bl) {
        this.mUseGettersOnly = bl;
    }

    public void setDefaultAccessType(int n) {
        this.mDefaultAccessType = n;
    }

    public void setDefaultAccessLevel(int n) {
        this.mDefaultAccessLevel = n;
    }

    @Override
    public String getJavaProjectionPackage(Class clazz) {
        if (this.mDefaultJavaProjectionPackage != null) {
            return this.mDefaultJavaProjectionPackage;
        }
        String string = DefaultMappingProvider.javaPackageName(clazz);
        if (string == null) {
            return "cache";
        }
        return string + ".cache";
    }

    public void setDefaultJavaProjectionPackage(String string) {
        this.mDefaultJavaProjectionPackage = string;
    }

    @Override
    public String cacheFieldTypeFor(Object object) {
        Class clazz = DefaultMappingProvider.typeOfField((PropertyDescriptor)object);
        String string = this.getCollectionElementType(object, clazz);
        if (string != null) {
            return string;
        }
        return this.inferCacheClassName(clazz);
    }

    public Class javaFieldTypeFor(Object object) {
        Class clazz = DefaultMappingProvider.typeOfField((PropertyDescriptor)object);
        Class clazz2 = this.getCollectionElementJavaType(object, clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        return clazz;
    }

    @Override
    public CacheRelationshipInfo relationshipFor(Object object) {
        return null;
    }

    private static int cacheCollectionTypeFor(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            String string = DefaultMappingProvider.testForPrimitiveType(clazz2);
            if (string != null) {
                return 33032;
            }
            return 520;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return 520;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 513;
        }
        return 0;
    }

    private String getCollectionElementType(Object object, Class clazz) {
        if (!Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (this.mGetCollectionElementType == null) {
            return null;
        }
        if (!(object instanceof PropertyDescriptor)) {
            return null;
        }
        try {
            Class clazz2 = (Class)this.mGetCollectionElementType.invoke(null, object, this.mIgnoreNestedGenerics);
            if (clazz2 == null) {
                return null;
            }
            return this.inferCacheClassName(clazz2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unexpected error: method " + this.mGetCollectionElementType.toString() + " is not accessible.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException("Can not determine type of field " + object.toString() + ". Caused by: " + invocationTargetException.getTargetException().getMessage());
        }
    }

    private Class getCollectionElementJavaType(Object object, Class clazz) {
        if (!Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (this.mGetCollectionElementType == null) {
            return null;
        }
        if (!(object instanceof PropertyDescriptor)) {
            return null;
        }
        try {
            Class clazz2 = (Class)this.mGetCollectionElementType.invoke(null, object, this.mIgnoreNestedGenerics);
            return clazz2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unexpected error: method " + this.mGetCollectionElementType.toString() + " is not accessible.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException("Can not determine type of field " + object.toString() + ". Caused by: " + invocationTargetException.getTargetException().getMessage());
        }
    }

    private String getArrayElementType(Class clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        String string = DefaultMappingProvider.testForPrimitiveType(clazz2);
        if (string != null) {
            return string;
        }
        if (clazz2.isArray()) {
            Class<?> clazz3 = clazz2.getComponentType();
            if (DefaultMappingProvider.testForPrimitiveType(clazz3) == null) {
                return "%Library.ListOfObjects";
            }
            return "%Library.ListOfDataTypes";
        }
        if (Collection.class.isAssignableFrom(clazz2)) {
            return "%Library.ListOfObjects";
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            return "%Library.ListOfObjects";
        }
        return this.inferCacheClassName(clazz2);
    }

    private String isPredefinedClass(Class clazz) {
        if (clazz.isArray()) {
            return this.getArrayElementType(clazz);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return "%Library.Persistent";
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return "%Library.Persistent";
        }
        String string = DefaultMappingProvider.testForPrimitiveType(clazz);
        if (string != null) {
            return string;
        }
        string = DefaultMappingProvider.isSpecialClass(clazz);
        if (string != null) {
            return string;
        }
        if (ClassGenerationConstants.BASE_CACHE_CLASS.isAssignableFrom(clazz)) {
            try {
                return DefaultMappingProvider.getCacheClassName(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String inferCacheClassName(Class clazz) {
        String string = this.isPredefinedClass(clazz);
        if (string != null) {
            return string;
        }
        boolean bl = this.mClassNameMapper.registerDependency(clazz);
        if (bl) {
            return this.mClassNameMapper.cacheClassNameFor(clazz);
        }
        return null;
    }

    @Override
    public String cacheClassNameFor(Class clazz) {
        String string = DefaultMappingProvider.javaPackageName(clazz);
        boolean bl = string != null && string.length() > 0;
        String string2 = bl ? string : "User";
        String string3 = string2 + '.' + DefaultMappingProvider.javaShortClassName(clazz);
        string3 = this.replaceDollars(string3);
        string3 = this.replaceUnderscores(string3);
        return string3;
    }

    @Override
    public String sqlTableNameFor(Class clazz) {
        String string = DefaultMappingProvider.javaShortClassName(clazz);
        if (SQLReservedWords.isReserved(string)) {
            string = "_" + string;
        }
        return string;
    }

    public static String javaPackageName(Class clazz) {
        Package package_ = clazz.getPackage();
        if (package_ == null) {
            return null;
        }
        return package_.getName();
    }

    public static String javaShortClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    @Override
    public String cacheFieldNameFor(Object object) {
        char c;
        String string = DefaultMappingProvider.javaFieldNameFor(object);
        if ("_Version".equals(string)) {
            return "%Version";
        }
        String string2 = string;
        if (this.mUpperCaseNames && Character.isLowerCase(c = string2.charAt(0))) {
            String string3;
            c = Character.toUpperCase(c);
            string2 = string3 = c + string2.substring(1);
        }
        string2 = this.replaceUnderscores(string2);
        string2 = this.replaceDollars(string2);
        return string2;
    }

    @Override
    public String primaryKeyNameFor(Class clazz) {
        return null;
    }

    @Override
    public CacheIndexInfo[] allIndicesFor(Class clazz) {
        return null;
    }

    @Override
    public String getJavaProjectionClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    @Override
    public boolean isSerial(Class clazz) {
        return false;
    }

    @Override
    public String getVersionID(Class clazz) {
        return null;
    }

    @Override
    public int getPropertyKind(Object object) {
        Class clazz = DefaultMappingProvider.typeOfField((PropertyDescriptor)object);
        return DefaultMappingProvider.cacheCollectionTypeFor(clazz);
    }

    @Override
    public boolean isFetchTypeEager(Object object) {
        return false;
    }

    @Override
    public boolean isClassTransient(Class clazz) {
        return false;
    }

    @Override
    public boolean isMemberTransient(Object object) {
        return false;
    }

    @Override
    public Map getPropertyParameters(Object object) {
        return null;
    }

    @Override
    public String getDatabaseID(Class clazz) {
        return null;
    }

    @Override
    public int getDatabaseIDType(Class clazz) {
        return -1;
    }

    @Override
    public void close() {
    }

    @Override
    public void setHelperMapping(Java2DBMapping java2DBMapping) {
    }

    @Override
    public boolean isPopulatable(Class clazz) {
        return false;
    }

    @Override
    public boolean isXMLSerializable(Class clazz) {
        return false;
    }

    @Override
    public Map getClassParameters(Class clazz) {
        return null;
    }

    @Override
    public String getExtendedClass(Class clazz) {
        return null;
    }

    @Override
    public String[] getImplementedClasses(Class clazz) {
        return null;
    }

    @Override
    public boolean isPropertyRequired(Object object) {
        return false;
    }

    protected static Class typeOfField(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getPropertyType();
    }

    protected static String javaFieldNameFor(Object object) {
        String string = null;
        if (object instanceof PropertyDescriptor) {
            string = ((PropertyDescriptor)object).getName();
        } else if (object instanceof Field) {
            string = ((Field)object).getName();
        } else if (object instanceof Method) {
            string = ((Method)object).getName();
            string = ClassAnalizer.methodName2PropertyName(string);
        }
        return string;
    }

    protected static String testForPrimitiveType(Class clazz) {
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return "%Library.Integer";
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return "%Library.Integer";
        }
        if (clazz.equals(BigInteger.class) || clazz.equals(Long.TYPE)) {
            return "%Library.Integer";
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return "%Library.Integer";
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return "%Library.Float";
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return "%Library.Float";
        }
        if (clazz.equals(BigDecimal.class) || clazz.equals(Double.TYPE)) {
            return "%Library.Float";
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return "%Library.Integer";
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return "%Library.Integer";
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return "%Library.Boolean";
        }
        if (clazz.equals(String.class)) {
            return "%Library.String";
        }
        if (clazz.equals(Date.class)) {
            return "%Library.Date";
        }
        if (clazz.equals(java.util.Date.class)) {
            return "%Library.Date";
        }
        if (clazz.equals(Time.class)) {
            return "%Library.Time";
        }
        if (clazz.equals(Timestamp.class)) {
            return "%Library.TimeStamp";
        }
        return null;
    }

    private static String getCacheClassName(Class clazz) throws Exception {
        Field field = clazz.getDeclaredField("CACHE_CLASS_NAME");
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new Exception("Class " + clazz.getName() + " does not seem to be a Cache class");
        }
        field.setAccessible(true);
        String string = (String)field.get(null);
        return string;
    }

    private static String isSpecialClass(Class clazz) {
        if (SPECIAL_CLASSES_MAP == null) {
            DefaultMappingProvider.initSpecialClassesMap();
        }
        return (String)SPECIAL_CLASSES_MAP.get(clazz);
    }

    private static void initSpecialClassesMap() {
        SPECIAL_CLASSES_MAP = new HashMap();
        SPECIAL_CLASSES_MAP.put(Oid.class, "%Library.String");
        SPECIAL_CLASSES_MAP.put(Id.class, "%Library.String");
        SPECIAL_CLASSES_MAP.put(SList.class, "%Library.List");
    }

    public NameConversionUtil getNameConversionUtil() {
        return this.mNameConversionUtil;
    }

    public void setDefaultReplacement(char c, String string) {
        this.mNameConversionUtil.setDefaultReplacement(c, string);
    }

    public String replaceDollars(String string) {
        return this.mNameConversionUtil.replaceDollars(string);
    }

    public String replaceUnderscores(String string) {
        return this.mNameConversionUtil.replaceUnderscores(string);
    }

    public String replace(String string, char c, String string2) {
        return this.mNameConversionUtil.replace(string, c, string2);
    }

    public Method lookupGenericProcessor() {
        String string = this.getClass().getPackage().getName() + ".GenericsProcessor";
        String string2 = "getCollectionElementType";
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, PropertyDescriptor.class, Boolean.TYPE);
            return method;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("Unexpected error: class " + string + " has no method " + string2);
        }
    }

    public boolean isIgnoreNestedGenerics() {
        return this.mIgnoreNestedGenerics;
    }

    public void setIgnoreNestedGenerics(boolean bl) {
        this.mIgnoreNestedGenerics = bl;
    }

    @Override
    public String sqlColumnNameFor(Object object) {
        return null;
    }

    @Override
    public String packageNameFor(Class clazz) {
        return null;
    }

    @Override
    public String sqlSchemaNameFor(Class clazz) {
        return null;
    }

    @Override
    public List getNamedQueries(Class clazz) {
        return null;
    }
}

