/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime.dynamic;

import com.intersys.classes.CacheRootObject;
import com.intersys.classes.Persistent;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.jalapeno.ObjectManagerFactory;
import com.jalapeno.runtime.CacheObjectManager;
import com.jalapeno.runtime.dynamic.Proxy;

public class ReconnectableProxy
extends Proxy {
    private ObjectManagerFactory mFactory;
    private String mClassName;
    private Id mId;

    protected ReconnectableProxy(CacheRootObject cacheRootObject, ObjectManagerFactory objectManagerFactory) throws CacheException {
        super(cacheRootObject);
        this.mFactory = objectManagerFactory;
        this.mClassName = cacheRootObject.getProxy().getCacheClass().getName();
        this.mId = ((Persistent)cacheRootObject).getId();
    }

    @Override
    protected boolean handleDatabaseClosed(Object object) throws Exception {
        if (this.isLoaded()) {
            return true;
        }
        if (!this.mFactory.isOpen()) {
            return false;
        }
        CacheObjectManager cacheObjectManager = (CacheObjectManager)this.mFactory.createObjectManager();
        CacheRootObject cacheRootObject = cacheObjectManager.open(this.mClassName, this.mId);
        this.replaceStaticProxy(cacheRootObject);
        this.load(object);
        cacheObjectManager.close();
        return true;
    }
}

