/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.classes.CacheRootObject;
import com.intersys.classes.Persistent;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.jalapeno.runtime.DetachedObjectsManager;
import java.io.PrintStream;

public class ProfilingDetachedObjectManager
extends DetachedObjectsManager {
    private int mNumPojoRequests;
    private int mNumPojoSuccRequests;
    private int mNumPojoFailedRequests;
    private int mNumProxyRequests;
    private int mNumProxySuccRequests;
    private int mNumProxyFailedRequests;

    public int getNumPojoFailedRequests() {
        return this.mNumPojoFailedRequests;
    }

    public int getNumPojoRequests() {
        return this.mNumPojoRequests;
    }

    public int getNumPojoSuccRequests() {
        return this.mNumPojoSuccRequests;
    }

    public int getNumProxyFailedRequests() {
        return this.mNumProxyFailedRequests;
    }

    public int getNumProxyRequests() {
        return this.mNumProxyRequests;
    }

    public int getNumProxySuccRequests() {
        return this.mNumProxySuccRequests;
    }

    public ProfilingDetachedObjectManager(Database database) {
        super(database);
    }

    @Override
    public synchronized Object findPOJO(CacheRootObject cacheRootObject, boolean bl) throws CacheException {
        ++this.mNumPojoRequests;
        Object object = super.findPOJO(cacheRootObject, bl);
        if (object == null) {
            ++this.mNumPojoFailedRequests;
        } else {
            ++this.mNumPojoSuccRequests;
        }
        return object;
    }

    @Override
    public synchronized Persistent findProxy(Object object, boolean bl) throws Exception {
        ++this.mNumProxyRequests;
        Persistent persistent = super.findProxy(object, bl);
        if (persistent == null) {
            ++this.mNumProxyFailedRequests;
        } else {
            ++this.mNumProxySuccRequests;
        }
        return persistent;
    }

    public void dumpReport(PrintStream printStream) {
        printStream.println("Pojo Requests:  " + this.mNumPojoRequests + ": " + this.mNumPojoSuccRequests + "/" + this.mNumPojoFailedRequests);
        printStream.println("Proxy Requests: " + this.mNumProxyRequests + ": " + this.mNumProxySuccRequests + "/" + this.mNumProxyFailedRequests);
        this.reportWeakStatistics(printStream);
    }

    @Override
    protected boolean isProfileOn() {
        return true;
    }

    public Thread createHook(final PrintStream printStream) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                ProfilingDetachedObjectManager.this.dumpReport(printStream);
            }
        });
    }
}

