/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.LazyList;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.SerialObject;
import com.intersys.codegenerator.helpers.PojoHelperGen;
import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.Adaptor;
import com.jalapeno.ApplicationContext;
import com.jalapeno.ObjectManagerFactory;
import com.jalapeno.runtime.JalapenoHelperInterface;
import com.jalapeno.runtime.JalapenoReflectionHelper;
import com.jalapeno.runtime.dynamic.Proxy;
import com.jalapeno.runtime.dynamic.ProxyGenerator;
import com.jalapeno.runtime.dynamic.Shadow;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class ObjectFactory {
    private int mPolicy;
    private ProxyGenerator mProxyGenerator;
    private ObjectManagerFactory mObjectManagerFactory = null;
    public static boolean dynamicProxyFactoryInitialized = false;
    public boolean mGenerateHelpers = false;
    public boolean mRequireASM = false;
    private Map mHelperMap = null;
    private Set mAdaptors;

    public ObjectFactory() {
        this.determineDefaultPolicy();
        this.mProxyGenerator = null;
    }

    public Object newPOJO(Class clazz, CacheClass cacheClass, CacheRootObject cacheRootObject, boolean bl) throws IllegalAccessException, InstantiationException, CacheException {
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        if (cacheRootObject instanceof SerialObject) {
            bl2 = true;
        }
        if (cacheClass.eagerFetchRequiredForPOJO()) {
            bl2 = true;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            bl2 = true;
        }
        if (bl2) {
            return clazz.newInstance();
        }
        switch (this.mPolicy) {
            case 1: {
                return clazz.newInstance();
            }
            case 2: {
                return this.proxyGenerator().getDynamicProxy(clazz, cacheRootObject, this.mObjectManagerFactory);
            }
        }
        throw new IllegalStateException("Policy is undefined.");
    }

    public void setAdaptor(Adaptor adaptor) {
        if (this.mAdaptors == null) {
            this.mAdaptors = new HashSet();
            if (this.mHelperMap != null) {
                Iterator iterator = this.mHelperMap.values().iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next();
                    if (v instanceof JalapenoReflectionHelper) {
                        JalapenoReflectionHelper jalapenoReflectionHelper = (JalapenoReflectionHelper)v;
                        jalapenoReflectionHelper.setAdaptors(this.mAdaptors);
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
        this.mAdaptors.add(adaptor);
    }

    public boolean removeAdaptor(Adaptor adaptor) {
        if (this.mAdaptors == null) {
            return false;
        }
        return this.mAdaptors.remove(adaptor);
    }

    public void removeAllAdaptors() {
        if (this.mAdaptors == null) {
            return;
        }
        this.mAdaptors.clear();
    }

    public synchronized JalapenoHelperInterface getHelper(CacheClass cacheClass, ClassLoader classLoader) throws Exception {
        JalapenoHelperInterface jalapenoHelperInterface;
        if (this.mHelperMap == null) {
            this.mHelperMap = new HashMap();
        }
        if ((jalapenoHelperInterface = (JalapenoHelperInterface)this.mHelperMap.get(cacheClass.getName())) != null) {
            return jalapenoHelperInterface;
        }
        if (this.mGenerateHelpers && (this.mAdaptors == null || this.mAdaptors.isEmpty())) {
            try {
                jalapenoHelperInterface = PojoHelperGen.getHelper(cacheClass, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ObjectFactory.printASMinitializationErrorMessage(classNotFoundException);
                if (this.mRequireASM) {
                    throw classNotFoundException;
                }
                System.err.println("Error initializing ASM library - Reflection will be used: " + classNotFoundException.getMessage());
                if (Logger.debugOn()) {
                    Logger.out.println("Error initializing ASM library");
                    classNotFoundException.printStackTrace(Logger.out);
                }
                this.mGenerateHelpers = false;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                ObjectFactory.printASMinitializationErrorMessage(noClassDefFoundError);
                if (this.mRequireASM) {
                    throw noClassDefFoundError;
                }
                System.err.println("Error initializing ASM library - Reflection will be used: " + noClassDefFoundError.getMessage());
                if (Logger.debugOn()) {
                    Logger.out.println("Error initializing ASM library");
                    noClassDefFoundError.printStackTrace(Logger.out);
                }
                this.mGenerateHelpers = false;
            }
        }
        if (jalapenoHelperInterface == null) {
            jalapenoHelperInterface = new JalapenoReflectionHelper(cacheClass, classLoader, this.mAdaptors);
        }
        this.mHelperMap.put(cacheClass.getName(), jalapenoHelperInterface);
        return jalapenoHelperInterface;
    }

    private static void printASMinitializationErrorMessage(Throwable throwable) {
        System.err.println("Error initializing ASM library");
        String string = throwable.getMessage();
        if (string == null || string.indexOf("org/objectweb/asm") < 0) {
            return;
        }
        System.err.println("ASM Library is required to generate helper accessors for POJO classes.");
        System.err.println("Either set ACCESS_METHOD to REFLECTION or add ObjectWeb ASM 3.1 library to your classpath");
        System.err.println("Go to http://download.forge.objectweb.org/asm/asm-3.1.jar to download it");
        System.err.println("See http://asm.ow2.org/ for more information.");
    }

    public List newList(Class clazz, boolean bl) throws IllegalAccessException {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return ObjectFactory.createDefaultListType(bl);
        }
        try {
            return (List)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return ObjectFactory.createDefaultListType(bl);
        }
    }

    private static List createDefaultListType(boolean bl) {
        if (bl) {
            return new LazyList();
        }
        return new ArrayList();
    }

    public Map newMap(Class clazz) throws IllegalAccessException {
        try {
            return (Map)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return new HashMap();
        }
    }

    public static boolean isProxy(Object object) {
        if (!dynamicProxyFactoryInitialized) {
            return false;
        }
        return Proxy.isProxy(object);
    }

    public static boolean isLoaded(Object object) {
        if (!dynamicProxyFactoryInitialized) {
            return true;
        }
        return ((Shadow)object).isLoaded();
    }

    public static boolean isUnswizzledShadow(Object object) {
        if (!dynamicProxyFactoryInitialized) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (Proxy.isProxy(object)) {
            return !((Shadow)object).isLoaded();
        }
        return false;
    }

    public static void unswizzle(Object object) {
        if (!dynamicProxyFactoryInitialized) {
            return;
        }
        if (object == null) {
            return;
        }
        if (Proxy.isProxy(object)) {
            ((Shadow)object).unswizzle();
        }
    }

    public static Class getOriginalClass(Object object) {
        if (ObjectFactory.isProxy(object)) {
            return object.getClass().getSuperclass();
        }
        return object.getClass();
    }

    public static Class getOriginalClass(Class clazz) {
        if (Shadow.class.isAssignableFrom(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public void injectDatasource(LazyList lazyList) {
        if (this.mObjectManagerFactory == null) {
            return;
        }
        if (!(this.mObjectManagerFactory instanceof ApplicationContext)) {
            return;
        }
        DataSource dataSource = ((ApplicationContext)this.mObjectManagerFactory).getDataSource();
        lazyList.injectInitializerData(dataSource);
    }

    protected int getPolicy() {
        return this.mPolicy;
    }

    protected int setPolicy(int n) {
        int n2 = this.mPolicy;
        this.mPolicy = n;
        return n2;
    }

    private final void determineDefaultPolicy() {
        String string = System.getProperty("com.jalapeno.fetch_policy");
        if ("EAGER".equalsIgnoreCase(string)) {
            this.mPolicy = 1;
        } else if ("LAZY".equalsIgnoreCase(string)) {
            this.mPolicy = 2;
        } else if ("DEFAULT".equalsIgnoreCase(string) || string == null) {
            this.mPolicy = 1;
        } else {
            throw new IllegalArgumentException("Illegal fetch policy: " + string);
        }
        string = System.getProperty("com.jalapeno.access_method");
        if (string != null) {
            if ("GENERATE".equalsIgnoreCase(string)) {
                this.mGenerateHelpers = true;
                this.mRequireASM = true;
            } else if ("REFLECTION".equalsIgnoreCase(string)) {
                this.mGenerateHelpers = false;
                this.mRequireASM = false;
            } else if ("FLEXIBLE".equalsIgnoreCase(string)) {
                this.mGenerateHelpers = true;
                this.mRequireASM = false;
            } else {
                throw new IllegalArgumentException("Illegal access policy: " + string);
            }
        }
    }

    private ProxyGenerator proxyGenerator() {
        if (this.mProxyGenerator == null) {
            this.mProxyGenerator = new ProxyGenerator();
        }
        return this.mProxyGenerator;
    }

    public ObjectManagerFactory getObjectManagerFactory() {
        return this.mObjectManagerFactory;
    }

    public void setObjectManagerFactory(ObjectManagerFactory objectManagerFactory) {
        this.mObjectManagerFactory = objectManagerFactory;
    }
}

