/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.DetachedCacheManager;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.classes.Persistent;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import com.jalapeno.ObjectManagerFactory;
import com.jalapeno.runtime.JalapenoHelperInterface;
import com.jalapeno.runtime.ObjectFactory;
import com.jalapeno.runtime.ProfilingDetachedObjectManager;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;

public class DetachedObjectsManager
extends DetachedCacheManager {
    private ObjectFactory mObjectFactory = new ObjectFactory();

    protected DetachedObjectsManager(Database database) {
        super(database);
    }

    public static DetachedObjectsManager createDetachedObjectsManager(Database database) {
        boolean bl = Boolean.getBoolean("com.intersys.profile.pojoCache");
        if (bl) {
            ProfilingDetachedObjectManager profilingDetachedObjectManager = new ProfilingDetachedObjectManager(database);
            Runtime.getRuntime().addShutdownHook(profilingDetachedObjectManager.createHook(System.out));
            return profilingDetachedObjectManager;
        }
        return new DetachedObjectsManager(database);
    }

    protected int getFetchPolicy() {
        return this.mObjectFactory.getPolicy();
    }

    protected int setFetchPolicy(int n) {
        return this.mObjectFactory.setPolicy(n);
    }

    protected void setObjectManagerFactory(ObjectManagerFactory objectManagerFactory) {
        this.mObjectFactory.setObjectManagerFactory(objectManagerFactory);
    }

    public synchronized Persistent findProxy(Object object, boolean bl) throws Exception {
        Persistent persistent = this.findProxyInMemory(object);
        if (persistent != null) {
            return persistent;
        }
        if (bl) {
            return null;
        }
        return this.findProxyInDB(object);
    }

    private Persistent findProxyInDB(Object object) throws Exception {
        CandidateKey candidateKey;
        CacheClass cacheClass;
        try {
            cacheClass = this.findImplementation(object.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        ClassLoader classLoader = ((SysDatabase)this.mDB).getClassLoader();
        JalapenoHelperInterface jalapenoHelperInterface = this.mObjectFactory.getHelper(cacheClass, classLoader);
        Serializable serializable = jalapenoHelperInterface.getPojoId(object);
        if (serializable != null && !serializable.equals("")) {
            Persistent persistent = null;
            try {
                persistent = (Persistent)cacheClass.openObject(new Id(serializable.toString()));
            }
            catch (CacheException cacheException) {
                if (Number.class.isInstance(serializable) && ((Number)serializable).longValue() == 0L) {
                    return null;
                }
                if (jalapenoHelperInterface.hasIdPlaceholder()) {
                    throw cacheException;
                }
                return null;
            }
            this.register(persistent, object);
            return persistent;
        }
        if (jalapenoHelperInterface.hasIdPlaceholder()) {
            return null;
        }
        try {
            candidateKey = this.findPojoPrimaryKey(object, cacheClass);
            if (candidateKey == null) {
                return null;
            }
        }
        catch (Exception exception) {
            if (exception instanceof CacheException) {
                throw (CacheException)exception;
            }
            throw new CacheException(exception);
        }
        try {
            return (Persistent)cacheClass.openByKey(candidateKey);
        }
        catch (CacheException cacheException) {
            if (cacheException.getCode() == 5809) {
                return null;
            }
            if (cacheException.getCode() == 5770) {
                return null;
            }
            if (cacheException.getCode() == 400) {
                String[] stringArray = candidateKey.toArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] != null) continue;
                    return null;
                }
            }
            throw cacheException;
        }
    }

    public CandidateKey findPojoPrimaryKey(Object object, CacheClass cacheClass) throws Exception {
        CandidateKeyInfo candidateKeyInfo;
        if (cacheClass == null) {
            cacheClass = this.findImplementation(object.getClass());
        }
        if ((candidateKeyInfo = cacheClass.getBestCandidateKey()) == null) {
            return null;
        }
        CandidateKey candidateKey = cacheClass.createBestCandidateKey();
        SQLColumn[] sQLColumnArray = candidateKeyInfo.getColumns();
        boolean bl = true;
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            String string;
            CacheField cacheField = sQLColumnArray[i].getField();
            if (cacheField == null) {
                throw new CacheException("Invalid Column in Primary Key: " + candidateKeyInfo.toString() + ": " + sQLColumnArray[i].getName());
            }
            if (sQLColumnArray[i].isFromEmbeddedObject()) {
                SQLColumn sQLColumn = sQLColumnArray[i].getContainingColumn();
                if (sQLColumn == null) {
                    throw new CacheException("Invalid Column in Primary Key: " + candidateKeyInfo.toString() + ": " + sQLColumnArray[i].getName());
                }
                string = this.setEmbeddedKeyValue(sQLColumn, sQLColumnArray[i].getFieldName(), object);
            } else {
                string = this.getKeyValue(object, cacheField);
            }
            if (string != null) {
                bl = false;
            }
            candidateKey.set(i, string);
        }
        if (bl) {
            return null;
        }
        return candidateKey;
    }

    private String setEmbeddedKeyValue(SQLColumn sQLColumn, String string, Object object) throws Exception {
        CacheField cacheField = sQLColumn.getField();
        Object object2 = this.getHelper(cacheField).get(object, cacheField.getII());
        if (object2 == null) {
            return null;
        }
        CacheClass cacheClass = cacheField.getType();
        CacheField cacheField2 = cacheClass.getField(string);
        return this.getKeyValue(object2, cacheField2);
    }

    private JalapenoHelperInterface getHelper(CacheField cacheField) throws Exception {
        CacheClass cacheClass = cacheField.getDeclaringCacheClass();
        ClassLoader classLoader = ((SysDatabase)this.mDB).getClassLoader();
        return this.mObjectFactory.getHelper(cacheClass, classLoader);
    }

    private JalapenoHelperInterface getHelperForValue(CacheField cacheField) throws Exception {
        CacheClass cacheClass = cacheField.getType();
        ClassLoader classLoader = ((SysDatabase)this.mDB).getClassLoader();
        return this.mObjectFactory.getHelper(cacheClass, classLoader);
    }

    private String getKeyValue(Object object, CacheField cacheField) throws Exception {
        Object object2;
        JalapenoHelperInterface jalapenoHelperInterface = this.getHelper(cacheField);
        Object object3 = jalapenoHelperInterface.get(object, cacheField.getII());
        if (object3 != null && cacheField.isPersistent()) {
            object2 = this.getHelperForValue(cacheField);
            object3 = object2.hasIdPlaceholder() ? object2.getPojoId(object3) : this.getId(object3);
        }
        object2 = object3 == null ? null : object3.toString();
        return object2;
    }

    public Serializable getId(Object object) throws Exception {
        Serializable serializable = this.findIdInMemory(object);
        if (serializable != null) {
            return serializable;
        }
        CacheClass cacheClass = this.findImplementation(object.getClass());
        JalapenoHelperInterface jalapenoHelperInterface = this.mObjectFactory.getHelper(cacheClass, ((SysDatabase)this.mDB).getClassLoader());
        serializable = jalapenoHelperInterface.getPojoId(object);
        if (serializable == null) {
            Persistent persistent = this.findProxy(object, true);
            if (persistent != null) {
                serializable = persistent.getId();
                jalapenoHelperInterface.setPojoId(object, serializable);
            } else {
                if (jalapenoHelperInterface.hasIdPlaceholder()) {
                    return null;
                }
                if (this.mDB.isLightConnection()) {
                    CandidateKey candidateKey = this.findPojoPrimaryKey(object, cacheClass);
                    if (candidateKey == null) {
                        return null;
                    }
                    serializable = (Serializable)((LightDatabase)this.mDB).existsByKey((TableBasedClass)cacheClass, candidateKey, true);
                } else {
                    persistent = this.findProxy(object, false);
                    if (persistent != null) {
                        serializable = persistent.getId();
                        jalapenoHelperInterface.setPojoId(object, serializable);
                    }
                }
            }
        }
        return serializable;
    }

    public CacheClass findImplementation(Class clazz) throws ClassNotFoundException {
        String string = ObjectFactory.getOriginalClass(clazz).getName();
        String string2 = this.getCacheClassNameFromMap(string);
        String string3 = null;
        Exception exception = null;
        try {
            if (string2 != null) {
                return this.mDB.getCacheClass(string2);
            }
            Field field = null;
            try {
                field = clazz.getDeclaredField("CACHE_CLASS_NAME");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = clazz.getField("CACHE_CLASS_NAME");
            }
            field.setAccessible(true);
            string2 = (String)field.get(null);
            this.putCacheClassNameIntoMap(string, string2);
            CacheClass cacheClass = this.mDB.getCacheClass(string2);
            return cacheClass;
        }
        catch (IllegalAccessException illegalAccessException) {
            string3 = "Insufficient access priviliges to determine Cache Class for Java class " + clazz.getName();
            exception = illegalAccessException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                return this.findCacheClassForPOJO(string);
            }
            catch (CacheException cacheException) {
                if (Logger.debugOn()) {
                    cacheException.printFullTrace(Logger.out);
                }
                string3 = "Can not determine Cache class that corresponds to Java class: " + clazz.getName();
                exception = cacheException;
            }
            catch (SQLException sQLException) {
                if (Logger.debugOn()) {
                    sQLException.printStackTrace(Logger.out);
                }
                string3 = "Can not determine Cache class that corresponds to Java class: " + clazz.getName() + ". Reason: " + sQLException.getMessage();
                exception = sQLException;
            }
        }
        catch (CacheException cacheException) {
            string3 = "Can not determine Cache class that produced Java class: " + clazz.getName();
            exception = cacheException;
        }
        throw new ClassNotFoundException(string3, exception);
    }

    public ObjectFactory getObjectFactory() {
        return this.mObjectFactory;
    }
}

