/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.cache.CacheFileLoader;
import com.intersys.cache.CodeStream;
import com.intersys.cache.CodeStreamColn;
import com.intersys.cache.Dataholder;
import com.intersys.cache.JavaCompiler;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.Dictionary.CompiledClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheReader;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.MessageListener;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.StatusCode;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheMethod;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class DatabaseUtilities {
    SysDatabase mDB;

    public DatabaseUtilities(Database database) {
        this.mDB = (SysDatabase)database;
    }

    public String[] generateClass(String string, String string2) throws CacheException, IOException {
        return this.generateClass(string, string2, null);
    }

    public String[] generateClass(String string, String string2, String string3) throws CacheException, IOException {
        string3 = string3 == null ? "-dr" : DatabaseUtilities.setFlags(string3);
        if (this.serverSupportsLocal()) {
            return this.generateClassLocal(string, string2, string3);
        }
        return this.generateClassRemote(string, string2, string3);
    }

    private String[] generateClassRemote(String string, String string2, String string3) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string), new Dataholder(string2), new Dataholder(string3)};
        String string4 = "%SYSTEM.OBJ";
        String string5 = "ExportJava";
        Dataholder dataholder = this.mDB.runClassMethod(string4, string5, dataholderArray, 0);
        this.mDB.parseStatus(dataholder);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] generateClassLocal(String string, String string2, String string3) throws CacheException, IOException {
        CodeStreamColn codeStreamColn = new CodeStreamColn(this.mDB);
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string), new Dataholder(codeStreamColn), new Dataholder(string3)};
        String string4 = "%SYSTEM.OBJ";
        String string5 = "ExportJava";
        Dataholder dataholder = this.mDB.runClassMethod(string4, string5, dataholderArray, 0);
        this.mDB.parseStatus(dataholder);
        char[] cArray = new char[32768];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : codeStreamColn.getStreams().entrySet()) {
            String string6 = (String)entry.getKey();
            string6 = DatabaseUtilities.normalizePath(string6);
            CodeStream codeStream = (CodeStream)entry.getValue();
            CacheReader cacheReader = codeStream.getValIn();
            string6 = string2 + string6;
            arrayList.add(string6);
            File file = new File(string6);
            file.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(file);
            try {
                int n;
                while ((n = cacheReader.read(cArray)) >= 0) {
                    fileWriter.write(cArray, 0, n);
                }
                fileWriter.flush();
            }
            finally {
                fileWriter.close();
            }
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public String[] importClass(String string, String string2) throws CacheException {
        try {
            String string3 = CacheFileLoader.sendFile(this.mDB, string);
            String[] stringArray = this.loadRemoteFile(string3, string2);
            CacheFileLoader.removeFile(this.mDB, string3);
            return stringArray;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Error reading file " + string);
        }
    }

    public String[] importClass(Reader reader, String string) throws CacheException {
        try {
            String string2 = CacheFileLoader.sendStream(this.mDB, reader);
            String[] stringArray = this.loadRemoteFile(string2, string);
            CacheFileLoader.removeFile(this.mDB, string2);
            return stringArray;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Error reading stream.");
        }
    }

    public String[] loadRemoteFile(String string, String string2) throws CacheException {
        string2 = DatabaseUtilities.setFlags(string2);
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string), new Dataholder(string2), new Dataholder(24, null), new Dataholder(24, null)};
        int[] nArray = new int[]{3, 4};
        String string3 = "%SYSTEM.OBJ";
        String string4 = "Load";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string3, string4, nArray, dataholderArray, 0);
        try {
            this.mDB.parseStatus(dataholderArray2[0]);
        }
        catch (CacheException cacheException) {
            String string5 = dataholderArray2[1].getString();
            throw new CacheException(cacheException, "Failed to import file " + string + ". message: " + cacheException.getMessage() + " errorlog: " + string5);
        }
        String string6 = dataholderArray2[2].getString();
        StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string7 = stringTokenizer.nextToken();
            if (string7.endsWith(".cls")) {
                int n3 = string7.indexOf(".cls");
                string7 = string7.substring(0, n3);
            }
            stringArray[n2] = string7;
            ++n2;
        }
        return stringArray;
    }

    public void makeCacheClassDeployed(String string, String string2) throws CacheException {
        string2 = DatabaseUtilities.setFlags(string2);
        String string3 = "%SYSTEM.OBJ";
        String string4 = "MakeClassDeployed";
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string), new Dataholder(string2)};
        Dataholder dataholder = this.mDB.runClassMethod(string3, string4, dataholderArray, 0);
        try {
            this.mDB.parseStatus(dataholder);
        }
        catch (CacheException cacheException) {
            throw new CacheException(cacheException, "Failed to make " + string + " deployed. message: " + cacheException.getMessage());
        }
    }

    public void rebuildIndices(String string) throws CacheException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            CacheClass cacheClass = this.mDB.getCacheClass(string2);
            if (!cacheClass.isPersistent()) continue;
            CacheMethod cacheMethod = cacheClass.getMethod("%BuildIndices", null);
            cacheMethod.invoke(null, null);
        }
    }

    public String getWebURL() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(24, null), new Dataholder(24, null), new Dataholder(24, null), new Dataholder(24, null)};
        int[] nArray = new int[]{1, 2, 3, 4};
        String string = "%Library.RoutineMgr";
        String string2 = "GetWebServerPort";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string, string2, nArray, dataholderArray, 0);
        this.mDB.parseStatus(dataholderArray2[0]);
        return dataholderArray2[4].getString();
    }

    public String getClassSchemaURL(String string) throws CacheException {
        CacheClass cacheClass = this.mDB.getCacheClass(string);
        String string2 = cacheClass.getSchemaName();
        String string3 = cacheClass.getSQLTableName();
        ObjectServerInfo objectServerInfo = this.mDB.getServerInfo();
        String string4 = objectServerInfo.webURL + "csp/sys/exp/UtilSqlTFields.csp";
        string4 = string4 + "?$NAMESPACE=" + objectServerInfo.namespace;
        string4 = string4 + "&$ID1=" + string2 + "&$ID2=" + string3;
        return string4;
    }

    public String getClassDataURL(String string) throws CacheException {
        CacheClass cacheClass = this.mDB.getCacheClass(string);
        String string2 = cacheClass.getSchemaName();
        String string3 = cacheClass.getSQLTableName();
        ObjectServerInfo objectServerInfo = this.mDB.getServerInfo();
        String string4 = objectServerInfo.webURL + "csp/sys/exp/UtilSqlOpen.csp";
        string4 = string4 + "?$NAMESPACE=" + objectServerInfo.namespace;
        string4 = string4 + "&$ID1=" + string2 + "&$ID2=" + string3;
        return string4;
    }

    public String getPackageSchemaURL(String string) {
        String string2 = string.replaceAll("\\.", "_");
        ObjectServerInfo objectServerInfo = this.mDB.getServerInfo();
        int n = objectServerInfo.getMajorObjectVersion();
        int n2 = objectServerInfo.getMinorObjectVersion();
        String string3 = n > 2008 || n >= 2008 && n2 >= 2 ? "csp/sys/exp/UtilSqlTables.csp" : "csp/sys/exp/UtilSqlSchema.csp";
        String string4 = objectServerInfo.webURL + string3;
        string4 = string4 + "?$NAMESPACE=" + objectServerInfo.namespace;
        string4 = string4 + "&$ID1=" + string2;
        return string4;
    }

    public String getDocBookURL() {
        ObjectServerInfo objectServerInfo = this.mDB.getServerInfo();
        String string = objectServerInfo.webURL + "csp/docbook/DocBook.UI.Page.cls";
        return string;
    }

    public String getJalapenoTutorialURL() {
        String string = this.getDocBookURL() + "?KEY=TJLP_preface";
        return string;
    }

    public String getJalapenoDocURL() {
        String string = this.getDocBookURL() + "?KEY=GBJJ";
        return string;
    }

    public String compileCacheClass(String string, String string2) throws CacheException {
        String string3;
        Object object;
        Dataholder[] dataholderArray;
        boolean bl;
        string2 = DatabaseUtilities.setFlags(string2);
        boolean bl2 = bl = string.indexOf(44) > 0;
        if (bl) {
            dataholderArray = new StringBuffer();
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken();
                dataholderArray.append(string3).append(".cls");
                if (((StringTokenizer)object).hasMoreTokens()) {
                    dataholderArray.append(',');
                }
                this.mDB.removeClass(string3);
            }
            string = dataholderArray.toString();
        } else {
            this.mDB.removeClass(string);
        }
        dataholderArray = new Dataholder[]{new Dataholder(string), new Dataholder(string2), new Dataholder(24, null)};
        object = new int[]{3};
        string3 = "%SYSTEM.OBJ";
        String string4 = bl ? "CompileList" : "Compile";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string3, string4, (int[])object, dataholderArray, 0);
        try {
            this.mDB.parseStatus(dataholderArray2[0]);
        }
        catch (CacheException cacheException) {
            String string5 = dataholderArray2[1].getString();
            throw new CacheException(cacheException, "Failed to compile file " + string + ". message: " + cacheException.getMessage() + " errorlog: " + string5);
        }
        return dataholderArray2[1].getString();
    }

    public void exportClass(String string, String string2, String string3, boolean bl) throws CacheException {
        String string4 = new File(string2).getName();
        String string5 = CacheFileLoader.createTempFileName(this.mDB, string4);
        this.exportClassRemote(string, string5, string3, bl);
        try {
            CacheFileLoader.receiveFile(this.mDB, string5, string2);
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Error writing file " + string2);
        }
        CacheFileLoader.removeFile(this.mDB, string5);
    }

    public void exportClassRemote(String string, String string2, String string3, boolean bl) throws CacheException {
        string3 = DatabaseUtilities.setFlags(string3);
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string), new Dataholder(string2), new Dataholder(string3), new Dataholder(24, null)};
        int[] nArray = new int[]{4};
        String string4 = "%SYSTEM.OBJ";
        String string5 = bl ? "ExportCDL" : "Export";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string4, string5, nArray, dataholderArray, 0);
        try {
            this.mDB.parseStatus(dataholderArray2[0]);
        }
        catch (CacheException cacheException) {
            String string6 = dataholderArray2[1].getString();
            throw new CacheException(cacheException, "Failed to export file " + string + " to file " + string2 + ". message: " + cacheException.getMessage() + " errorlog: " + string6);
        }
    }

    public int populateClass(String string, int n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mDB.runClassMethod(string, "Populate", dataholderArray, 0);
        return dataholder.getIntValue();
    }

    public void deleteClassDefintion(String string) throws CacheException {
        this.deleteClassDefintion(string, "");
    }

    public void deleteClassDefintion(String string, String string2) throws CacheException {
        this.mDB.removeClass(string);
        this.unregisterGlobalForClass(string);
        string2 = DatabaseUtilities.setFlags(string2);
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string), new Dataholder(string2), new Dataholder(24, null)};
        int[] nArray = new int[]{3};
        String string3 = "%SYSTEM.OBJ";
        String string4 = "Delete";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string3, string4, nArray, dataholderArray, 0);
        try {
            this.mDB.parseStatus(dataholderArray2[0]);
        }
        catch (CacheException cacheException) {
            String string5 = dataholderArray2[1].getString();
            throw new CacheException(cacheException, "Failed to delete class " + string + " message: " + cacheException.getMessage() + " errorlog: " + string5);
        }
    }

    public void deleteAllClasses(String string) throws CacheException {
        String[] stringArray = this.listAllClasses();
        for (int i = 0; i < stringArray.length; ++i) {
            this.unregisterGlobalForClass(stringArray[i]);
        }
        string = DatabaseUtilities.setFlags(string);
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string)};
        int[] nArray = new int[]{};
        String string2 = "%SYSTEM.OBJ";
        String string3 = "DeleteAll";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string2, string3, nArray, dataholderArray, 0);
        this.mDB.parseStatus(dataholderArray2[0]);
    }

    public void purgeAllJournals() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        int[] nArray = new int[]{};
        String string = "%SYS.Journal.File";
        String string2 = "PurgeAll";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string, string2, nArray, dataholderArray, 0);
        this.mDB.parseStatus(dataholderArray2[0]);
    }

    public void purgeJournal(int n, int n2) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n), new Dataholder(n2)};
        int[] nArray = new int[]{};
        String string = "%SYS.Journal.File";
        String string2 = "Purge";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string, string2, nArray, dataholderArray, 0);
        this.mDB.parseStatus(dataholderArray2[0]);
    }

    public long getFreeSpaceForJournaling() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        int[] nArray = new int[]{};
        String string = "%SYS.Journal.System";
        String string2 = "GetFreeSpace";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string, string2, nArray, dataholderArray, 0);
        return dataholderArray2[0].getLongValue();
    }

    public void startJournaling() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        int[] nArray = new int[]{};
        String string = "%SYS.Journal.System";
        String string2 = "Start";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string, string2, nArray, dataholderArray, 0);
        this.mDB.parseStatus(dataholderArray2[0]);
    }

    public void stopJournaling() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        int[] nArray = new int[]{};
        String string = "%SYS.Journal.System";
        String string2 = "Stop";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string, string2, nArray, dataholderArray, 0);
        this.mDB.parseStatus(dataholderArray2[0]);
    }

    public void compileAllClasses(String string) throws CacheException {
        string = DatabaseUtilities.setFlags(string);
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string)};
        int[] nArray = new int[]{};
        String string2 = "%SYSTEM.OBJ";
        String string3 = "CompileAll";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string2, string3, nArray, dataholderArray, 0);
        this.mDB.parseStatus(dataholderArray2[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllExtents() throws CacheException {
        String[] stringArray = this.listAllClasses();
        String string = "%KillExtent";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            CacheClass cacheClass = null;
            try {
                String string3;
                CacheClass cacheClass2;
                cacheClass = this.mDB.getCacheClass(string2);
                if (!cacheClass.isPersistent() || (cacheClass2 = cacheClass.getSuperclass()) == null || !(string3 = cacheClass2.getName()).startsWith("%") || !string3.endsWith("Persistent")) continue;
                CacheMethod cacheMethod = cacheClass.getMethod(string, null);
                System.out.println("Killing Extent: " + cacheClass.getName());
                Object object = cacheMethod.invoke(null, null);
                this.mDB.parseStatus((StatusCode)object);
                continue;
            }
            catch (CacheException cacheException) {
                System.err.println("Error Deliting extent of class " + string2 + ": " + cacheException.getMessage());
                continue;
            }
            finally {
                if (cacheClass != null) {
                    cacheClass.close();
                }
            }
        }
    }

    public void fastKillAllExtents() throws CacheException {
        String[] stringArray = this.listAllClasses();
        String string = "%KillExtent";
        Dataholder[] dataholderArray = new Dataholder[]{};
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                Dataholder dataholder = this.mDB.runClassMethod(string2, string, dataholderArray, 0);
                this.mDB.parseStatus(dataholder);
                continue;
            }
            catch (CacheException cacheException) {
                System.err.println("Error Deliting extent of class " + string2 + ": " + cacheException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listAllClasses() throws CacheException {
        Dataholder dataholder;
        String string = "%SYSTEM.OBJ";
        String string2 = "ShowClasses";
        Dataholder[] dataholderArray = new Dataholder[]{};
        final StringBuffer stringBuffer = new StringBuffer();
        MessageListener messageListener = new MessageListener(){

            @Override
            public void messageReceived(String string) {
                stringBuffer.append(string);
            }
        };
        this.mDB.addListener(messageListener);
        try {
            dataholder = this.mDB.runClassMethod(string, string2, dataholderArray, 0);
        }
        finally {
            this.mDB.removeListener(messageListener);
        }
        this.mDB.parseStatus(dataholder);
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString());
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public void unregisterGlobalForClass(String string) throws CacheException {
        if (!CompiledClass.exists((Database)this.mDB, new Id("%ExtentMgr.Util"))) {
            return;
        }
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string)};
        int[] nArray = new int[]{};
        String string2 = "%ExtentMgr.Util";
        String string3 = "DeleteExtent";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string2, string3, nArray, dataholderArray, 0);
        this.mDB.parseStatus(dataholderArray2[0]);
    }

    public void importDir(String string, String string2) throws CacheException {
        string2 = DatabaseUtilities.setFlags(string2);
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string), new Dataholder(string2), new Dataholder(24, null)};
        int[] nArray = new int[]{3};
        String string3 = "%SYSTEM.OBJ";
        String string4 = "LoadDir";
        Dataholder[] dataholderArray2 = this.mDB.runClassMethod(string3, string4, nArray, dataholderArray, 0);
        try {
            this.mDB.parseStatus(dataholderArray2[0]);
        }
        catch (CacheException cacheException) {
            String string5 = dataholderArray2[1].getString();
            throw new CacheException(cacheException, "Failed to import directory " + string + " message: " + cacheException.getMessage() + " errorlog: " + string5);
        }
    }

    public static void compileJavaClasses(String[] stringArray, String string, String string2, String string3) throws ClassNotFoundException {
        JavaCompiler.compile(stringArray, string, string2, string3, null);
    }

    public static void compileJavaClasses(String[] stringArray, String string, String string2, String string3, PrintStream printStream) throws ClassNotFoundException {
        JavaCompiler.compile(stringArray, string, string2, string3, printStream);
    }

    public static void compileJavaClass(String string, String string2, String string3, String string4) throws ClassNotFoundException {
        DatabaseUtilities.compileJavaClass(string, string2, string3, string4, null);
    }

    public static void compileJavaClass(String string, String string2, String string3, String string4, PrintStream printStream) throws ClassNotFoundException {
        String[] stringArray = new String[]{string};
        JavaCompiler.compile(stringArray, string2, string3, string4, printStream);
    }

    public static File findFile(File file, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        File file2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                string3 = string3 + "." + string2;
            }
            file2 = new File(file2 == null ? file : file2, string3);
        }
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    protected static String setFlags(String string) {
        int n = string.indexOf("+d");
        if (n >= 0) {
            return string;
        }
        n = string.indexOf("-d");
        if (n < 0) {
            string = "-d," + string;
        }
        return string;
    }

    protected static String normalizePath(String string) {
        if (File.separatorChar == '/') {
            return string.replace('\\', File.separatorChar);
        }
        if (File.separatorChar == '\\') {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    private boolean serverSupportsLocal() throws CacheException {
        ObjectServerInfo objectServerInfo = this.mDB.getServerInfo();
        if (objectServerInfo.getMajorObjectVersion() < 5) {
            return false;
        }
        if (objectServerInfo.getMajorObjectVersion() > 5) {
            return true;
        }
        if (objectServerInfo.getMinorObjectVersion() >= 1) {
            return true;
        }
        return objectServerInfo.getMajorObjectBuildNumber() > 1908;
    }
}

