/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc.preparser2;

import com.intersys.jdbc.ListUtil;
import com.intersys.jdbc.preparser2.CacheSqlPreParserTokenManager;

public class Token {
    private static final int POOL_SIZE = 32;
    private static boolean expandable = false;
    protected String buffer;
    private int bufLen;
    public int kind;
    public int beginLine;
    public int beginColumn;
    public int endLine;
    public int endColumn;
    public String image;
    public Token next;
    public Token specialToken;
    private static int counter = 0;
    private static Token[] tBuffer = null;
    public int format = 0;
    public static final int CAST_CHAR32 = 1;
    public static final int CAST_CHAR128 = 2;
    public static final int CAST_CHAR512 = 3;
    public static final int CAST_CHAR = 4;
    public static final int CAST_INT = 10;
    public static final int CAST_NUM = 11;
    public boolean isParam = false;
    public char paramType = '\u0000';

    public Token() {
        this.buffer = CacheSqlPreParserTokenManager.input_stream.buffer;
        this.bufLen = this.buffer.length();
    }

    public Token(String string) {
        this.buffer = string;
        this.bufLen = this.buffer.length();
    }

    public int getLength() {
        return this.endColumn - this.beginColumn;
    }

    public String toString() {
        if (this.image == null) {
            this.image = this.beginColumn >= this.bufLen ? "<EOS>" : (this.endColumn >= this.bufLen ? this.buffer.substring(this.beginColumn, this.bufLen - 1) : this.buffer.substring(this.beginColumn, this.endColumn + 1));
        }
        return this.image;
    }

    public String toCanonizedFloatingPointString() {
        return ListUtil.canonizeFloatingPointString(this.buffer.substring(this.beginColumn, this.endColumn + 1));
    }

    public String toStringUnQuoted() {
        char c = this.buffer.charAt(this.beginColumn);
        if (c == '\'' || c == '\"') {
            return this.buffer.substring(this.beginColumn + 1, this.endColumn);
        }
        return this.buffer.substring(this.beginColumn, this.endColumn + 1);
    }

    public String getTDSValue() {
        int n = this.buffer.indexOf(123, this.beginColumn);
        if (n < 0) {
            return null;
        }
        if ((n = this.buffer.indexOf(39, n)) < 0) {
            return null;
        }
        int n2 = this.buffer.indexOf(39, n + 1);
        while (n2 > 0 && n2 + 1 < this.endColumn && this.buffer.charAt(n2 + 1) == '\'') {
            n2 = this.buffer.indexOf(39, n2 + 2);
        }
        if (n2 < 0) {
            return null;
        }
        return this.buffer.substring(n + 1, n2);
    }

    public static final Token newToken(int n) {
        switch (n) {
            default: 
        }
        Token token = Token.getToken();
        token.buffer = CacheSqlPreParserTokenManager.input_stream.buffer;
        token.bufLen = token.buffer.length();
        return token;
    }

    public static final Token newToken(int n, String string) {
        switch (n) {
            default: 
        }
        Token token = Token.getToken();
        token.buffer = string;
        token.bufLen = token.buffer.length();
        return token;
    }

    public void prepend(Token token) {
        this.beginColumn = token.beginColumn;
    }

    public static void setExpandable(boolean bl) {
        expandable = bl;
    }

    private static Token getToken() {
        if (tBuffer == null) {
            tBuffer = new Token[32];
            for (int i = 0; i < tBuffer.length; ++i) {
                Token.tBuffer[i] = new Token();
            }
            counter = 0;
        }
        if (expandable) {
            if (counter >= tBuffer.length) {
                Token.resizePool();
            }
            if (tBuffer[counter] == null) {
                Token.tBuffer[Token.counter] = new Token();
            }
        } else if (counter >= tBuffer.length) {
            counter = 0;
        }
        Token.tBuffer[Token.counter].next = null;
        Token.tBuffer[Token.counter].isParam = false;
        Token.tBuffer[Token.counter].format = 0;
        Token.tBuffer[Token.counter].paramType = '\u0000';
        return tBuffer[counter++];
    }

    private static void resizePool() {
        int n = tBuffer.length * 2;
        Token[] tokenArray = new Token[n];
        System.arraycopy(tBuffer, 0, tokenArray, 0, tBuffer.length);
        tBuffer = tokenArray;
    }

    public static void reinit() {
        counter = 0;
    }

    public static int getPoolSize() {
        return tBuffer.length;
    }
}

