/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.RealStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class CacheWriter
extends Writer {
    private RealStream stream;
    private char[] charArray = null;
    private long position;

    public CacheWriter(RealStream realStream, long l) {
        this.stream = realStream;
        this.position = l;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.stream.closed) {
            throw new IOException("This stream object is closed");
        }
        if (this.charArray == null) {
            this.charArray = new char[n2];
            System.arraycopy(cArray, n, this.charArray, 0, n2);
        } else {
            char[] cArray2 = new char[n2 + this.charArray.length];
            System.arraycopy(this.charArray, 0, cArray2, 0, this.charArray.length);
            System.arraycopy(cArray, n, cArray2, this.charArray.length, n2);
            this.charArray = cArray2;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            byte[] byArray = new String(this.charArray).getBytes();
            this.stream.sendBytes(this.position, byArray, 0, byArray.length);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

