/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheStaticResultSet;
import com.intersys.jdbc.CacheUpdatableResultSet;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.ExecParameter;
import com.intersys.jdbc.FakeStream;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.PreparserInterface;
import com.intersys.jdbc.RealStream;
import com.intersys.jdbc.SysList;
import com.intersys.jdbc.preparser2.StatementTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class CacheStatement
implements Statement {
    int maxRows = 0;
    boolean genericExecuteCalled = false;
    CacheConnection connection;
    CacheResultSet myResultSet = null;
    Vector columns;
    Vector parameters;
    int serverCursorNumber = 0;
    int statementType;
    boolean fetchDone = false;
    InStream input;
    OutStream output;
    String sqlText;
    String originalSqlText;
    int hasReturnValue;
    int resultSetType = 1003;
    int resultSetConcurrency;
    int fetchSize = 0;
    int parameterSets = 0;
    int batchCount = 0;
    SysList outputParameterList;
    SysList batch = null;
    SysList additionalParameterInfo;
    String batchException = "none";
    boolean closed = false;
    int updateCnt;
    String autoGeneratedKeyColumn = null;
    boolean multipleResultSets = false;
    int queryTimeout = 0;
    String updatableRSTableName = null;
    String[] updatableRSColumnNames = null;
    boolean poolable = true;
    boolean namedParameters = false;
    ArrayList execParams = null;
    static final int NO_RETURN_VALUE = 0;
    static final int IGNORE_RETURN_VALUE = 1;
    static final int HAS_RETURN_VALUE = 2;
    static final int NULL_RETURN_VALUE = 3;
    static final String BATCH_EXCEPTION_NONE = "none";
    static final String BATCH_EXCEPTION_QUERY = "query";
    static final String BATCH_EXCEPTION_SP = "stored procedure";
    boolean parameterListMismatchException = false;
    static final int UPDATE = 0;
    static final int QUERY = 1;
    static final int CALL = 2;
    static final int SYNC_COMMIT = 3;
    static final int ASYNC_COMMIT = 4;
    static final int STREAMS_OFF = 5;
    static final int STREAMS_ON = 6;
    static final int CALLWITHRESULT = 7;
    static final int DDL_ALTER_DROP = 8;
    static final int DDL_OTHER = 9;
    static final int DIRECT_CALL_QUERY = 10;
    static final int DIRECT_CALL_UPDATE = 11;
    static final int PREPARED_CALL_QUERY = 12;
    static final int PREPARED_CALL_UPDATE = 13;

    CacheStatement(CacheConnection cacheConnection, int n, int n2, String string) throws SQLException {
        this.connection = cacheConnection;
        this.parameters = new Vector();
        try {
            this.input = new InStream(this.connection);
            this.input.wire.setConnectionInfo(this.connection.connectionInfo);
            this.output = new OutStream(this.connection);
            this.output.wire.setConnectionInfo(this.connection.connectionInfo);
        }
        catch (IOException iOException) {
            throw new SQLException("Communication link failure: " + iOException.getMessage(), "08S01", 461);
        }
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.serverCursorNumber = 0;
        this.updateCnt = 0;
        this.autoGeneratedKeyColumn = string;
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (string.equals("**getQuickStatement**")) {
            this.columns = new Vector();
            this.myResultSet = new CacheResultSet(this);
            return this.myResultSet;
        }
        this.genericExecuteCalled = false;
        this.Query(string);
        if (this.multipleResultSets) {
            this.columnInfo(this.input.wire);
        }
        this.myResultSet = this.createResultSet();
        this.updateCnt = -1;
        return this.myResultSet;
    }

    CacheResultSet createResultSet() throws SQLException {
        if (this.resultSetConcurrency == 1008) {
            return new CacheUpdatableResultSet(this);
        }
        if (this.resultSetType == 1004) {
            return new CacheStaticResultSet(this);
        }
        return new CacheResultSet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Query(String string) throws SQLException {
        if (!this.genericExecuteCalled) {
            this.cleanUp();
            this.preparse(string);
        }
        this.fetchDone = false;
        if (this.statementType != 1 && this.statementType != 2) {
            throw new SQLException("executeQuery called with a non-query", "24000", 24000);
        }
        if (this.execParams != null) {
            this.prepareStoredProcedure();
            this.bindExecParameters();
            if (this.statementType == 11 || this.statementType == 13) {
                throw new SQLException("executeQuery called with a non-query", "24000", 24000);
            }
            if (this.statementType == 10 || this.statementType == 12) {
                this.storedProcedureQuery();
            }
            return;
        }
        this.validateParameters();
        if (this.statementType == 2) {
            this.executeStoredProcedure();
            if (this.statementType != 10) {
                throw new SQLException("executeQuery called with a non-query", "24000", 24000);
            }
            return;
        }
        if (this.getCachedInfo(this.sqlText)) {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                if (this.resultSetType == 1004) {
                    this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.EXECUTE_STATIC_CURSOR);
                } else {
                    this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_QUERY_EXECUTE);
                }
                this.writeParameters(this.output.wire);
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
                this.output.send(this.connection.messageCount.getCount());
                this.handleError504(this.input.readHeader(this.serverCursorNumber, 0, 504));
            }
        } else {
            this.sendDirectQueryRequest();
        }
    }

    void handleError504(int n) throws SQLException {
        if (n == 404) {
            this.query404();
        } else if (n == 100) {
            this.fetchDone = true;
            if (this.containsStreamFields()) {
                this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
            } else {
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
        } else {
            this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
        }
    }

    void bindExecParameters() throws SQLException {
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = (Parameter)this.parameters.elementAt(i);
            ExecParameter execParameter = this.getExecParamByName(parameter.name);
            if (execParameter != null) {
                if (execParameter.mode == 0) continue;
                parameter.mode = execParameter.mode;
                if (execParameter.mode != 4) {
                    parameter.bind(execParameter.value, null, this.parameterSets);
                } else {
                    parameter.bound = execParameter.bound;
                }
                if (execParameter.scale == -1) continue;
                parameter.scale = execParameter.scale;
                continue;
            }
            if (parameter.mode != 0) continue;
            parameter.mode = 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendDirectQueryRequest() throws SQLException {
        int n;
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            if (this.resultSetType == 1004) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_STATIC_CURSOR);
            } else {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_QUERY);
            }
            this.output.wire.setSQLText(this.sqlText);
            if (this.connection.protocolVersion >= 45) {
                this.output.wire.append(this.additionalParameterInfo);
            }
            this.writeParameters(this.output.wire);
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.output.send(this.connection.messageCount.getCount());
            n = this.input.readHeader(this.serverCursorNumber, 0, 100);
            this.columnInfo(this.input.wire);
            this.parameterInfo(this.input.wire);
            if (this.resultSetType != 1003) {
                if (n == 100) {
                    this.fetchDone = true;
                }
                if (this.connection.protocolVersion >= 44) {
                    this.connection.recycledServerCursorNumber = this.serverCursorNumber;
                }
                return;
            }
            n = this.input.readHeader(this.serverCursorNumber, 0, 100);
        }
        if (n == 100) {
            this.fetchDone = true;
            if (this.containsStreamFields()) {
                this.connection.addCachedPrepare(this, true);
            } else {
                this.connection.addCachedPrepare(this, false);
            }
        } else {
            this.connection.addCachedPrepare(this, true);
        }
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        this.genericExecuteCalled = false;
        this.Update(string);
        if (this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        return this.updateCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Update(String string) throws SQLException {
        if (!this.genericExecuteCalled) {
            this.cleanUp();
            this.preparse(string);
        }
        if (this.statementType == 1) {
            throw new SQLException("executeUpdate called with a query", "24000", 24000);
        }
        if (this.execParams != null) {
            this.prepareStoredProcedure();
            this.bindExecParameters();
            if (this.statementType == 11 || this.statementType == 13) {
                this.storedProcedureUpdate();
            } else if (this.statementType == 10 || this.statementType == 12) {
                throw new SQLException("executeUpdate called with a query", "24000", 24000);
            }
            return;
        }
        this.validateParameters();
        if (this.statementType == 2) {
            this.executeStoredProcedure();
            if (this.statementType == 10) {
                throw new SQLException("executeUpdate called with a query", "24000", 24000);
            }
            return;
        }
        if (this.statementType != 8 && this.statementType != 9 && this.getCachedInfo(this.sqlText)) {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_UPDATE_EXECUTE);
                this.output.wire.set(this.autoGeneratedKeyColumn);
                if (this.connection.protocolVersion >= 42) {
                    this.output.wire.set(0);
                }
                this.writeParameters(this.output.wire);
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readHeader(this.serverCursorNumber, 0, 504) == 404) {
                    this.update404();
                }
            }
        } else {
            this.sendDirectUpdateRequest();
        }
        this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendDirectUpdateRequest() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_UPDATE);
            this.output.wire.setSQLText(this.sqlText);
            if (this.connection.protocolVersion >= 45) {
                this.output.wire.append(this.additionalParameterInfo);
            }
            this.output.wire.set(this.autoGeneratedKeyColumn);
            if (this.connection.protocolVersion >= 42) {
                this.output.wire.set(0);
            }
            this.writeParameters(this.output.wire);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readHeader(this.serverCursorNumber, 0, 100);
            this.parameterInfo(this.input.wire);
        }
        if (this.statementType != 8 && this.statementType != 9) {
            this.connection.addCachedPrepare(this, false);
        } else if (this.connection.protocolVersion >= 44) {
            this.connection.recycledServerCursorNumber = this.serverCursorNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.connection.protocolVersion >= 40 && this.statementType != 0 && (this.connection.noOwner(this.serverCursorNumber) || this.connection.isOwner(this.serverCursorNumber, this))) {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.CLOSE_STATEMENT);
                this.output.send(this.connection.messageCount.getCount());
            }
            if (this.connection.protocolVersion >= 44) {
                this.connection.cachedPrepares.remove(new Integer(this.serverCursorNumber));
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
            }
        }
        this.fetchDone = false;
        this.genericExecuteCalled = false;
        this.maxRows = 0;
        this.fetchSize = 0;
        this.parameterSets = 0;
        this.batchCount = 0;
        this.batch = null;
        this.batchException = BATCH_EXCEPTION_NONE;
        if (this.parameters != null) {
            this.parameters.removeAllElements();
        }
        if (this.columns != null) {
            this.columns.removeAllElements();
        }
        if (this.myResultSet != null) {
            this.myResultSet.close();
        }
        if (!this.connection.isClosed()) {
            this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            this.connection.poolStatement(this);
        }
        this.updateCnt = 0;
        this.autoGeneratedKeyColumn = null;
        this.updatableRSTableName = null;
        this.updatableRSColumnNames = null;
        this.multipleResultSets = false;
        this.sqlText = null;
        this.serverCursorNumber = 0;
        this.statementType = 0;
        this.namedParameters = false;
        this.parameterListMismatchException = false;
        if (this.additionalParameterInfo != null) {
            this.additionalParameterInfo.clearList();
        }
        if (this.outputParameterList != null) {
            this.outputParameterList.clearList();
        }
        this.execParams = null;
        this.closed = true;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.input.wire.getMaxFieldSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        Object object = this.input;
        synchronized (object) {
            this.input.wire.setMaxFieldSize(n);
        }
        object = this.output;
        synchronized (object) {
            this.output.wire.setMaxFieldSize(n);
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Invalid number of rows specified: " + n, "S1000");
        }
        this.maxRows = n;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    @Override
    public void setCursorName(String string) throws SQLException {
    }

    private synchronized boolean executeStoredProcedure() throws SQLException {
        if (this.getCachedInfo(this.sqlText)) {
            if (this.statementType == 0 || this.statementType == 11 || this.statementType == 13) {
                this.storedProcedureUpdate();
                return false;
            }
            this.storedProcedureQuery();
            return true;
        }
        return this.directExecuteStoredProcedure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean directExecuteStoredProcedure() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_STORED_PROCEDURE);
            this.output.wire.set(this.sqlText);
            if (this.connection.protocolVersion >= 42) {
                if (this.resultSetType == 1004) {
                    this.output.wire.set(1);
                } else {
                    this.output.wire.set(0);
                }
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.writeStoredProcedureParameters();
            if (this.connection.protocolVersion < 42) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            int n = this.input.readHeader(this.serverCursorNumber, 0, 100);
            this.processStoredProcedureMetaData(this.input.wire, true);
            this.connection.addCachedPrepareNoUpdate(this, true);
            if (n == 100) {
                this.handleError100(100);
                return true;
            }
            if (this.multipleResultSets) {
                return this.executeMultipleResultSets(false);
            }
            this.getOutputParameters();
            if (this.statementType == 0 || this.statementType == 11 || this.statementType == 13) {
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
                return false;
            }
            if (this.resultSetType == 1003) {
                this.handleError100(this.input.readHeader(this.serverCursorNumber, 0, 100));
            }
            return true;
        }
    }

    void handleError100(int n) throws SQLException {
        if (n == 100) {
            this.fetchDone = true;
            if (this.containsStreamFields()) {
                this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
            } else {
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
        } else {
            this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        this.cleanUp();
        this.updateCnt = 0;
        this.preparse(string);
        this.genericExecuteCalled = true;
        if (this.statementType == 1) {
            this.Query(string);
            this.updateCnt = -1;
            return true;
        }
        if (this.statementType == 7) {
            throw new SQLException("No output parameters allowed");
        }
        if (this.statementType == 2) {
            if (this.executeStoredProcedure()) {
                return true;
            }
            if (this.parameterSets == 0) {
                this.updateCnt = this.input.wire.getInt();
            }
            return false;
        }
        this.Update(string);
        if (this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        return false;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (!this.genericExecuteCalled || this.statementType != 1 && this.statementType != 10 && this.statementType != 12) {
            return null;
        }
        if (this.multipleResultSets) {
            if (this.myResultSet == null && this.updateCnt == -1) {
                return null;
            }
            this.columnInfo(this.input.wire);
        } else {
            this.genericExecuteCalled = false;
        }
        this.myResultSet = this.createResultSet();
        return this.myResultSet;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.statementType == 1 || this.statementType == 10 || this.statementType == 12) {
            return -1;
        }
        if (!this.multipleResultSets) {
            this.genericExecuteCalled = false;
        }
        int n = this.updateCnt;
        this.updateCnt = -1;
        return n;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    int getColumnType(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).type;
    }

    String getColumnName(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).name;
    }

    String getColumnLabel(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).label;
    }

    String getColumnTableName(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).tableName;
    }

    String getColumnSchemaName(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).schema;
    }

    String getColumnCatalogName(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).catalog;
    }

    int getColumnPrecision(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).precision;
    }

    int getColumnScale(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).scale;
    }

    int getColumnNullable(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).nullable;
    }

    boolean isReadOnly(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isReadOnly;
    }

    boolean isAutoIncrement(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isAutoIncrement;
    }

    boolean isRowId(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isRowId;
    }

    boolean isCaseSensitive(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isCaseSensitive;
    }

    boolean isCurrency(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isCurrency;
    }

    int getParameterMode(int n) {
        return ((Parameter)this.parameters.elementAt((int)n)).mode;
    }

    boolean isOutParameter(int n) {
        int n2 = ((Parameter)this.parameters.elementAt((int)n)).mode;
        return n2 == 2 || n2 == 4;
    }

    private void isNotDefaultOrReplaced(int n) throws SQLException {
        int n2 = ((Parameter)this.parameters.elementAt((int)n)).mode;
        if (n2 != 5 && n2 != 6) {
            throw new SQLException("Parameters not allowed in Statement class", "07001", 7001);
        }
    }

    private int getAbsolutePosition(int n) throws SQLException {
        --n;
        int n2 = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (((Parameter)this.parameters.elementAt((int)i)).mode == 5) continue;
            if (n == n2) {
                return i;
            }
            ++n2;
        }
        throw new SQLException("Invalid parameter number: " + n, "S1093", 466);
    }

    int getParameterTypeAbsolute(int n) throws SQLException {
        return ((Parameter)this.parameters.elementAt((int)this.getAbsolutePosition((int)n))).type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParameterModeAndScale(int n, int n2) {
        this.setParameterMode(n);
        Vector vector = this.parameters;
        synchronized (vector) {
            ((Parameter)this.parameters.elementAt((int)n)).scale = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParameterMode(int n) {
        Vector vector = this.parameters;
        synchronized (vector) {
            Parameter parameter = (Parameter)this.parameters.elementAt(n);
            parameter.mode = parameter.mode == 1 || parameter.mode == 2 ? 2 : 4;
            parameter.bound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindParameter(int n) throws SQLException {
        Vector vector = this.parameters;
        synchronized (vector) {
            Parameter parameter = (Parameter)this.parameters.elementAt(n);
            if (parameter.mode != 5 && parameter.mode != 6) {
                parameter.bound = false;
                parameter.mode = 0;
                parameter.values.clear();
                parameter.whatever.clear();
            }
        }
    }

    synchronized void multipleResultSetsMetaData(SysList sysList, boolean bl, boolean bl2) throws SQLException {
        this.multipleResultSets = true;
        if (!this.storedProcedureParameterInfo(sysList, bl, bl2)) {
            throw new SQLException("Parameter list mismatch", "07001", 7001);
        }
        this.statementType = this instanceof CacheCallableStatement ? 1 : (this instanceof CachePreparedStatement ? 12 : 10);
    }

    synchronized void processStoredProcedureMetaData(SysList sysList, boolean bl) throws SQLException {
        this.statementType = sysList.getInt();
        if (this.statementType < 0) {
            if (this.statementType == -1) {
                this.multipleResultSetsMetaData(sysList, false, bl);
            } else {
                this.multipleResultSetsMetaData(sysList, true, bl);
            }
            return;
        }
        if (this.statementType % 2 == 1) {
            this.columnInfo(sysList);
        }
        if (!this.storedProcedureParameterInfo(sysList, this.statementType > 1, bl)) {
            if (bl && this.statementType % 2 == 1) {
                if (this.resultSetType == 1003) {
                    this.handleError100(this.input.readHeader(this.serverCursorNumber, 0, 100));
                }
                this.input.wire.moveToEnd();
            }
            if (bl) {
                throw new SQLException("Parameter list mismatch", "07001", 7001);
            }
        }
        if (bl && this.parameterListMismatchException) {
            throw new SQLException("Parameter list mismatch", "07001", 7001);
        }
        if (this instanceof CacheCallableStatement) {
            this.statementType %= 2;
            return;
        }
        if (this instanceof CachePreparedStatement) {
            this.statementType = this.statementType % 2 == 1 ? 12 : 13;
            return;
        }
        this.statementType = this.statementType % 2 == 1 ? 10 : 11;
    }

    void columnInfo(SysList sysList) throws SQLException {
        int n = sysList.getInt();
        this.columns = new Vector(n);
        if (n <= 0) {
            return;
        }
        for (int i = 1; i <= n; ++i) {
            Column column = new Column();
            column.name = sysList.getString();
            column.type = sysList.getInt();
            if (column.type == 9) {
                column.type = 91;
            } else if (column.type == 10) {
                column.type = 92;
            } else if (column.type == 11) {
                column.type = 93;
            }
            column.precision = sysList.getInt();
            column.scale = sysList.getInt();
            column.nullable = sysList.getInt();
            column.label = sysList.getString();
            column.tableName = sysList.getString();
            column.schema = sysList.getString();
            column.catalog = sysList.getString();
            if (this.connection.protocolVersion > 40) {
                String string = sysList.getString();
                column.isAutoIncrement = string.charAt(0) == '\u0001';
                column.isCaseSensitive = string.charAt(1) == '\u0001';
                column.isCurrency = string.charAt(2) == '\u0001';
                boolean bl = column.isReadOnly = string.charAt(3) == '\u0001';
                if (string.length() >= 12) {
                    column.isRowId = string.charAt(11) == '\u0001';
                }
            }
            this.columns.addElement(column);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean storedProcedureParameterInfo(SysList sysList, boolean bl, boolean bl2) throws SQLException {
        int n;
        block17: {
            int n2;
            block21: {
                block23: {
                    block22: {
                        block19: {
                            block20: {
                                block18: {
                                    n = sysList.getInt();
                                    if (!(this instanceof CacheCallableStatement) && this.hasReturnValue == 1) {
                                        sysList.moveToEnd();
                                        return false;
                                    }
                                    if (this.execParams == null) break block18;
                                    for (n2 = this.parameters.size(); n2 < n; ++n2) {
                                        this.parameters.add(0, new Parameter());
                                    }
                                    if (bl) {
                                        this.hasReturnValue = 1;
                                    }
                                    break block17;
                                }
                                if (n2 != n) break block19;
                                if (!bl || this.hasReturnValue != 2) break block20;
                                this.hasReturnValue = 2;
                                break block17;
                            }
                            if (!bl && this.hasReturnValue == 0) {
                                this.hasReturnValue = 0;
                                break block17;
                            } else if (n2 == 1 && n == 1 && this.getParameterMode(0) == 6 && this.hasReturnValue == 0 && bl || this.getParameterMode(0) == 0 && this.hasReturnValue == 1 && bl) {
                                this.parameters.remove(0);
                                this.parameters.add(0, new Parameter());
                                this.hasReturnValue = 1;
                                break block17;
                            } else {
                                sysList.moveToEnd();
                                return false;
                            }
                        }
                        if (n2 != n + 1) break block21;
                        if (bl || this.hasReturnValue != 2) break block22;
                        this.hasReturnValue = 3;
                        break block17;
                    }
                    if ((n2 != 2 || n != 1) && (n2 != 1 || n != 0)) break block23;
                    if (this.getParameterMode(n2 - 1) != 6) {
                        sysList.moveToEnd();
                        return false;
                    }
                    if (bl && this.hasReturnValue == 2) {
                        this.parameters.remove(n2 - 1);
                        this.hasReturnValue = 2;
                        break block17;
                    } else if (!bl && this.hasReturnValue == 0) {
                        this.parameters.remove(n2 - 1);
                        this.hasReturnValue = 0;
                        break block17;
                    } else {
                        sysList.moveToEnd();
                        return false;
                    }
                }
                sysList.moveToEnd();
                return false;
            }
            if (n2 == n - 1) {
                if (bl && this.hasReturnValue == 0) {
                    this.parameters.add(0, new Parameter());
                    this.hasReturnValue = 1;
                    break block17;
                } else {
                    sysList.moveToEnd();
                    return false;
                }
            }
            this.parameterListMismatchException = true;
            if (bl && this.hasReturnValue == 0) {
                this.hasReturnValue = 1;
            }
            while (n2 < n) {
                this.parameters.add(0, new Parameter());
                ++n2;
            }
        }
        this.readParameterData(sysList, n, true);
        return true;
    }

    void parameterInfo(SysList sysList) throws SQLException {
        int n = sysList.getInt();
        if (n != this.parameters.size()) {
            throw new SQLException("Invalid number of parameters", "07001", 7001);
        }
        this.readParameterData(sysList, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readParameterData(SysList sysList, int n, boolean bl) throws SQLException {
        Vector vector = this.parameters;
        synchronized (vector) {
            for (int i = 0; i < n; ++i) {
                Parameter parameter = (Parameter)this.parameters.elementAt(i);
                parameter.type = sysList.getInt();
                if (parameter.type == 9) {
                    parameter.type = 91;
                } else if (parameter.type == 10) {
                    parameter.type = 92;
                } else if (parameter.type == 11) {
                    parameter.type = 93;
                }
                parameter.precision = sysList.getInt();
                parameter.scale = sysList.getInt();
                parameter.nullable = sysList.getInt();
                if (!bl) continue;
                parameter.name = sysList.getString();
                sysList.getInt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean getCachedInfo(String string) throws SQLException {
        if (this.resultSetType != 1003) {
            return false;
        }
        boolean bl = false;
        CacheConnection.CachedPrepare cachedPrepare = null;
        HashMap hashMap = this.connection.cachedPrepares;
        synchronized (hashMap) {
            for (Object k : this.connection.cachedPrepares.keySet()) {
                cachedPrepare = (CacheConnection.CachedPrepare)this.connection.cachedPrepares.get(k);
                if (!cachedPrepare.matches(this) || cachedPrepare.ownedBy != null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.connection.cachedPrepares.size() >= 500) {
                    this.connection.updateCache();
                }
                return false;
            }
            this.serverCursorNumber = cachedPrepare.serverCursorNumber;
            if (this.serverCursorNumber == this.connection.recycledServerCursorNumber) {
                this.connection.recycledServerCursorNumber = -1;
            }
            if (this.statementType == 2 || this.statementType == 7) {
                if (this.parameters.size() != cachedPrepare.parameters.size()) {
                    return false;
                }
                this.statementType = cachedPrepare.statementType;
                this.hasReturnValue = cachedPrepare.hasReturnValue;
                this.multipleResultSets = cachedPrepare.multipleResultSets;
                if (!(this.multipleResultSets || this.statementType != 1 && this.statementType != 12 && this.statementType != 10)) {
                    this.columns = (Vector)cachedPrepare.columns.clone();
                }
            } else if (this.statementType == 1) {
                this.columns = (Vector)cachedPrepare.columns.clone();
            }
            this.updateParameterInfo(cachedPrepare.parameters);
            cachedPrepare.ownedBy = this;
            return true;
        }
    }

    PreparserInterface preparseAddID(String string) throws SQLException {
        PreparserInterface preparserInterface = null;
        preparserInterface = this.connection.protocolVersion < 45 ? PreparserInterface.createPreparser(string, this.connection.delimitedIds == 1, 1) : PreparserInterface.createPreparser(string, this.connection.delimitedIds == 1, 2);
        try {
            preparserInterface.preparse();
        }
        catch (Throwable throwable) {
            throw new SQLException("SQL preparser error:\n" + throwable.getMessage());
        }
        if (preparserInterface.getStatementType() != 1) {
            this.originalSqlText = string;
            return preparserInterface;
        }
        this.statementType = 1;
        this.updateParameters(preparserInterface);
        this.sqlText = preparserInterface.getPreparsedSQL();
        this.additionalParameterInfo = preparserInterface.getParamInfo();
        this.originalSqlText = string;
        return null;
    }

    void preparse(String string, int n, long l) throws SQLException {
        this.statementType = n;
        this.sqlText = string;
        int n2 = 1;
        while ((long)n2 < l) {
            this.parameters.addElement(new Parameter());
            ++n2;
        }
    }

    void preparse(String string) throws SQLException {
        PreparserInterface preparserInterface = null;
        CacheConnection.CachedSQL cachedSQL = (CacheConnection.CachedSQL)this.connection.prePreparseCache.get(string);
        if (cachedSQL != null && cachedSQL.resultSetConcurrency == this.resultSetConcurrency) {
            this.hasReturnValue = cachedSQL.hasReturnValue;
            this.createParameterInfo(cachedSQL.parameters);
            this.sqlText = cachedSQL.sqlText;
            this.statementType = cachedSQL.statementType;
            this.additionalParameterInfo = cachedSQL.additionalParameterInfo.cloneMe();
            return;
        }
        if (this.resultSetConcurrency == 1008) {
            preparserInterface = this.preparseAddID(string);
            if (preparserInterface == null) {
                return;
            }
            this.additionalParameterInfo = preparserInterface.getParamInfo();
        }
        try {
            if (preparserInterface == null) {
                preparserInterface = PreparserInterface.createPreparser(string, this.connection.delimitedIds == 1, 0);
                preparserInterface.preparse();
                this.execParams = preparserInterface.getExecParams();
                this.additionalParameterInfo = preparserInterface.getParamInfo();
            }
            this.statementType = 0;
            switch (preparserInterface.getStatementType()) {
                case 0: {
                    this.statementType = 0;
                    this.sqlText = string;
                    return;
                }
                case 1: {
                    this.statementType = 1;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.statementType = 0;
                    break;
                }
                case 5: {
                    this.statementType = 2;
                    this.hasReturnValue = 0;
                    break;
                }
                case 6: {
                    this.statementType = 7;
                    this.hasReturnValue = 2;
                    break;
                }
                case 12: {
                    this.statementType = 4;
                    break;
                }
                case 11: {
                    this.statementType = 3;
                    break;
                }
                case 13: {
                    this.statementType = 5;
                    break;
                }
                case 14: {
                    this.statementType = 6;
                    break;
                }
                case 9: {
                    this.statementType = 8;
                    this.sqlText = string;
                    return;
                }
                case 10: {
                    this.statementType = 9;
                    this.sqlText = string;
                    return;
                }
            }
            this.updateParameters(preparserInterface);
            this.sqlText = preparserInterface.getPreparsedSQL();
            this.connection.addPrePreparseCache(string, this);
        }
        catch (Throwable throwable) {
            throw new SQLException("SQL preparser error:\n" + throwable.getMessage(), "42000", 51);
        }
    }

    void updateParameters(PreparserInterface preparserInterface) {
        if (preparserInterface.getParametersCount() == 0) {
            return;
        }
        block5: for (StatementTypes.Parameter parameter : preparserInterface.getParameters()) {
            switch (parameter.type) {
                case '?': {
                    this.parameters.addElement(new Parameter());
                    continue block5;
                }
                case 'd': {
                    this.parameters.addElement(new Parameter(6));
                    continue block5;
                }
                case 'c': {
                    this.parameters.addElement(new Parameter(parameter.value));
                    continue block5;
                }
            }
            throw new Error("Should not have gotten here...");
        }
    }

    void validateParameters() throws SQLException {
        if (this.parameterListMismatchException && !this.namedParameters) {
            throw new SQLException("Parameter list mismatch", "07001", 7001);
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.isNotDefaultOrReplaced(i);
        }
    }

    synchronized void writeParameters(SysList sysList) throws SQLException {
        int n = this.parameterSets;
        if (this.parameterSets == 0) {
            n = 1;
        }
        sysList.set(n);
        sysList.set(this.parameters.size());
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.parameters.size(); ++j) {
                Parameter parameter = (Parameter)this.parameters.elementAt(j);
                if (parameter.mode == 5) {
                    sysList.setParameter(parameter.values.elementAt(0));
                    continue;
                }
                if (parameter.mode == 6) {
                    sysList.setUndefined();
                    continue;
                }
                if (parameter.whatever.elementAt(i) == null) {
                    if (parameter.values.elementAt(i) instanceof StreamWrapper) {
                        sysList.setParameter(this.sendStream(j, (StreamWrapper)parameter.values.elementAt(i)));
                        continue;
                    }
                    sysList.setParameter(parameter.values.elementAt(i));
                    continue;
                }
                sysList.setParameter(parameter.values.elementAt(i), parameter.whatever.elementAt(i));
            }
        }
    }

    synchronized Object sendStream(int n, StreamWrapper streamWrapper) throws SQLException {
        int n2 = streamWrapper.length;
        int n3 = ((Parameter)this.parameters.elementAt((int)n)).type;
        try {
            int n4;
            if (streamWrapper.type != 4 && (n4 = ((InputStream)streamWrapper.data).available()) > 0 && (n2 < 0 || n2 > n4)) {
                n2 = n4;
            }
            if ((n4 = this.output.wire.getMaxFieldSize()) != 0 && n2 > n4) {
                n2 = n4;
            }
            if (n2 == 0) {
                return "";
            }
            if (n3 != -1 && n3 != -4) {
                return FakeStream.sendStream(streamWrapper.data, n2, streamWrapper.type);
            }
            return RealStream.sendStream(this.connection, streamWrapper.data, n2, streamWrapper.type, n3, this.serverCursorNumber);
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing stream: " + iOException.getMessage());
        }
    }

    synchronized void cleanUp() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
        if (this.parameters != null) {
            this.parameters.removeAllElements();
        }
        this.namedParameters = false;
        this.parameterListMismatchException = false;
        this.multipleResultSets = false;
        this.fetchDone = false;
        this.genericExecuteCalled = false;
        this.parameterSets = 0;
        this.updateCnt = 0;
        this.updatableRSTableName = null;
        this.updatableRSColumnNames = null;
        this.execParams = null;
        this.statementType = 0;
    }

    synchronized void query404() throws SQLException {
        this.connection.cachedPrepares.remove(new Integer(this.serverCursorNumber));
        this.validateParameters();
        if (this instanceof CacheCallableStatement || this.statementType == 12) {
            this.directExecuteStoredProcedure();
        } else {
            this.sendDirectQueryRequest();
        }
    }

    synchronized void update404() throws SQLException {
        this.connection.cachedPrepares.remove(new Integer(this.serverCursorNumber));
        this.validateParameters();
        this.resetStreams();
        if (this instanceof CacheCallableStatement || this.statementType == 13) {
            this.directExecuteStoredProcedure();
        } else {
            this.sendDirectUpdateRequest();
        }
    }

    synchronized void resetStreams() throws SQLException {
        try {
            int n = this.parameterSets;
            if (this.parameterSets == 0) {
                n = 1;
            }
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < this.parameters.size(); ++j) {
                    Parameter parameter = (Parameter)this.parameters.elementAt(j);
                    if (parameter.whatever == null || parameter.whatever.isEmpty() || parameter.whatever.elementAt(i) != null || !(parameter.values.elementAt(i) instanceof StreamWrapper)) continue;
                    StreamWrapper streamWrapper = (StreamWrapper)parameter.values.elementAt(i);
                    if (streamWrapper.type == 0 || streamWrapper.type == 1) {
                        ((InputStream)streamWrapper.data).reset();
                        continue;
                    }
                    if (streamWrapper.type != 4) continue;
                    ((Reader)streamWrapper.data).reset();
                }
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Unable to complete a 404-logic request: stream does not support reset");
        }
    }

    synchronized void getOutputParameters() throws SQLException {
        int n = this.input.wire.getCurrentOffset();
        for (int i = 0; i < this.parameters.size(); ++i) {
            try {
                if (this.isOutParameter(i)) {
                    this.input.wire.nextUnlessUndefined();
                    continue;
                }
                this.input.wire.next();
                continue;
            }
            catch (SQLException sQLException) {
                if (sQLException instanceof SysList.NoMoreDataException) continue;
                throw sQLException;
            }
        }
        if (this.hasReturnValue == 3) {
            this.outputParameterList = this.input.wire.getOutputParameterList(n, 1);
            this.hasReturnValue = 2;
        } else {
            this.outputParameterList = this.input.wire.getOutputParameterList(n, 0);
        }
    }

    synchronized void updateResultSet() throws SQLException {
        this.Query(this.originalSqlText);
        this.resultSetConcurrency = 1008;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storedProcedureUpdate() throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.STORED_PROCEDURE_UPDATE_EXECUTE);
            if (this.connection.protocolVersion >= 42) {
                this.output.wire.set(0);
                this.output.wire.set(0);
                this.output.wire.set(this.maxRows);
                this.writeStoredProcedureParameters();
            } else {
                this.writeStoredProcedureParameters();
                this.output.wire.set(0);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readHeader(this.serverCursorNumber, 0, 504) == 404) {
                this.update404();
            } else {
                this.getOutputParameters();
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storedProcedureQuery() throws SQLException {
        if (this.multipleResultSets) {
            this.executeMultipleResultSets(false);
            return;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.STORED_PROCEDURE_QUERY_EXECUTE);
            if (this.connection.protocolVersion >= 42) {
                if (this.resultSetType == 1004) {
                    this.output.wire.set(1);
                } else {
                    this.output.wire.set(0);
                }
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.writeStoredProcedureParameters();
            if (this.connection.protocolVersion < 42) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            int n = this.input.readHeader(this.serverCursorNumber, 0, 504);
            if (n == 404) {
                this.handleError504(404);
                this.getOutputParameters();
                return;
            }
            if (n == 100) {
                this.handleError100(100);
                return;
            }
            this.getOutputParameters();
            this.handleError100(this.input.readHeader(this.serverCursorNumber, 0, 100));
        }
    }

    synchronized void writeStoredProcedureParameters() throws SQLException {
        int n = 0;
        if (this.parameterSets != 0) {
            this.output.wire.set(this.parameterSets);
            this.output.wire.set(this.parameters.size());
            for (int i = 0; i < this.parameterSets; ++i) {
                while (n < this.parameters.size()) {
                    Parameter parameter = (Parameter)this.parameters.elementAt(n);
                    if (parameter.values.elementAt(i) instanceof StreamWrapper) {
                        this.output.wire.setParameter(this.sendStream(n, (StreamWrapper)parameter.values.elementAt(i)));
                    } else {
                        this.output.wire.setParameter(parameter.values.elementAt(i));
                    }
                    ++n;
                }
            }
            return;
        }
        this.output.wire.set(1);
        if (this.hasReturnValue != 0) {
            n = 1;
        }
        this.output.wire.set(this.parameters.size() - n);
        while (n < this.parameters.size()) {
            Parameter parameter = (Parameter)this.parameters.elementAt(n);
            if (parameter.mode == 4 || parameter.mode == 6) {
                this.output.wire.setUndefined();
            } else if (parameter.values.elementAt(0) instanceof StreamWrapper) {
                this.output.wire.setParameter(this.sendStream(n, (StreamWrapper)parameter.values.elementAt(0)));
            } else {
                this.output.wire.setParameter(parameter.values.elementAt(0));
            }
            ++n;
        }
    }

    int getAbsoluteParameterIndex(int n) throws SQLException {
        if (n > this.parameters.size()) {
            throw new SQLException("Invalid parameter number: " + n, "S1093", 466);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        if (this.hasReturnValue == 1) {
            n3 = 1;
            n2 = 1;
        } else {
            --n4;
        }
        while (n3 < this.parameters.size()) {
            if (((Parameter)this.parameters.elementAt((int)n3)).mode != 5) {
                if (n2 == n4) {
                    return n3;
                }
                ++n2;
            }
            ++n3;
        }
        throw new SQLException("Invalid parameter number: " + n, "S1093", 466);
    }

    private int[] computeUpdateCount(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    static void debug(String string) {
        System.out.println(string);
    }

    Vector saveParameterInfo() {
        Vector<Parameter> vector = new Vector<Parameter>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = (Parameter)this.parameters.elementAt(i);
            Object var4_4 = null;
            if (parameter.mode == 5) {
                var4_4 = parameter.values.elementAt(0);
            }
            vector.add(new Parameter(parameter.type, parameter.precision, parameter.scale, parameter.nullable, parameter.name, parameter.mode, var4_4));
        }
        return vector;
    }

    void createParameterInfo(Vector vector) throws SQLException {
        this.parameters = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Parameter parameter = new Parameter();
            parameter.copyCachedInfo((Parameter)vector.elementAt(i), true);
            this.parameters.add(parameter);
        }
    }

    void updateParameterInfo(Vector vector) throws SQLException {
        if (vector.size() != this.parameters.size()) {
            throw new SQLException("Parameter mismatch");
        }
        for (int i = 0; i < vector.size(); ++i) {
            ((Parameter)this.parameters.elementAt(i)).copyCachedInfo((Parameter)vector.elementAt(i), false);
        }
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new SQLException("Unsupported fetch direction", "IM001");
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        int n2 = this.getMaxRows();
        if (n < 0 || n2 != 0 && n > n2) {
            throw new SQLException("Invalid number of rows specified: " + n, "S1000");
        }
        this.fetchSize = n;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
            return;
        }
        this.cleanUp();
        this.preparse(string);
        if (this.statementType == 1) {
            this.batchException = BATCH_EXCEPTION_QUERY;
            return;
        }
        if (this.statementType == 2 || this.statementType == 7) {
            this.batchException = BATCH_EXCEPTION_SP;
            return;
        }
        ++this.batchCount;
        this.validateParameters();
        if (this.batchCount == 1) {
            this.batch = new SysList();
            this.batch.setConnectionInfo(this.connection.connectionInfo);
            this.batch.writeHeader(0, CacheConnection.EXECUTE_STATEMENT_BATCH);
            this.batch.writeBatchCount(-1);
            if (this.connection.protocolVersion >= 42) {
                this.batch.set(0);
            }
        }
        this.batch.setSQLText(this.sqlText);
        this.writeParameters(this.batch);
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this instanceof CachePreparedStatement) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.unbindParameter(i);
            }
            this.parameterSets = 0;
            return;
        }
        this.batchCount = 0;
        this.batch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this instanceof CachePreparedStatement) {
            return this.executePreparedStatementBatch();
        }
        if (this.batchCount == 0) {
            if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
                throw new BatchUpdateException("Statement.addBatch called with a " + this.batchException, "24000", 24000, new int[0]);
            }
            return new int[0];
        }
        Vector<Integer> vector = new Vector<Integer>();
        SQLException sQLException = null;
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            SysList sysList = this.output.setWire(this.batch);
            this.output.wire.writeBatchCount(this.batchCount);
            this.output.send(this.connection.messageCount.getCount());
            try {
                this.input.readHeader(0, 0, 100);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            this.output.setWire(sysList);
            int n = this.batchCount;
            this.batchCount = 0;
            for (int i = 0; i < n; ++i) {
                int n2 = this.input.wire.getInt();
                if (n2 == -3) {
                    if (sQLException != null) {
                        throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.computeUpdateCount(vector));
                    }
                    throw new BatchUpdateException("Not all rows updated", this.computeUpdateCount(vector));
                }
                vector.add(new Integer(n2));
            }
        }
        if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
            throw new BatchUpdateException("Statement.addBatch called with a " + this.batchException, "24000", 24000, this.computeUpdateCount(vector));
        }
        if (sQLException != null) {
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.computeUpdateCount(vector));
        }
        this.batch = null;
        return this.computeUpdateCount(vector);
    }

    ExecParameter getExecParam(int n) throws SQLException {
        ExecParameter execParameter = (ExecParameter)this.execParams.get(n - 1);
        if (execParameter == null) {
            throw new SQLException("Parameter list mismatch");
        }
        return execParameter;
    }

    ExecParameter getExecParamByName(String string) throws SQLException {
        for (int i = 0; i < this.execParams.size(); ++i) {
            ExecParameter execParameter = (ExecParameter)this.execParams.get(i);
            if (!execParameter.name.equals(string)) continue;
            return execParameter;
        }
        return null;
    }

    synchronized int[] executePreparedStatementBatch() throws SQLException {
        int n;
        if (this.parameterSets == 0) {
            return new int[0];
        }
        for (n = 0; n < this.parameters.size(); ++n) {
            if (!this.isOutParameter(n)) continue;
            throw new SQLException("INOUT/OUT parameters not permitted", "S1000");
        }
        try {
            ((CachePreparedStatement)this).executeUpdate();
        }
        catch (SQLException sQLException) {
            int[] nArray = new int[this.parameterSets];
            for (n = 0; n < this.parameterSets; ++n) {
                nArray[n] = -3;
            }
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
        }
        int n2 = this.parameterSets;
        this.parameterSets = 0;
        int[] nArray = new int[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            nArray[n] = this.input.wire.getInt();
            if (nArray[n] == -3) continue;
            ++n3;
        }
        if (n3 < n2) {
            throw new BatchUpdateException("Not all rows updated", nArray);
        }
        this.clearBatch();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void prepareStoredProcedure() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARE_STORED_PROCEDURE);
            this.output.wire.set(this.sqlText);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readHeader(this.serverCursorNumber, 0, 0);
            this.processStoredProcedureMetaData(this.input.wire, false);
            if (this.multipleResultSets) {
                return;
            }
        }
        if (this.statementType == 1) {
            if (this.resultSetType == 1003) {
                this.connection.addCachedPrepare(this, true);
            }
        } else {
            this.connection.addCachedPrepare(this, false);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (!(this.statementType == 12 || this.statementType == 10 || this.statementType == 2 || this.statementType == 7 || this.statementType == 1 && this instanceof CacheCallableStatement)) {
            return false;
        }
        if (n < 1 || n > 3) {
            throw new SQLException("Invalid flag value: " + n, "S1000");
        }
        if (n == 2) {
            throw new SQLException("KEEP_CURRENT_RESULT not supported", "IM001");
        }
        if (this.myResultSet != null) {
            this.myResultSet.close();
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_MORE_RESULTS);
            this.output.wire.set(n);
            this.output.send(this.connection.messageCount.getCount());
            int n2 = this.input.readHeader(this.serverCursorNumber, 0, 100);
            int n3 = this.input.wire.getInt();
            if (n3 >= 0) {
                this.updateCnt = n3;
                this.myResultSet = null;
                return false;
            }
            if (n3 == -1) {
                this.fetchDone = n2 == 100;
                return true;
            }
            if (n3 == -2) {
                this.updateCnt = -1;
                this.genericExecuteCalled = true;
                return false;
            }
            throw new SQLException("Invalid result type value: " + n3, "S1000");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.autoGeneratedKeyColumn == null) {
            this.columns = new Vector();
            this.fetchDone = true;
            return new CacheResultSet(this);
        }
        if (this.statementType != 0) {
            throw new SQLException("Not an INSERT statement", "S1000");
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_AUTO_GENERATED_KEYS);
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readHeader(this.serverCursorNumber, 0, 100) != 100) {
                throw new SQLException("Error retrieving auto-generated keys", "S1000");
            }
            this.fetchDone = true;
        }
        if (this.input.wire.isEnd()) {
            this.columns = new Vector();
            this.fetchDone = true;
            return new CacheResultSet(this);
        }
        this.columns = new Vector(1);
        this.columnInfo(this.input.wire);
        return new CacheResultSet(this);
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.autoGeneratedKeyColumn = n == 1 ? "-1" : null;
        return this.executeUpdate(string);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.autoGeneratedKeyColumn = n == 1 ? "-1" : null;
        return this.execute(string);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        this.autoGeneratedKeyColumn = Integer.toString(nArray[0]);
        return this.executeUpdate(string);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (nArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        this.autoGeneratedKeyColumn = Integer.toString(nArray[0]);
        return this.execute(string);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        this.autoGeneratedKeyColumn = stringArray[0];
        return this.executeUpdate(string);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (stringArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        this.autoGeneratedKeyColumn = stringArray[0];
        return this.execute(string);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    synchronized boolean executeMultipleResultSets(boolean bl) throws SQLException {
        this.fetchDone = false;
        if (bl) {
            this.validateParameters();
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.EXECUTE_MULTIPLE_RESULT_SETS);
            if (this.connection.protocolVersion > 41) {
                if (this.resultSetType == 1004) {
                    this.output.wire.set(1);
                } else {
                    this.output.wire.set(0);
                }
                this.output.wire.set(this.queryTimeout);
            }
            this.writeStoredProcedureParameters();
            this.output.send(this.connection.messageCount.getCount());
            this.handleError100(this.input.readHeader(this.serverCursorNumber, 0, 100));
            this.getOutputParameters();
            int n = this.input.wire.getInt();
            if (n >= 0) {
                this.updateCnt = n;
                return false;
            }
            if (n == -1) {
                return true;
            }
            if (n == -2) {
                this.updateCnt = -1;
                return true;
            }
            throw new SQLException("Invalid result type value: " + n, "S1000");
        }
    }

    boolean containsStreamFields() {
        if (this.columns == null) {
            return false;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            int n = ((Column)this.columns.elementAt((int)i)).type;
            if (n != -1 && n != -4) continue;
            return true;
        }
        return false;
    }

    static boolean compareParInfoString(SysList sysList, SysList sysList2) {
        SysList sysList3 = new SysList(false, sysList);
        SysList sysList4 = new SysList(false, sysList2);
        sysList3.reset();
        sysList4.reset();
        boolean bl = true;
        try {
            int n = sysList3.getInt();
            int n2 = sysList4.getInt();
            if (n != n2) {
                bl = false;
            }
            for (int i = 1; bl && i <= n * 2; i += 2) {
                int n3 = sysList3.getInt();
                int n4 = sysList4.getInt();
                int n5 = sysList3.getInt();
                int n6 = sysList4.getInt();
                if (n3 != n4) {
                    bl = false;
                }
                if (n5 == n6) continue;
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return this;
        }
        throw new SQLException("Receiver not a wrapper");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.poolable = bl;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    public ResultSet executeEventQuery(String string, Object object, String[] stringArray) throws SQLException {
        byte[] byArray = new byte[]{97, 97};
        this.output.wire.writeHeader(this.serverCursorNumber, byArray);
        this.output.wire.set(string);
        this.output.wire.set(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.output.wire.set(stringArray[i]);
        }
        this.output.wire.set((SysList)object);
        this.output.send(0);
        this.input.readHeader(this.serverCursorNumber, 0, 0);
        this.myResultSet = new CacheResultSet(this);
        return this.myResultSet;
    }

    public ResultSet eventMoreData() throws SQLException {
        byte[] byArray = new byte[]{97, 98};
        this.output.wire.writeHeader(this.serverCursorNumber, byArray);
        this.output.send(0);
        this.input.readHeader(this.serverCursorNumber, 0, 0);
        this.myResultSet = new CacheResultSet(this);
        return this.myResultSet;
    }

    static final class Parameter
    extends Descriptor {
        static final int UNKNOWN = 0;
        static final int INPUT = 1;
        static final int INPUT_OUTPUT = 2;
        static final int OUTPUT = 4;
        static final int REPLACED_LITERAL = 5;
        static final int DEFAULT_PARAMETER = 6;
        Vector values;
        int mode;
        boolean bound;
        Vector whatever;

        Parameter() {
            this.mode = 0;
            this.values = new Vector();
            this.whatever = new Vector();
            this.bound = false;
        }

        Parameter(Object object) {
            this.mode = 5;
            this.values = new Vector();
            this.whatever = new Vector();
            this.values.addElement(object);
            this.whatever.addElement(null);
        }

        Parameter(int n) {
            this.mode = 6;
            this.values = new Vector();
            this.whatever = new Vector();
        }

        Parameter(int n, int n2, int n3, int n4, String string, int n5, Object object) {
            this.type = n;
            this.precision = n2;
            this.scale = n3;
            this.nullable = n4;
            this.name = string;
            this.mode = n5;
            if (this.mode == 5) {
                this.values = new Vector();
                this.values.addElement(object);
            }
        }

        void copyCachedInfo(Parameter parameter, boolean bl) {
            this.type = parameter.type;
            this.precision = parameter.precision;
            this.scale = parameter.scale;
            this.nullable = parameter.nullable;
            this.name = parameter.name;
            if (this.mode != 5 && parameter.mode != 5) {
                this.mode = parameter.mode;
            }
            if (!bl) {
                return;
            }
            if (parameter.mode == 5) {
                this.mode = 5;
                this.values = new Vector();
                this.whatever = new Vector();
                this.values.addElement(parameter.values.elementAt(0));
                this.whatever.addElement(null);
            }
        }

        void bind(Object object, Object object2, int n) throws SQLException {
            int n2;
            if (n == 0) {
                this.values.clear();
                this.whatever.clear();
            }
            if (n + 1 < (n2 = this.values.size()) || n2 < n) {
                throw new SQLException("Not all parameters bound for this set", "S1000");
            }
            if (n == n2) {
                this.values.addElement(object);
                this.whatever.addElement(object2);
            } else {
                this.values.setElementAt(object, n2 - 1);
                this.whatever.setElementAt(object2, n2 - 1);
            }
            this.bound = true;
            this.mode = this.mode == 4 || this.mode == 2 ? 2 : 1;
        }
    }

    static final class Column
    extends Descriptor
    implements Cloneable {
        String label;
        String tableName;
        String schema = "";
        String catalog = "";
        boolean isAutoIncrement = false;
        boolean isCaseSensitive = false;
        boolean isCurrency;
        boolean isReadOnly = false;
        boolean isRowId = false;

        Column() {
        }

        protected Object clone() {
            Column column = new Column();
            column.cloneMe(this);
            column.label = this.label;
            column.tableName = this.tableName;
            column.schema = this.schema;
            column.catalog = this.catalog;
            column.isAutoIncrement = this.isAutoIncrement;
            column.isCaseSensitive = this.isCaseSensitive;
            column.isCurrency = this.isCurrency;
            column.isReadOnly = this.isReadOnly;
            column.isRowId = this.isRowId;
            return column;
        }
    }

    static final class StreamWrapper {
        Object data;
        int type;
        int length;

        StreamWrapper(Object object, int n, int n2) {
            this.data = object;
            this.type = n;
            this.length = n2;
        }
    }
}

