/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jdbcutil;

import com.intersys.cache.jdbcutil.GeneralDBAdapter;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class RDBMSAdapter
implements GeneralDBAdapter {
    private static final int DEFAULT_NUMBER_OF_PROFILES = 2;
    public static int NUMBER_OF_PROFILES = -1;
    protected static long mElapsedTime = 0L;
    protected static long[] mElapsedTimeArray;
    protected static int[] mNumCallsArray;
    protected static boolean[] mProfileFlag;
    protected static int mNumCalls;
    protected final Connection mConnection;
    protected Statement mCountCommand;
    private static Map[] messagesSent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDBMSAdapter(Connection connection) throws CacheException {
        this.mConnection = connection;
        Class<RDBMSAdapter> clazz = RDBMSAdapter.class;
        synchronized (RDBMSAdapter.class) {
            if (mProfileFlag == null) {
                int n = RDBMSAdapter.determineNumberOfProfiles();
                mElapsedTimeArray = new long[n];
                mProfileFlag = new boolean[n];
                mNumCallsArray = new int[n];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected static int determineNumberOfProfiles() throws CacheException {
        String string = System.getProperty("com.intersys.profile.segments");
        if (string == null) {
            if (NUMBER_OF_PROFILES < 0) {
                NUMBER_OF_PROFILES = 2;
            }
            return NUMBER_OF_PROFILES;
        }
        try {
            NUMBER_OF_PROFILES = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CacheException("Invalid number of profile segments specified in system properties: " + string);
        }
        return NUMBER_OF_PROFILES;
    }

    public static void setNumberOfProfiles(int n) {
        NUMBER_OF_PROFILES = n;
    }

    public static int getNumberOfProfiles() {
        try {
            RDBMSAdapter.determineNumberOfProfiles();
        }
        catch (CacheException cacheException) {
            return 2;
        }
        return NUMBER_OF_PROFILES;
    }

    private synchronized void initCountStatement() throws CacheServerException {
        if (this.mCountCommand != null) {
            return;
        }
        try {
            this.mCountCommand = this.mConnection.createStatement();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, RDBMSAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
        }
    }

    @Override
    public synchronized int countElements(String string, String string2) throws CacheServerException {
        if (this.mCountCommand == null) {
            this.initCountStatement();
        }
        ResultSet resultSet = null;
        try {
            String string3 = "SELECT COUNT(%ID) FROM " + string + " WHERE " + string2;
            resultSet = this.mCountCommand.executeQuery(string3);
            if (resultSet.next()) {
                int n;
                int n2 = n = resultSet.getInt(1);
                return n2;
            }
            try {
                throw new CacheServerException("Failed to count elements in " + string + " with condition " + string2);
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException, "Failed to count elements in " + string + " with condition " + string2);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    throw new CacheServerException(sQLException, "Error closing result set after counting elements in " + string + " with condition " + string2);
                }
            }
        }
    }

    protected synchronized void execute(CallableStatement callableStatement, String string) throws CacheServerException {
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, RDBMSAdapter.sqlErrorText("Failed to execute " + string, sQLException));
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
    }

    public static CallableStatement prepareCall(Connection connection, String string) throws CacheServerException {
        try {
            return connection.prepareCall(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, RDBMSAdapter.sqlErrorText("Failed to prepare call: " + string, sQLException));
        }
    }

    public static String sqlErrorText(String string, SQLException sQLException) {
        while (true) {
            SQLException sQLException2 = sQLException.getNextException();
            String string2 = string + "\n[Message: <" + sQLException.getMessage() + "> Error code: <" + sQLException.getErrorCode() + "> SQL state: <" + sQLException.getSQLState() + ">]";
            if (sQLException2 == null) {
                return string2;
            }
            string = string2;
            sQLException = sQLException2;
        }
    }

    @Override
    public long getServerTime() {
        return mElapsedTime;
    }

    @Override
    public int getNumberServerCalls() {
        return mNumCalls;
    }

    @Override
    public long getServerTime(int n) {
        return mElapsedTimeArray[n];
    }

    @Override
    public int getNumberServerCalls(int n) {
        return mNumCallsArray[n];
    }

    public static Map getMessagesSent(int n) {
        return messagesSent[n];
    }

    @Override
    public void resetProfile(int n) {
        RDBMSAdapter.mElapsedTimeArray[n] = 0L;
        RDBMSAdapter.mNumCallsArray[n] = 0;
        if (messagesSent != null && messagesSent[n] != null) {
            messagesSent[n].clear();
        }
    }

    @Override
    public void setProfileOn(int n) {
        RDBMSAdapter.mProfileFlag[n] = true;
    }

    @Override
    public void setProfileOff(int n) {
        RDBMSAdapter.mProfileFlag[n] = false;
    }

    @Override
    public void close(boolean bl) throws CacheServerException {
        if (bl) {
            try {
                this.mConnection.close();
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException, "Failed to close prepared JDBC Connection");
            }
        }
    }

    public static ResultSet executeQuery(PreparedStatement preparedStatement) throws SQLException {
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        ResultSet resultSet = preparedStatement.executeQuery();
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
        return resultSet;
    }

    protected static void updateProfiler(long l, long l2, String string) {
        int n;
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        ++mNumCalls;
        mElapsedTime += l2 - l;
        if (messagesSent == null) {
            messagesSent = new Map[n2];
            for (n = 0; n < n2; ++n) {
                RDBMSAdapter.messagesSent[n] = new HashMap();
            }
        }
        for (n = 0; n < n2; ++n) {
            if (!mProfileFlag[n]) continue;
            int n3 = n;
            mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
            int n4 = n;
            mElapsedTimeArray[n4] = mElapsedTimeArray[n4] + (l2 - l);
            Integer n5 = (Integer)messagesSent[n].get(string);
            n5 = n5 == null ? new Integer(1) : new Integer(n5 + 1);
            messagesSent[n].put(string, n5);
        }
    }

    static {
        mNumCalls = 0;
    }
}

