/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.objects.CacheException;
import com.intersys.objects.Oid;
import java.util.Map;

public class ZObjValReader {
    protected static final int MAX_ZOBJVAL_NODE = 6;
    protected Map mValueMap;
    protected Oid mOid;

    public ZObjValReader(Map map, Oid oid) {
        this.mValueMap = map;
        this.mOid = oid;
    }

    public boolean isSwizzled(int n) throws CacheException {
        Dataholder dataholder = (Dataholder)this.mValueMap.get(new Integer(n));
        if (dataholder == null) {
            return false;
        }
        return !ZObjValReader.isObjNull(dataholder);
    }

    public Dataholder getProperty(int n) throws CacheException {
        Dataholder dataholder = (Dataholder)this.mValueMap.get(new Integer(n));
        return dataholder;
    }

    protected void setCachedObject(int n, Dataholder dataholder) {
        if (this.mValueMap == null) {
            return;
        }
        this.mValueMap.put(new Integer(n), dataholder);
    }

    public Oid getOid() {
        return this.mOid;
    }

    protected Map getValueMap() {
        return this.mValueMap;
    }

    private static final boolean isObjNull(Dataholder dataholder) throws CacheException {
        switch (dataholder.getType()) {
            case 2: 
            case 4: 
            case 6: 
            case 15: 
            case 512: 
            case 4096: {
                int n = ZObjValReader.getOrefFromDataholder(dataholder);
                return n == 0;
            }
            case 1026: {
                return false;
            }
        }
        byte[] byArray = dataholder.getBinary();
        return byArray == null || byArray.length == 0;
    }

    private static int getOrefFromDataholder(Dataholder dataholder) throws CacheException {
        String string = null;
        try {
            string = dataholder.getString();
        }
        catch (Exception exception) {
            throw new CacheException(exception, "Invalid oref: " + dataholder.getObject());
        }
        if (string == null) {
            return 0;
        }
        int n = string.indexOf(64);
        if (n >= 0) {
            return Integer.parseInt(string.substring(0, n));
        }
        return Integer.parseInt(string);
    }

    public String toString() {
        String string = this.mOid != null ? this.mOid.toString() + ": " : "";
        return string + this.mValueMap.toString();
    }

    public void assertEquals(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object v = this.mValueMap.get(new Integer(i));
            if (string == null) {
                if (v == null || v.toString().equals("null")) continue;
                throw new IllegalStateException("Assertion Failure: ZobjVal mismatch at node #" + i + ": " + string + "/" + v);
            }
            if (string.equals(v.toString())) continue;
            throw new IllegalStateException("Assertion Failure: ZobjVal mismatch at node #" + i + ": " + string + "/" + v);
        }
    }
}

