/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.SystemError;
import java.sql.SQLException;

class TmpObjPropertyKey
implements Comparable {
    public int oref;
    public String name;

    public TmpObjPropertyKey(int n, String string) {
        this.oref = n;
        this.name = string;
    }

    public int compareTo(Object object) {
        TmpObjPropertyKey tmpObjPropertyKey = (TmpObjPropertyKey)object;
        if (this.oref > tmpObjPropertyKey.oref) {
            return 1;
        }
        if (this.oref < tmpObjPropertyKey.oref) {
            return -1;
        }
        return this.name.compareTo(tmpObjPropertyKey.name);
    }

    public boolean equals(Object object) {
        try {
            return this.compareTo(object) == 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void appendToSysList(Object object) throws CacheException {
        try {
            if (this.oref >= 0) {
                SysListProxy.setInteger(object, this.oref);
            }
            SysListProxy.setString(object, this.name);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to get property from local cache");
        }
    }

    public String toString() {
        return "$zobjproperty(" + this.oref + "," + this.name + ")";
    }

    public String toString(Dataholder dataholder) {
        return "$zobjmethod(" + this.oref + "," + this.name + "Set," + dataholder.toOrefString() + ")";
    }

    public int getObjectReference() {
        return this.oref;
    }
}

