/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.ui;

import com.dbeaver.lm.app.LMAppUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMService;
import org.jkiss.lm.LMStatusDetails;
import org.jkiss.lm.LMUtils;
import org.jkiss.lm.LMValidateException;
import org.jkiss.utils.IOUtils;

public class LicenseImportDialog
extends BaseDialog {
    private static final Log log = Log.getLog(LicenseImportDialog.class);
    private Text licenseText;

    public LicenseImportDialog(Shell parentShell) {
        super(parentShell, "Import License", null);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Label infoLabel = new Label(composite, 0);
        infoLabel.setLayoutData((Object)new GridData(768));
        infoLabel.setText("Copy/paste license text or load it from file");
        Group licenseGroup = UIUtils.createControlGroup((Composite)composite, (String)"License", (int)1, (int)1808, (int)0);
        this.licenseText = new Text((Composite)licenseGroup, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = this.licenseText.getLineHeight() * 6;
        gd.widthHint = this.licenseText.getLineHeight() * 30;
        this.licenseText.setLayoutData((Object)gd);
        Composite buttonsBar = UIUtils.createPlaceholder((Composite)licenseGroup, (int)2, (int)5);
        UIUtils.createPushButton((Composite)buttonsBar, (String)"Paste", (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_PASTE")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseImportDialog.this.copyLicenseFromClipboard();
            }
        });
        UIUtils.createPushButton((Composite)buttonsBar, (String)"Load", (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseImportDialog.this.loadLicenseFromFile();
            }
        });
        return parent;
    }

    private void loadLicenseFromFile() {
        File file = DialogUtils.openFile((Shell)this.getShell(), (String[])new String[]{"*", "*.txt", "*.lic"});
        if (file != null) {
            try {
                String fileContents = IOUtils.toString((File)file, (String)GeneralUtils.UTF8_ENCODING);
                if (fileContents != null) {
                    this.licenseText.setText(fileContents);
                }
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError("Load license", "Error loading license from file", (Throwable)e);
            }
        }
    }

    private void copyLicenseFromClipboard() {
        Object textContents = new Clipboard(Display.getCurrent()).getContents((Transfer)TextTransfer.getInstance());
        if (textContents instanceof String) {
            this.licenseText.setText(textContents.toString());
        }
    }

    private boolean importLicenseFromText() {
        LMLicense license;
        int divPos;
        LMService licenseService = LMAppUtils.getLicenseService();
        String licenseEncoded = this.licenseText.getText().trim();
        if ((licenseEncoded.startsWith("DBeaver") || licenseEncoded.startsWith("License Key")) && (divPos = licenseEncoded.indexOf("--")) != -1) {
            licenseEncoded = licenseEncoded.substring(divPos);
        }
        boolean strangeLicense = false;
        if (!licenseEncoded.contains("\n")) {
            int divPos2 = licenseEncoded.indexOf("//");
            if (divPos2 != -1) {
                licenseEncoded = licenseEncoded.substring(divPos2 + "//".length()).trim();
            } else {
                strangeLicense = true;
            }
        }
        if (licenseEncoded.isEmpty()) {
            DBWorkbench.getPlatformUI().showError("Empty license", "You have to fill (copy) license text");
            return false;
        }
        try {
            LMUtils.readEncryptedString((Reader)new StringReader(licenseEncoded));
        }
        catch (IOException e) {
            if (strangeLicense) {
                DBWorkbench.getPlatformUI().showError("Incorrect license text", "License text is incorrect.\nLicense text usually consists of several lines, it starts with -- characters and ends with ==.\nPlease recheck the license text. You can get correct license text on your profile page on the website.");
            } else {
                DBWorkbench.getPlatformUI().showError("Decode license", "Error decoding license text", (Throwable)e);
            }
            return false;
        }
        try {
            license = licenseService.importProductLicense(licenseEncoded);
        }
        catch (LMException e) {
            log.error((Object)e);
            DBWorkbench.getPlatformUI().showError("Can't load license", "Error importing license text", (Throwable)e);
            return false;
        }
        if (license.isSubscription()) {
            try {
                try {
                    UIUtils.runInProgressDialog(monitor -> {
                        try {
                            monitor.beginTask("Validate subscription", 1);
                            monitor.subTask("Check license '" + license.getLicenseId() + "' status on server");
                            licenseService.validateLicense(license);
                            monitor.done();
                        }
                        catch (LMException e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
                try {
                    licenseService.deleteLicense(license);
                }
                catch (LMException e1) {
                    log.debug((Object)e1);
                }
                if (e instanceof LMValidateException) {
                    String message;
                    String title;
                    LMValidateException validateException = (LMValidateException)e;
                    LMStatusDetails remoteStatus = validateException.getLicense().getRemoteStatus();
                    if (remoteStatus != null) {
                        title = remoteStatus.getMessage();
                        message = remoteStatus.getDetails();
                    } else {
                        title = "Subscription validation error";
                        switch (validateException.getStatus()) {
                            case EXPIRED: {
                                message = "Subscription has been expired";
                                break;
                            }
                            case CANCELED: {
                                message = "Subscription has been canceled";
                                break;
                            }
                            case INVALID: {
                                message = "Invalid subscription";
                                break;
                            }
                            default: {
                                message = "Error validating subscription";
                            }
                        }
                        message = "License '" + license.getLicenseId() + "' validation failed:\n" + message;
                    }
                    DBWorkbench.getPlatformUI().showError(title, message);
                    return false;
                }
                DBWorkbench.getPlatformUI().showError("Error validating license", "Internal error while validating license", e);
            }
        } else {
            LMStatusDetails licenseStatus = license.getLicenseStatus(LMAppUtils.getActiveProduct());
            if (!licenseStatus.isValid()) {
                DBWorkbench.getPlatformUI().showError(licenseStatus.getMessage(), licenseStatus.getDetails());
                try {
                    licenseService.deleteLicense(license);
                }
                catch (LMException e1) {
                    log.debug((Object)e1);
                }
                return false;
            }
        }
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Import", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.importLicenseFromText()) {
            return;
        }
        super.buttonPressed(buttonId);
    }
}

