/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.cli;

import com.dbeaver.application.DBeaverApplicationAdvanced;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;

public class HeadlessTaskExecutor {
    private static final Log log = Log.getLog(HeadlessTaskExecutor.class);
    private static final String TASK_LOG_PREFIX = "[TASK] ";
    private static HeadlessTaskExecutor instance;

    public static synchronized HeadlessTaskExecutor getInstance() {
        if (instance == null) {
            instance = new HeadlessTaskExecutor();
        }
        return instance;
    }

    public void runTask(String taskNameStr, Map<String, String> parameters) throws DBException {
        Job job;
        DBTTask task;
        DBPProject project;
        int divPos;
        String projectName = null;
        String taskName = taskNameStr;
        if (taskNameStr.startsWith("@") && (divPos = taskNameStr.indexOf(58)) != -1) {
            projectName = taskNameStr.substring(1, divPos);
            taskName = taskNameStr.substring(divPos + 1);
        }
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (projectName == null) {
            project = workspace.getActiveProject();
            if (project == null) {
                List allProjects = workspace.getProjects();
                DBPProject dBPProject = project = allProjects.isEmpty() ? null : (DBPProject)allProjects.get(0);
                if (project == null) {
                    throw new DBException("No projects found in workspace " + workspace.getAbsolutePath());
                }
            }
        } else {
            project = workspace.getProject(projectName);
            if (project == null) {
                throw new DBException("Project '" + projectName + "' not found in workspace " + workspace.getAbsolutePath());
            }
        }
        if ((task = project.getTaskManager().getTaskById(taskName)) == null) {
            task = project.getTaskManager().getTaskByName(taskName);
        }
        if (task == null) {
            throw new DBException("Task '" + taskName + "' not found in project '" + project.getName() + "'");
        }
        log.debug((Object)("[TASK] Execute task " + task.getName()));
        LinkedHashMap options = new LinkedHashMap();
        final DBTTask finalTask = task;
        DBTTaskExecutionListener listener = new DBTTaskExecutionListener(){

            public void taskStarted(@Nullable DBTTask task) {
            }

            public void taskFinished(@Nullable DBTTask t, @Nullable Object result, @Nullable Throwable error, @Nullable Object settings) {
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put("project", finalTask.getProject().getName());
                params.put("taskId", finalTask.getId());
                DBeaverApplicationAdvanced app = (DBeaverApplicationAdvanced)DBWorkbench.getPlatform().getApplication();
                try {
                    IInstanceController instanceClient = app.createInstanceClient();
                    if (instanceClient != null) {
                        instanceClient.fireGlobalEvent("taskExecuted", params);
                    }
                }
                catch (RemoteException remoteException) {
                    log.error((Object)"Error notifying remote instance");
                }
            }

            public void subTaskFinished(@Nullable DBTTask task, @Nullable Throwable error, @Nullable Object settings) {
            }
        };
        Object propValue = task.getProperties().get("taskVariables");
        if (propValue instanceof Map) {
            ((Map)propValue).putAll(parameters);
        }
        if ((job = task.getProject().getTaskManager().runTask(task, listener, options)) != null) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
        log.debug((Object)("[TASK] Task finished " + task.getName()));
    }
}

