/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.spanner.model;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.spanner.model.SpannerMetaModel;
import org.jkiss.dbeaver.ext.spanner.model.SpannerSQLDialect;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class SpannerDataSource
extends GenericDataSource {
    public SpannerDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, SpannerMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new SpannerSQLDialect());
    }

    protected String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        String url = super.getConnectionURL(connectionInfo);
        if (url != null && url.startsWith("jdbc:cloudspanner:/projects/%s/instances/%s/databases/%s")) {
            return String.format(url, connectionInfo.getServerName(), connectionInfo.getHostName(), connectionInfo.getDatabaseName());
        }
        return url;
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (driver.getId().equals("spanner_jdbc")) {
            props.put("Project", connectionInfo.getServerName());
            props.put("Instance", connectionInfo.getHostName());
            props.put("Database", connectionInfo.getDatabaseName());
            props.put("PvtKeyPath", connectionInfo.getProviderProperty("PvtKeyPath"));
        } else if (connectionInfo.getProviderProperty("PvtKeyPath") != null) {
            props.put("credentials", connectionInfo.getProviderProperty("PvtKeyPath"));
        }
        return props;
    }
}

