/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs.util;

import com.google.common.collect.Sets;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.carlspring.cloud.storage.s3fs.attribute.S3BasicFileAttributes;
import org.carlspring.cloud.storage.s3fs.attribute.S3PosixFileAttributes;
import org.carlspring.cloud.storage.s3fs.attribute.S3UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.Permission;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Utils.class);

    public static List<S3Object> listS3Objects(S3Path s3Path) {
        String key = s3Path.getKey();
        String bucketName = s3Path.getFileStore().name();
        S3Client client = s3Path.getFileSystem().getClient();
        String keyFolder = key;
        if (!keyFolder.endsWith("/")) {
            keyFolder = String.valueOf(keyFolder) + "/";
        }
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).prefix(keyFolder).maxKeys(Integer.valueOf(1)).build();
        return client.listObjectsV2(request).contents();
    }

    public static S3Object getS3Object(S3Path s3Path) throws NoSuchFileException {
        S3Object s3Object = s3Path.getS3Object();
        if (s3Object != null) {
            return s3Object;
        }
        String bucketName = s3Path.getFileStore().name();
        String key = s3Path.getKey();
        if (key == null || key.isEmpty()) {
            Bucket bucket = s3Path.getFileStore().getBucket();
            return (S3Object)S3Object.builder().key(bucket.name()).lastModified(bucket.creationDate()).size(Long.valueOf(0L)).build();
        }
        S3Client client = s3Path.getFileSystem().getClient();
        try {
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key(key).build();
            HeadObjectResponse metadata = client.headObject(headObjectRequest);
            GetObjectAclRequest getObjectAclRequest = (GetObjectAclRequest)GetObjectAclRequest.builder().bucket(bucketName).key(key).build();
            GetObjectAclResponse acl = client.getObjectAcl(getObjectAclRequest);
            S3Object.Builder builder = S3Object.builder();
            builder.key(key).lastModified(metadata.lastModified()).eTag(metadata.eTag()).owner(acl.owner()).size(metadata.contentLength()).storageClass(metadata.storageClassAsString());
            return (S3Object)builder.build();
        }
        catch (S3Exception e) {
            if (e.statusCode() != 404) {
                throw e;
            }
        }
        catch (SdkClientException sdkClientException) {
            LOGGER.warn("Object could not be retrieved as a file with the given key");
        }
        try {
            List<S3Object> s3Objects = S3Utils.listS3Objects(s3Path);
            if (!s3Objects.isEmpty()) {
                return s3Objects.get(0);
            }
        }
        catch (Exception exception) {}
        throw new NoSuchFileException(String.valueOf(bucketName) + "/" + key);
    }

    public S3BasicFileAttributes getS3FileAttributes(S3Path s3Path) throws NoSuchFileException {
        S3Object object = S3Utils.getS3Object(s3Path);
        return this.toS3FileAttributes(object, s3Path.getKey());
    }

    public S3PosixFileAttributes getS3PosixFileAttributes(S3Path s3Path) throws NoSuchFileException {
        Set<PosixFilePermission> permissions;
        Owner owner;
        GetBucketAclRequest request;
        S3Object object = S3Utils.getS3Object(s3Path);
        String key = s3Path.getKey();
        String bucketName = s3Path.getFileStore().name();
        S3BasicFileAttributes attrs = this.toS3FileAttributes(object, key);
        S3Client client = s3Path.getFileSystem().getClient();
        if (!attrs.isDirectory()) {
            request = (GetObjectAclRequest)GetObjectAclRequest.builder().bucket(bucketName).key(key).build();
            GetObjectAclResponse acl = client.getObjectAcl((GetObjectAclRequest)request);
            owner = acl.owner();
            permissions = this.toPosixFilePermissions(acl.grants());
        } else {
            request = (GetBucketAclRequest)GetBucketAclRequest.builder().bucket(bucketName).build();
            GetBucketAclResponse acl = client.getBucketAcl(request);
            owner = acl.owner();
            permissions = this.toPosixFilePermissions(acl.grants());
        }
        S3UserPrincipal userPrincipal = new S3UserPrincipal(String.valueOf(owner.id()) + ":" + owner.displayName());
        return new S3PosixFileAttributes((String)attrs.fileKey(), attrs.lastModifiedTime(), attrs.size(), attrs.isDirectory(), attrs.isRegularFile(), userPrincipal, null, permissions);
    }

    public Set<PosixFilePermission> toPosixFilePermissions(List<Grant> grants) {
        HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
        for (Grant grant : grants) {
            filePermissions.addAll(this.toPosixFilePermission(grant.permission()));
        }
        return filePermissions;
    }

    public Set<PosixFilePermission> toPosixFilePermission(Permission permission) {
        switch (permission) {
            case FULL_CONTROL: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE});
            }
            case WRITE: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE});
            }
            case READ: 
            case READ_ACP: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ});
            }
            case WRITE_ACP: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE});
            }
        }
        throw new IllegalStateException("Unknown Permission: " + permission);
    }

    public S3BasicFileAttributes toS3FileAttributes(S3Object object, String key) {
        FileTime lastModifiedTime = null;
        lastModifiedTime = object.lastModified() != null ? FileTime.from(object.lastModified()) : FileTime.fromMillis(-1L);
        long size = object.size() != null ? object.size() : 0L;
        boolean directory = false;
        boolean regularFile = false;
        String resolvedKey = object.key();
        if (key.endsWith("/") && resolvedKey.equals(key) || resolvedKey.equals(String.valueOf(key) + "/")) {
            directory = true;
        } else if (key.isEmpty()) {
            directory = true;
            resolvedKey = "/";
        } else if (!resolvedKey.equals(key) && resolvedKey.startsWith(key)) {
            directory = true;
            size = 0L;
            resolvedKey = String.valueOf(key) + "/";
        } else {
            regularFile = true;
        }
        return new S3BasicFileAttributes(resolvedKey, lastModifiedTime, size, directory, regularFile);
    }
}

