/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs.util;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.HashMap;
import java.util.Map;

public abstract class AttributesUtils {
    public static Map<String, Object> fileAttributeToMap(BasicFileAttributes attr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("creationTime", attr.creationTime());
        result.put("fileKey", attr.fileKey());
        result.put("isDirectory", attr.isDirectory());
        result.put("isOther", attr.isOther());
        result.put("isRegularFile", attr.isRegularFile());
        result.put("isSymbolicLink", attr.isSymbolicLink());
        result.put("lastAccessTime", attr.lastAccessTime());
        result.put("lastModifiedTime", attr.lastModifiedTime());
        result.put("size", attr.size());
        if (attr instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttr = (PosixFileAttributes)attr;
            result.put("permissions", posixAttr.permissions());
            result.put("owner", posixAttr.owner());
            result.put("group", posixAttr.group());
        }
        return result;
    }

    public static Map<String, Object> fileAttributeToMap(BasicFileAttributes attr, String[] filters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            filter = filter.replace("basic:", "");
            switch (filter = filter.replace("posix:", "")) {
                case "creationTime": {
                    result.put("creationTime", attr.creationTime());
                    break;
                }
                case "fileKey": {
                    result.put("fileKey", attr.fileKey());
                    break;
                }
                case "isDirectory": {
                    result.put("isDirectory", attr.isDirectory());
                    break;
                }
                case "isOther": {
                    result.put("isOther", attr.isOther());
                    break;
                }
                case "isRegularFile": {
                    result.put("isRegularFile", attr.isRegularFile());
                    break;
                }
                case "isSymbolicLink": {
                    result.put("isSymbolicLink", attr.isSymbolicLink());
                    break;
                }
                case "lastAccessTime": {
                    result.put("lastAccessTime", attr.lastAccessTime());
                    break;
                }
                case "lastModifiedTime": {
                    result.put("lastModifiedTime", attr.lastModifiedTime());
                    break;
                }
                case "size": {
                    result.put("size", attr.size());
                    break;
                }
                case "permissions": {
                    result.put("permissions", ((PosixFileAttributes)attr).permissions());
                    break;
                }
                case "group": {
                    result.put("group", ((PosixFileAttributes)attr).group());
                    break;
                }
                case "owner": {
                    result.put("owner", ((PosixFileAttributes)attr).owner());
                }
            }
            ++n2;
        }
        return result;
    }
}

