/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.Set;
import org.carlspring.cloud.storage.s3fs.S3ClientGetter;
import org.carlspring.cloud.storage.s3fs.S3FileStore;
import org.carlspring.cloud.storage.s3fs.S3FileSystemProvider;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;

public class S3FileSystem
extends FileSystem
implements Comparable<S3FileSystem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3FileSystem.class);
    private final S3FileSystemProvider provider;
    private final S3ClientGetter clientGetter;
    private S3Client client;
    private final String endpoint;
    private final int cache;
    private Bucket bucket;

    public S3FileSystem(S3FileSystemProvider provider, Bucket bucket, S3ClientGetter clientGetter, String endpoint) {
        this.provider = provider;
        this.bucket = bucket;
        this.clientGetter = clientGetter;
        this.endpoint = endpoint;
        this.cache = 60000;
    }

    @Override
    public S3FileSystemProvider provider() {
        return this.provider;
    }

    public String getKey() {
        return "";
    }

    @Override
    public void close() throws IOException {
        this.provider.close(this);
    }

    @Override
    public boolean isOpen() {
        return this.provider.isOpen(this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FileStore fileStore : this.getFileStores()) {
            try {
                Files.list(((S3FileStore)fileStore).getRootDirectory()).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
            catch (IOException e) {
                LOGGER.error("Error reading bucket contents", (Throwable)e);
            }
        }
        return builder.build();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.singletonList(new S3FileStore(this, this.bucket.name()));
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return ImmutableSet.of((Object)"basic", (Object)"posix");
    }

    @Override
    public S3Path getPath(String first, String ... more) {
        if (more.length == 0) {
            return new S3Path(this, first, new String[0]);
        }
        return new S3Path(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public S3Client getClient() {
        if (this.client == null) {
            this.client = this.clientGetter.obtainClient();
        }
        return this.client;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String[] key2Parts(String keyParts) {
        String[] parts = keyParts.split("/");
        String[] split = new String[parts.length];
        int i = 0;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            split[i++] = part;
            ++n2;
        }
        return split;
    }

    public int hashCode() {
        String key = this.bucket.name();
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (key == null ? 0 : key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileSystem)) {
            return false;
        }
        S3FileSystem other = (S3FileSystem)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.bucket == null) {
            return other.bucket == null;
        }
        return this.bucket.equals((Object)other.bucket);
    }

    @Override
    public int compareTo(S3FileSystem o) {
        return this.bucket.name().compareTo(o.bucket.name());
    }

    public int getCache() {
        return this.cache;
    }

    public Bucket getBucket() {
        return this.bucket;
    }
}

