/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3;

import com.dbeaver.cloud.aws.s3.AWSFileSystemS3;
import com.dbeaver.cloud.model.navigator.CPCloudRegionProvider;
import java.nio.file.Path;
import org.carlspring.cloud.storage.s3fs.S3FileStore;
import org.carlspring.cloud.storage.s3fs.S3FileSystem;
import org.carlspring.cloud.storage.s3fs.S3FileSystemProvider;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;

public class AWSFileSystemS3Bucket
implements DBFVirtualFileSystemRoot,
CPCloudRegionProvider {
    private static final Log log = Log.getLog(AWSFileSystemS3Bucket.class);
    private static S3FileSystemProvider provider = new S3FileSystemProvider();
    private final AWSFileSystemS3 fs;
    private Bucket bucket;
    private S3FileSystem s3FileSystem;
    private S3FileStore fileStore;
    private String regionName;

    public AWSFileSystemS3Bucket(AWSFileSystemS3 fs, Bucket bucket) {
        this.fs = fs;
        this.bucket = bucket;
    }

    @NotNull
    public String getName() {
        return this.bucket.name();
    }

    @NotNull
    public DBFVirtualFileSystem getFileSystem() {
        return this.fs;
    }

    @NotNull
    public String getRootId() {
        return this.bucket.name();
    }

    public DBPImage getRootIcon() {
        return null;
    }

    @NotNull
    public Path getRootPath(DBRProgressMonitor monitor) throws DBException {
        if (this.fileStore == null) {
            this.s3FileSystem = new S3FileSystem(provider, this.bucket, () -> {
                try {
                    if (CommonUtils.isEmpty((String)this.regionName)) {
                        GetBucketLocationResponse bucketLocation = this.fs.getGlobalS3Client(monitor).getBucketLocation((GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(this.bucket.name()).build());
                        this.regionName = bucketLocation.locationConstraintAsString();
                    }
                    Region region = CommonUtils.isEmpty((String)this.regionName) ? Region.US_EAST_1 : Region.of((String)this.regionName);
                    return region == null ? this.fs.getGlobalS3Client(monitor) : this.fs.getS3Client(monitor, region);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't obtain S3 client", e);
                }
            }, "s3.amazonaws.com");
            this.fileStore = new S3FileStore(this.s3FileSystem, this.bucket.name());
        }
        return this.fileStore.getRootDirectory();
    }

    @Nullable
    public String getCloudRegion(@Nullable DBRProgressMonitor monitor) throws DBException {
        if (this.regionName == null && monitor != null && this.fs.getCloud().getCloudConfiguration().isReadAllRegions()) {
            this.regionName = this.fs.getGlobalS3Client(monitor).getBucketLocation((GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(this.bucket.name()).build()).locationConstraintAsString();
        }
        return this.regionName;
    }
}

