/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EncryptedOutputStream;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.StreamEncoder;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.exaTimestamp;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;

class EXAOutputStream
extends OutputStream {
    final EXAConnection connection;
    protected OutputStream father;
    private byte[] buffer;
    private Calendar defCal;
    private final char[] hexArray = "0123456789ABCDEF".toCharArray();

    EXAOutputStream(OutputStream outputStream, EXAConnection eXAConnection) {
        this.father = outputStream;
        this.buffer = new byte[8];
        this.defCal = Calendar.getInstance();
        this.connection = eXAConnection;
    }

    public void SetEncryptor(StreamEncoder streamEncoder) throws IOException {
        if (!(this.father instanceof EncryptedOutputStream)) {
            throw new IOException("Try to activate encryption on an OutputStream that is not an instance of EncryptedOutputStream");
        }
        ((EncryptedOutputStream)this.father).SetEncryptor(streamEncoder);
    }

    @Override
    public void close() throws IOException {
        this.father.close();
    }

    @Override
    public void flush() throws IOException {
        this.father.flush();
    }

    public void setHeader() throws IOException {
        if (this.father instanceof EncryptedOutputStream) {
            ((EncryptedOutputStream)this.father).setHeader();
        } else if (this.father instanceof EXAOutputStream) {
            ((EXAOutputStream)this.father).setHeader();
        } else {
            this.father.flush();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.father.write(byArray);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray != null) {
            this.father.write(byArray, n, n2);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.father.write(n);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.father.write(bl ? 1 : 0);
    }

    public void writeByte(byte by) throws IOException {
        this.father.write(by & 0xFF);
    }

    public void writeShort(short s) throws IOException {
        this.buffer[1] = (byte)(s >> 8);
        this.buffer[0] = (byte)s;
        this.father.write(this.buffer, 0, 2);
    }

    public void writeInt(int n) throws IOException {
        this.buffer[3] = (byte)(n >> 24);
        this.buffer[2] = (byte)(n >> 16);
        this.buffer[1] = (byte)(n >> 8);
        this.buffer[0] = (byte)n;
        this.father.write(this.buffer, 0, 4);
    }

    public void writeLong(long l) throws IOException {
        this.buffer[7] = (byte)(l >> 56);
        this.buffer[6] = (byte)(l >> 48);
        this.buffer[5] = (byte)(l >> 40);
        this.buffer[4] = (byte)(l >> 32);
        this.buffer[3] = (byte)(l >> 24);
        this.buffer[2] = (byte)(l >> 16);
        this.buffer[1] = (byte)(l >> 8);
        this.buffer[0] = (byte)l;
        this.father.write(this.buffer, 0, 8);
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        this.buffer[3] = (byte)(n >> 24);
        this.buffer[2] = (byte)(n >> 16);
        this.buffer[1] = (byte)(n >> 8);
        this.buffer[0] = (byte)n;
        this.father.write(this.buffer, 0, 4);
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        this.buffer[7] = (byte)(l >> 56);
        this.buffer[6] = (byte)(l >> 48);
        this.buffer[5] = (byte)(l >> 40);
        this.buffer[4] = (byte)(l >> 32);
        this.buffer[3] = (byte)(l >> 24);
        this.buffer[2] = (byte)(l >> 16);
        this.buffer[1] = (byte)(l >> 8);
        this.buffer[0] = (byte)l;
        this.father.write(this.buffer, 0, 8);
    }

    private String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 3];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 3] = this.hexArray[n >>> 4];
            cArray[i * 3 + 1] = this.hexArray[n & 0xF];
            cArray[i * 3 + 2] = 32;
        }
        return new String(cArray);
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            this.writeInt(0);
        } else {
            byte[] byArray = string.getBytes(this.connection.getEncoding());
            this.writeInt(byArray.length);
            this.write(byArray);
        }
    }

    public void writeBinary(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeInt(0);
        } else {
            this.writeInt(byArray.length);
            this.write(byArray);
        }
    }

    public void writeNulls(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.buffer[0] = 0;
        this.buffer[1] = 0;
        this.buffer[2] = 0;
        this.buffer[3] = 0;
        this.buffer[4] = 0;
        this.buffer[5] = 0;
        this.buffer[6] = 0;
        this.buffer[7] = 0;
        while (n > 8) {
            this.father.write(this.buffer);
            n -= 8;
        }
        this.father.write(this.buffer, 0, n);
    }

    public void writeTimestamp(exaTimestamp exaTimestamp2) throws IOException {
        int n = exaTimestamp2.getYear();
        this.buffer[0] = (byte)n;
        this.buffer[1] = (byte)(n >> 8);
        n = exaTimestamp2.getMonth() + 1;
        this.buffer[2] = (byte)n;
        n = exaTimestamp2.getDay();
        this.buffer[3] = (byte)n;
        n = exaTimestamp2.getHour();
        this.buffer[4] = (byte)n;
        n = exaTimestamp2.getMinute();
        this.buffer[5] = (byte)n;
        n = exaTimestamp2.getSecond();
        this.buffer[6] = (byte)n;
        this.father.write(this.buffer, 0, 7);
        this.writeInt(exaTimestamp2.getNanos());
    }

    public void writeTimestamp(Timestamp timestamp) throws IOException {
        this.defCal.setTimeInMillis(timestamp.getTime());
        int n = this.defCal.get(1);
        this.buffer[0] = (byte)n;
        this.buffer[1] = (byte)(n >> 8);
        n = this.defCal.get(2) + 1;
        this.buffer[2] = (byte)n;
        n = this.defCal.get(5);
        this.buffer[3] = (byte)n;
        n = this.defCal.get(11);
        this.buffer[4] = (byte)n;
        n = this.defCal.get(12);
        this.buffer[5] = (byte)n;
        n = this.defCal.get(13);
        this.buffer[6] = (byte)n;
        this.father.write(this.buffer, 0, 7);
        this.writeInt(timestamp.getNanos());
    }

    public void writeDate(SimpleDate simpleDate) throws IOException {
        this.writeInt(simpleDate.toInt());
        System.out.println(simpleDate.toString());
    }

    public void writeAttribute(ProtocolAttribute protocolAttribute, String string) throws IOException {
        if (protocolAttribute.type != 10) {
            throw new IOException(Translator.Attribute_type_mismatch() + protocolAttribute.id);
        }
        this.writeShort(protocolAttribute.id);
        this.writeString(string);
    }

    public void writeAttribute(ProtocolAttribute protocolAttribute, int n) throws IOException {
        if (protocolAttribute.type != 4) {
            throw new IOException(Translator.Attribute_type_mismatch() + protocolAttribute.id);
        }
        this.writeShort(protocolAttribute.id);
        this.writeInt(n);
    }

    public void writeAttribute(ProtocolAttribute protocolAttribute, long l) throws IOException {
        if (protocolAttribute.type != 5) {
            throw new IOException(Translator.Attribute_type_mismatch() + protocolAttribute.id);
        }
        this.writeShort(protocolAttribute.id);
        this.writeLong(l);
    }

    public void writeAttribute(ProtocolAttribute protocolAttribute) throws IOException {
        this.writeShort(protocolAttribute.id);
        switch (protocolAttribute.type) {
            case 0: {
                throw new IOException(Translator.Unsupported_attribute() + protocolAttribute.id);
            }
            case 10: {
                this.writeString((String)protocolAttribute.value);
                break;
            }
            case 15: {
                this.writeBinary((byte[])protocolAttribute.value);
                break;
            }
            case 4: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeInt((Integer)protocolAttribute.value);
                break;
            }
            case 1: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeByte((Byte)protocolAttribute.value);
                break;
            }
            case 9: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeBoolean((Boolean)protocolAttribute.value);
                break;
            }
            case 14: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeDate((SimpleDate)protocolAttribute.value);
                break;
            }
            case 8: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeDouble((Double)protocolAttribute.value);
                break;
            }
            case 5: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeLong((Long)protocolAttribute.value);
                break;
            }
            case 7: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeFloat(((Float)protocolAttribute.value).floatValue());
                break;
            }
            case 2: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeShort((Short)protocolAttribute.value);
                break;
            }
            case 21: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeTimestamp((Timestamp)protocolAttribute.value);
                break;
            }
            case 64: {
                if (protocolAttribute.value == null) {
                    throw new IOException(Translator.Null_valued_attribute() + protocolAttribute.id);
                }
                this.writeBigInteger(((BigDecimal)protocolAttribute.value).unscaledValue());
                break;
            }
            default: {
                throw new IOException(Translator.Unsupported_type_of_attribute_value_for_attribute() + protocolAttribute.id);
            }
        }
    }

    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        int n;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 16) {
            throw new IOException(Translator.Numeric_value_too_big_for_bigdecimal());
        }
        for (n = byArray.length - 1; n >= 0; --n) {
            this.write(byArray[n]);
        }
        if (bigInteger.signum() >= 0) {
            for (n = byArray.length; n < 16; ++n) {
                this.write(0);
            }
        } else {
            for (n = byArray.length; n < 16; ++n) {
                this.write(-1);
            }
        }
    }

    public String getEncoding() {
        return this.connection.getEncoding();
    }
}

