/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.BigDecimalColumn;
import com.exasol.jdbc.BoolColumn;
import com.exasol.jdbc.CharColumn;
import com.exasol.jdbc.Column;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DateColumn;
import com.exasol.jdbc.DecimalColumn;
import com.exasol.jdbc.DoubleColumn;
import com.exasol.jdbc.DummyColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAParameterMetaData;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExceptionFactory;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NoResultException;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.SmallDecimalColumn;
import com.exasol.jdbc.TimestampColumn;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.VarCharColumn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public abstract class AbstractEXAPreparedStatement
extends EXAStatement
implements PreparedStatement {
    protected Vector columns;
    protected ExecutionStatus execStatus = null;
    protected int batch_pos;
    private int handle = -1;
    protected static int capacityDefault = 32;
    protected int capacity = capacityDefault;
    private EXAResultSet statementMetadata = null;
    protected EXAResultSet parameterMetadata = null;
    protected final int bytePrecision = 3;
    protected final int smallintPrecision = 10;
    protected final int intPrecision = 19;
    protected final int bigintPrecision = 36;
    private long maxMessageSize = 0x2000000L;

    public long SetMaxPreparedParamBlockSize(long l) {
        if (l < 0L) {
            return this.maxMessageSize;
        }
        if (l < 1024L) {
            this.maxMessageSize = 1024L;
            return 1024L;
        }
        if (l > 0x4000000L) {
            this.maxMessageSize = 0x4000000L;
            return 0x4000000L;
        }
        this.maxMessageSize = l;
        return this.maxMessageSize;
    }

    AbstractEXAPreparedStatement(String string, EXAConnection eXAConnection) throws SQLException {
        super(eXAConnection);
        this.log("EXAPreparedStatement(" + string + ")");
        this.execStatus = new ExecutionStatus();
        this.batch_pos = 0;
        try {
            this.results = this.connection.communication_resultset(string.getBytes(eXAConnection.getEncoding()), (byte)10, this.execStatus, null);
            if (this.results != null && this.results.length > 0) {
                if (this.results[0] instanceof EXASQLException) {
                    throw ExceptionFactory.createSQLException((EXASQLException)this.results[0], this.connection);
                }
                if (this.results.length != 2 && this.results.length != 3) {
                    throw new SQLException("Unknown protocol change in CMD_CREATE_PREPARED, results.length=" + this.results.length + ", SessionID: " + this.connection.getSessionID());
                }
                if (this.results[0] instanceof EXAHandle) {
                    this.handle = ((EXAHandle)this.results[0]).GetHandle();
                }
                if (this.results.length == 2 && this.results[1] instanceof EXAResultSet) {
                    this.statementMetadata = (EXAResultSet)this.results[1];
                    this.current_result = 1;
                }
                if (this.results.length == 3) {
                    if (this.results[1] instanceof EXAResultSet && ((EXAResultSet)this.results[1]).GetHandle() == -5) {
                        this.parameterMetadata = (EXAResultSet)this.results[1];
                    }
                    if (this.results[2] instanceof EXAResultSet) {
                        this.statementMetadata = (EXAResultSet)this.results[2];
                    }
                    this.current_result = 2;
                }
            }
            this.columns = new Vector();
            this.log("EXAPreparedStatement() prepared statement created - handle: " + this.handle);
        }
        catch (IOException iOException) {
            throw new ConnectionLost(iOException.toString(), this.connection.getSessionID());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.log("getParameterMetaData()");
        if (this.results == null || this.results.length < 1) {
            throw new NoResultException();
        }
        if (this.results[1] instanceof EXASQLException) {
            throw ((EXASQLException)this.results[1]).getSQLExceptionIntern(this.connection);
        }
        if (this.results.length == 1) {
            throw new NoResultException();
        }
        if (this.results.length == 2) {
            EXAResultSet eXAResultSet = new EXAResultSet(this.debug);
            eXAResultSet.setMaxRows(this.maxRows);
            EXAParameterMetaData eXAParameterMetaData = new EXAParameterMetaData(eXAResultSet, this.debug);
            eXAParameterMetaData.setStatement(this);
            return eXAParameterMetaData;
        }
        if (this.results[2] instanceof EXASQLException) {
            throw ((EXASQLException)this.results[2]).getSQLExceptionIntern(this.connection);
        }
        if (this.results[1] instanceof EXAResultSet && this.results[2] instanceof EXAResultSet || this.results[1] instanceof EXAResultSet && this.results[2] instanceof EXARowCount) {
            EXAParameterMetaData eXAParameterMetaData = new EXAParameterMetaData((EXAResultSet)this.results[1], this.debug);
            eXAParameterMetaData.setStatement(this);
            return eXAParameterMetaData;
        }
        return null;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        if (this.capacity <= this.batch_pos + 1) {
            this.capacity *= 2;
            for (int i = 0; i < this.columns.size(); ++i) {
                Column column = (Column)this.columns.get(i);
                column.resize(this.capacity);
            }
        }
        ++this.batch_pos;
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.log("clearParameters()");
        this.columns.clear();
        this.batch_pos = 0;
        this.capacity = capacityDefault;
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.log("clearBatch()");
        try {
            this.clearParameters();
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException(sQLException.toString());
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.log("executeBatch()");
        int n = this.executeUpdate();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -2;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean execute() throws SQLException {
        this.log("execute() - handle: " + this.handle);
        try {
            this.connection.setSchemaMayHaveChanged();
            try {
                this._execute(0, 0);
            }
            catch (IOException iOException) {
                throw new ConnectionLost(iOException.getMessage(), this.connection.getSessionID());
            }
            this.current_result = 0;
            if (this.results != null && this.results.length > 0) {
                if (this.results[0] instanceof EXASQLException) {
                    SQLException sQLException;
                    if (((EXASQLException)this.results[0]).getSQLCode().equals("00000") && this.connection.isWorkerConnection()) {
                        this.connection.closeSocket();
                    }
                    if ((sQLException = ((EXASQLException)this.results[0]).getSQLExceptionIntern(this.connection)) instanceof SQLDataException) {
                        int[] nArray = new int[this.batch_pos];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = -3;
                        }
                        throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray, (Throwable)sQLException);
                    }
                    throw sQLException;
                }
                boolean bl = this.results[0] instanceof EXAResultSet;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.clearParameters();
        }
    }

    private synchronized void _execute(int n, int n2) throws IOException, SQLException {
        Object object;
        Object object2;
        int n3 = n;
        this.execStatus = new ExecutionStatus();
        this.log(" _execute(" + n + ", " + n2 + ") - SessionID: " + this.connection.getSessionID());
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        int n4 = this.columns.size();
        if (n4 > 0 && this.batch_pos == 0) {
            this.batch_pos = 1;
        }
        while (n3 < this.batch_pos) {
            for (int i = 0; i < this.columns.size(); ++i) {
                object2 = (Column)this.columns.get(i);
                l += ((Column)object2).value_to_jdbc(eXAOutputStream, n3);
            }
            if (l > this.maxMessageSize) {
                ++n3;
                break;
            }
            ++n3;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        object2 = new EXAOutputStream(byteArrayOutputStream2, this.connection);
        ((EXAOutputStream)object2).writeInt(this.handle);
        ((EXAOutputStream)object2).writeInt(1);
        ((EXAOutputStream)object2).writeByte((byte)1);
        ((EXAOutputStream)object2).writeInt(n4);
        if (n4 > 0) {
            ((EXAOutputStream)object2).writeLong(this.batch_pos);
            ((EXAOutputStream)object2).writeLong(n3 - n);
        } else {
            ((EXAOutputStream)object2).writeLong(0L);
            ((EXAOutputStream)object2).writeLong(0L);
        }
        block12: for (int i = 0; i < n4; ++i) {
            object = (Column)this.columns.get(i);
            ((EXAOutputStream)object2).writeString("param" + i + ": " + ((Column)object).getTypeName());
            int n5 = ((Column)object).getType();
            try {
                ((EXAOutputStream)object2).writeInt(((Column)object).getEXAType());
            }
            catch (Exception exception) {
                System.err.println("EXAPreparedStatement.executeUpdate(): Tried to send unknown type code!");
            }
            switch (n5) {
                case 1: 
                case 12: {
                    if (this.parameterMetadata != null && this.parameterMetadata.getColumnCount() >= i + 1 && (this.parameterMetadata.getColumnType(i + 1) == 12 || this.parameterMetadata.getColumnType(i + 1) == 1) && this.parameterMetadata.getPrecision(i + 1) > ((Column)object).getDisplaySize(this.connection) && ((CharColumn)object).getMaxColumnSize() == 0) {
                        ((Column)object).setPrecision(this.parameterMetadata.getPrecision(i + 1));
                    } else if (((CharColumn)object).getMaxColumnSize() != 0) {
                        ((Column)object).setPrecision(((CharColumn)object).getMaxColumnSize());
                    }
                    switch (n5) {
                        case 12: {
                            ((EXAOutputStream)object2).writeByte((byte)1);
                            if (((Column)object).getDisplaySize(this.connection) >= 40 || ((VarCharColumn)object).getMaxColumnSize() != 0) break;
                            ((Column)object).setPrecision(40);
                            break;
                        }
                        case 1: {
                            if (this.parameterMetadata.getColumnType(i + 1) == 12) {
                                ((EXAOutputStream)object2).writeByte((byte)1);
                                break;
                            }
                            ((EXAOutputStream)object2).writeByte((byte)0);
                        }
                    }
                    ((EXAOutputStream)object2).writeInt(((Column)object).getDisplaySize(this.connection));
                    ((EXAOutputStream)object2).writeInt(((Column)object).getDisplaySize(this.connection) * 4);
                    continue block12;
                }
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (object instanceof BigDecimalColumn) {
                        ((EXAOutputStream)object2).writeInt(((Column)object).getPrecision());
                        ((EXAOutputStream)object2).writeInt(((Column)object).getScale());
                        continue block12;
                    }
                    ((EXAOutputStream)object2).writeInt(((DecimalColumn)object).precision);
                    ((EXAOutputStream)object2).writeInt(((DecimalColumn)object).scale);
                    continue block12;
                }
            }
        }
        byteArrayOutputStream.writeTo(byteArrayOutputStream2);
        ProtocolAttribute[] protocolAttributeArray = null;
        if (n3 < this.batch_pos || n3 == this.batch_pos && n2 > 0) {
            object = new ProtocolAttribute(ProtocolAttribute.ATTR_PACKET_PART_NUMBER.id);
            ((ProtocolAttribute)object).value = n3 < this.batch_pos ? new Integer(n2) : new Integer(-n2);
            this.log(" attribute packetNumber " + n2 + " added.");
            protocolAttributeArray = new ProtocolAttribute[]{object};
        }
        object = byteArrayOutputStream2.toByteArray();
        this.log(" going to execute with params: " + n4 + ", lines: " + n + " - " + n3 + ", batch_pos: " + this.batch_pos + ", bytes_to_send: " + ((Object)object).length);
        this.results = this.connection.communication_resultset((byte[])object, (byte)11, this.execStatus, protocolAttributeArray);
        if (n3 < this.batch_pos) {
            this.log(" next parameter package:");
            this._execute(n3, n2 + 1);
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        this.log("executeQuery()");
        if (this.execute()) {
            if (this.results.length == 0) {
                throw new SQLException(Translator.Query_did_not_return_a_result());
            }
            if (this.results.length > 1) {
                throw new SQLException(Translator.Query_returned_more_than_one_result());
            }
            return this.getResultSet();
        }
        throw new SQLException(Translator.Query_returned_update_count());
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        this.log("executeUpdate()");
        if (this.execute()) {
            throw new SQLException(Translator.Statement_returned_resultset());
        }
        int n = this.getUpdateCount();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.log("getMetaData()");
        if (this.debug != null) {
            this.debug.log("getMetaData() - prepared stmt result set meta data");
        }
        return this.statementMetadata;
    }

    public void setMaxVarcharLen(int n, int n2) throws SQLException {
        this.log("setMaxVarcharLen(" + n + ", " + n2 + ")");
        if (!(this.columns.get(n - 1) instanceof VarCharColumn)) {
            throw new SQLException("Method called for the wrong column type: " + ((Column)this.columns.get(n - 1)).getTypeName());
        }
        ((VarCharColumn)this.columns.get(n - 1)).setMaxColumnSize(n2);
    }

    public void setMaxCharLen(int n, int n2) throws SQLException {
        this.log("setMaxCharLen(" + n + ", " + n2 + ")");
        if (!(this.columns.get(n - 1) instanceof CharColumn)) {
            throw new SQLException("Method called for the wrong column type: " + ((Column)this.columns.get(n - 1)).getTypeName());
        }
        ((CharColumn)this.columns.get(n - 1)).setMaxColumnSize(n2);
    }

    public void setMaxScale(int n, int n2) throws SQLException {
        this.log("setMaxScale(" + n + ", " + n2 + ")");
        if (!(this.columns.get(n - 1) instanceof SmallDecimalColumn || this.columns.get(n - 1) instanceof DecimalColumn || this.columns.get(n - 1) instanceof BigDecimalColumn)) {
            throw new SQLException("Method called for the wong column type: " + ((Column)this.columns.get(n - 1)).getTypeName());
        }
        ((Column)this.columns.get(n - 1)).setScale(n2);
    }

    @Override
    public void setArray(int n, Array array) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == inputStream) {
            this.setNull(n, 1);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new VarCharColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new VarCharColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setAsciiStream(this.batch_pos, inputStream, n2);
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == bigDecimal) {
            this.setNull(n, 3);
        } else {
            Column column;
            int n2 = bigDecimal.scale();
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new BigDecimalColumn(36, n2);
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new BigDecimalColumn(36, n2);
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            if (n2 > column.getScale()) {
                column.setScale(n2);
            }
            column.setBigDecimal(this.batch_pos, bigDecimal);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = new BoolColumn();
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = new BoolColumn();
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setBoolean(this.batch_pos, bl);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = new SmallDecimalColumn(3, 0);
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = new SmallDecimalColumn(3, 0);
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setByte(this.batch_pos, by);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == byArray) {
            this.setNull(n, 12);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new VarCharColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new VarCharColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setString(this.batch_pos, new String(byArray));
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = new VarCharColumn();
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = new VarCharColumn();
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setCharacterStream(this.batch_pos, reader, n2);
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setDate(int n, Date date) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == date) {
            this.setNull(n, 91);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new DateColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new DateColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setDate(this.batch_pos, date);
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == date) {
            this.setNull(n, 91);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new DateColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new DateColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setDate(this.batch_pos, date, calendar);
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = new DoubleColumn();
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = new DoubleColumn();
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setDouble(this.batch_pos, d);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = new DoubleColumn();
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = new DoubleColumn();
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setFloat(this.batch_pos, f);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = new BigDecimalColumn(19, 0);
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = new BigDecimalColumn(19, 0);
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setInt(this.batch_pos, n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = new BigDecimalColumn(36, 0);
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = new BigDecimalColumn(36, 0);
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setLong(this.batch_pos, l);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = (Column)this.createNull(n2);
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = (Column)this.createNull(n2);
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setNull(this.batch_pos);
    }

    public Object createNull(int n, int n2) throws SQLException {
        switch (n2) {
            case 16: {
                return new BoolColumn();
            }
        }
        return this.createNull(n2);
    }

    protected Object createNull(int n) throws SQLException {
        switch (n) {
            case -5: {
                return new BigDecimalColumn(36, 0);
            }
            case 4: {
                return new BigDecimalColumn(19, 0);
            }
            case 5: {
                return new DecimalColumn(10, 0);
            }
            case -7: 
            case 16: {
                return new BoolColumn();
            }
            case 1: {
                return new CharColumn();
            }
            case 12: {
                return new VarCharColumn();
            }
            case 91: {
                return new DateColumn();
            }
            case 93: {
                return new TimestampColumn();
            }
            case 6: 
            case 8: {
                return new DoubleColumn();
            }
            case 2: 
            case 3: {
                return new BigDecimalColumn(36, 0);
            }
        }
        throw new SQLException(Translator.Cannot_handle_datatype() + n);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (null == object) {
            Column column = null;
            try {
                column = (Column)this.columns.get(n - 1);
                column.setNull(this.batch_pos);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.setNull(n, 12);
            }
            return;
        }
        if (object instanceof String) {
            this.setString(n, (String)object);
            return;
        }
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
            return;
        }
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
            return;
        }
        if (object instanceof Double) {
            this.setDouble(n, (Double)object);
            return;
        }
        if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
            return;
        }
        if (object instanceof Long) {
            this.setLong(n, (Long)object);
            return;
        }
        if (object instanceof Short) {
            this.setShort(n, (Short)object);
            return;
        }
        if (object instanceof Time) {
            this.setTime(n, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
            return;
        }
        if (object instanceof Byte[]) {
            this.setBytes(n, (byte[])object);
            return;
        }
        throw new NotImplemented(this.debug, Translator.Datatype_not_supported_in() + new Exception().getStackTrace()[0].getMethodName() + "(int,Object)");
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == object) {
            this.setNull(n, n2);
            return;
        }
        if (object instanceof String) {
            this.setString(n, object.toString());
            return;
        }
        if (object instanceof BigDecimal) {
            switch (n2) {
                case -5: {
                    this.setLong(n, ((BigDecimal)object).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0L == ((BigDecimal)object).longValue()) {
                        this.setBoolean(n, false);
                        break;
                    }
                    this.setBoolean(n, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(n, object.toString());
                    break;
                }
                case 12: {
                    this.setString(n, object.toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, (BigDecimal)object);
                    break;
                }
                case 8: {
                    this.setDouble(n, ((BigDecimal)object).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(n, ((BigDecimal)object).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(n, ((BigDecimal)object).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "BigDecimal to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Boolean) {
            switch (n2) {
                case -5: {
                    if (((Boolean)object).booleanValue()) {
                        this.setLong(n, 1L);
                        break;
                    }
                    this.setLong(n, 0L);
                    break;
                }
                case -7: 
                case 16: {
                    this.setBoolean(n, (Boolean)object);
                    break;
                }
                case 1: {
                    this.setFixedChar(n, ((Boolean)object).toString());
                    break;
                }
                case 12: {
                    this.setString(n, ((Boolean)object).toString());
                    break;
                }
                case 2: 
                case 3: {
                    if (((Boolean)object).booleanValue()) {
                        this.setBigDecimal(n, new BigDecimal(1));
                        break;
                    }
                    this.setBigDecimal(n, new BigDecimal(0));
                    break;
                }
                case 8: {
                    if (((Boolean)object).booleanValue()) {
                        this.setDouble(n, 1.0);
                        break;
                    }
                    this.setDouble(n, 0.0);
                    break;
                }
                case 6: {
                    if (((Boolean)object).booleanValue()) {
                        this.setFloat(n, 1.0f);
                        break;
                    }
                    this.setFloat(n, 0.0f);
                    break;
                }
                case 4: 
                case 5: {
                    if (((Boolean)object).booleanValue()) {
                        this.setInt(n, 1);
                        break;
                    }
                    this.setInt(n, 0);
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Boolean to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Date) {
            switch (n2) {
                case 1: {
                    this.setFixedChar(n, object.toString());
                    break;
                }
                case 12: {
                    this.setString(n, object.toString());
                    break;
                }
                case 91: {
                    this.setDate(n, (Date)object);
                    break;
                }
                case 93: {
                    this.setTimestamp(n, new Timestamp(((Date)object).getTime()));
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Date to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Double) {
            switch (n2) {
                case -5: {
                    this.setLong(n, ((Double)object).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0.0 == (Double)object) {
                        this.setBoolean(n, false);
                        break;
                    }
                    this.setBoolean(n, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(n, object.toString());
                    break;
                }
                case 12: {
                    this.setString(n, object.toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, new BigDecimal((Double)object));
                    break;
                }
                case 8: {
                    this.setDouble(n, (Double)object);
                    break;
                }
                case 6: {
                    this.setFloat(n, ((Double)object).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(n, ((Double)object).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Double to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Float) {
            switch (n2) {
                case -5: {
                    this.setLong(n, ((Float)object).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0.0f == ((Float)object).floatValue()) {
                        this.setBoolean(n, false);
                        break;
                    }
                    this.setBoolean(n, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(n, object.toString());
                    break;
                }
                case 12: {
                    this.setString(n, object.toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, new BigDecimal(((Float)object).doubleValue()));
                    break;
                }
                case 8: {
                    this.setDouble(n, ((Float)object).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(n, ((Float)object).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(n, ((Float)object).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Float to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Integer) {
            switch (n2) {
                case -5: {
                    this.setLong(n, ((Integer)object).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0 == (Integer)object) {
                        this.setBoolean(n, false);
                        break;
                    }
                    this.setBoolean(n, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(n, ((Integer)object).toString());
                    break;
                }
                case 12: {
                    this.setString(n, ((Integer)object).toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, new BigDecimal((Integer)object));
                    break;
                }
                case 8: {
                    this.setDouble(n, ((Integer)object).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(n, ((Integer)object).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(n, (Integer)object);
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Integer to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Long) {
            switch (n2) {
                case -5: {
                    this.setLong(n, (Long)object);
                    break;
                }
                case -7: 
                case 16: {
                    if (0L == (Long)object) {
                        this.setBoolean(n, false);
                        break;
                    }
                    this.setBoolean(n, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(n, ((Long)object).toString());
                    break;
                }
                case 12: {
                    this.setString(n, ((Long)object).toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, new BigDecimal((Long)object));
                    break;
                }
                case 8: {
                    this.setDouble(n, ((Long)object).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(n, ((Long)object).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(n, ((Long)object).intValue());
                    break;
                }
                case 91: {
                    this.setDate(n, new Date((Long)object));
                    break;
                }
                case 93: {
                    this.setTimestamp(n, new Timestamp((Long)object));
                    break;
                }
                case 92: {
                    this.setTime(n, new Time((Long)object));
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Long to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Short) {
            switch (n2) {
                case -5: {
                    this.setLong(n, ((Short)object).shortValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0L == ((Short)object).longValue()) {
                        this.setBoolean(n, false);
                        break;
                    }
                    this.setBoolean(n, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(n, ((Short)object).toString());
                    break;
                }
                case 12: {
                    this.setString(n, ((Short)object).toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, new BigDecimal(((Short)object).longValue()));
                    break;
                }
                case 8: {
                    this.setDouble(n, ((Short)object).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(n, ((Short)object).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(n, ((Short)object).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Short to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Time) {
            switch (n2) {
                case 1: {
                    this.setFixedChar(n, object.toString());
                    break;
                }
                case 12: {
                    this.setString(n, object.toString());
                    break;
                }
                case 93: {
                    this.setTimestamp(n, new Timestamp(((Time)object).getTime()));
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Time to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Timestamp) {
            switch (n2) {
                case 1: {
                    this.setFixedChar(n, object.toString());
                    break;
                }
                case 12: {
                    this.setString(n, object.toString());
                    break;
                }
                case 91: {
                    this.setDate(n, new Date(((Timestamp)object).getTime()));
                    break;
                }
                case 93: {
                    this.setTimestamp(n, (Timestamp)object);
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Timestamp to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Byte) {
            switch (n2) {
                case -5: {
                    this.setLong(n, ((Byte)object).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0 == (Byte)object) {
                        this.setBoolean(n, false);
                        break;
                    }
                    this.setBoolean(n, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(n, ((Byte)object).toString());
                    break;
                }
                case 12: {
                    this.setString(n, ((Byte)object).toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, new BigDecimal(((Byte)object).longValue()));
                    break;
                }
                case 8: {
                    this.setDouble(n, ((Byte)object).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(n, ((Byte)object).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(n, ((Byte)object).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Byte to " + this.getSQLTypeName(n2));
                }
            }
            return;
        }
        if (object instanceof Byte[]) {
            throw new NotImplemented(this.debug, Translator.Conversion_form() + "Byte[] to " + this.getSQLTypeName(n2));
        }
        throw new NotImplemented(this.debug, Translator.Datatype_not_supported_in() + new Exception().getStackTrace()[0].getMethodName() + "(int,Object,int)");
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(int,Object,int,int)");
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setShort(int n, short s) throws SQLException, ArrayIndexOutOfBoundsException {
        Column column;
        if (n > this.columns.size()) {
            if (n > this.columns.size() + 1) {
                column = new DummyColumn();
                for (int i = this.columns.size(); i < n - 1; ++i) {
                    this.columns.add(i, column);
                }
            }
            column = new DecimalColumn(10, 0);
            column.resize(this.capacity);
            this.columns.add(n - 1, column);
        }
        column = (Column)this.columns.get(n - 1);
        if (0 == this.batch_pos && column instanceof DummyColumn) {
            column = new DecimalColumn(10, 0);
            column.resize(this.capacity);
            this.columns.set(n - 1, column);
        }
        column.setShort(this.batch_pos, s);
    }

    @Override
    public void setString(int n, String string) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == string) {
            this.setNull(n, 12);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new VarCharColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new VarCharColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setString(this.batch_pos, string);
        }
    }

    public void setFixedChar(int n, String string) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == string) {
            this.setNull(n, 1);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new CharColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new CharColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setString(this.batch_pos, string);
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == time) {
            this.setNull(n, 93);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new TimestampColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new TimestampColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setTime(this.batch_pos, time);
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == time) {
            this.setNull(n, 93);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new TimestampColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new TimestampColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setTime(this.batch_pos, time, calendar);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == timestamp) {
            this.setNull(n, 93);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new TimestampColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new TimestampColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setTimestamp(this.batch_pos, timestamp);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == timestamp) {
            this.setNull(n, 93);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new TimestampColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new TimestampColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setTimestamp(this.batch_pos, timestamp, calendar);
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == inputStream) {
            this.setNull(n, 12);
        } else {
            Column column;
            if (n > this.columns.size()) {
                if (n > this.columns.size() + 1) {
                    column = new DummyColumn();
                    for (int i = this.columns.size(); i < n - 1; ++i) {
                        this.columns.add(i, column);
                    }
                }
                column = new VarCharColumn();
                column.resize(this.capacity);
                this.columns.add(n - 1, column);
            }
            column = (Column)this.columns.get(n - 1);
            if (0 == this.batch_pos && column instanceof DummyColumn) {
                column = new VarCharColumn();
                column.resize(this.capacity);
                this.columns.set(n - 1, column);
            }
            column.setUnicodeStream(this.batch_pos, inputStream, n2);
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException, ArrayIndexOutOfBoundsException {
        if (this.debug != null) {
            this.debug.log("setURL(" + n + "," + uRL + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(int i,URL u)");
    }

    private void closePreparedHandle() throws SQLException {
        this.execStatus = new ExecutionStatus();
        if (this.handle >= 0) {
            byte[] byArray = new byte[]{(byte)this.handle, (byte)(this.handle >> 8), (byte)(this.handle >> 16), (byte)(this.handle >> 24)};
            this.log("Closing prepared handle " + this.handle);
            this.results = this.connection.communication_resultset(byArray, (byte)18, this.execStatus, null);
            if (this.results != null && this.results.length > 0 && this.results[0] instanceof EXASQLException) {
                this.handle = -1;
                throw ExceptionFactory.createSQLException((EXASQLException)this.results[0], this.connection);
            }
        }
        this.handle = -1;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.log("close() - handle: " + this.handle);
        try {
            if (this.results != null) {
                this.closeResultSets(this.results);
                this.closePreparedHandle();
            }
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException(exception.getMessage());
        }
        finally {
            this.IsClosed = true;
        }
    }
}

