/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.keyspaces.model;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.keyspaces.model.SigV4AuthProvider;
import com.dbeaver.model.security.StaticTLSUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.nio.file.Path;
import javax.net.ssl.SSLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AWSKeyspacesDataSource
extends CasDataSource {
    private static final String AWS_KEYSPACES_TLS_CERT_URL = "https://certs.secureserver.net/repository/sf-class2-root.crt";
    private static final String AWS_LOCAL_CONFIG_FOLDER = ".aws";
    private AuthModelAWSCredentials authCredentials;

    public AWSKeyspacesDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    protected ConsistencyLevel getDefaultConsistencyLevel() {
        return ConsistencyLevel.LOCAL_QUORUM;
    }

    protected void configureEndpoint(DBPConnectionConfiguration connectionInfo, Cluster.Builder builder) {
        String regionId = connectionInfo.getHostName();
        if (!CommonUtils.isEmpty((String)regionId)) {
            builder.addContactPoint("cassandra." + regionId + ".amazonaws.com");
            builder.withPort(9142);
        }
    }

    public boolean supportsPermissions() {
        return false;
    }

    protected void configureAuth(DBRProgressMonitor monitor, Cluster.Builder builder, DBPConnectionConfiguration connectionInfo) throws DBCException {
        builder.withAuthProvider((AuthProvider)new SigV4AuthProvider(this.authCredentials.getAuthCredentialsProvider(monitor, connectionInfo), connectionInfo.getHostName()));
    }

    protected void configureSSL(DBRProgressMonitor monitor, Cluster.Builder builder) throws DBException {
        Path caCertFile = StaticTLSUtils.getStaticCertFile((DBRProgressMonitor)monitor, AWSKeyspacesDataSource.class, (String)AWS_LOCAL_CONFIG_FOLDER, (String)AWS_KEYSPACES_TLS_CERT_URL);
        if (caCertFile != null) {
            SslContextBuilder sslBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.JDK);
            try {
                this.configureSslWithOptions(builder, sslBuilder);
            }
            catch (SSLException sSLException) {
                throw new DBException("Error configuring Keyspaces trust store");
            }
        }
    }

    void setAuthCredentials(AuthModelAWSCredentials crdentials) {
        this.authCredentials = crdentials;
    }
}

