/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.EngineVersion;
import software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkGroupConfigurationUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkGroupConfigurationUpdates> {
    private static final SdkField<Boolean> ENFORCE_WORK_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnforceWorkGroupConfiguration").getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::enforceWorkGroupConfiguration)).setter(WorkGroupConfigurationUpdates.setter(Builder::enforceWorkGroupConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceWorkGroupConfiguration").build()}).build();
    private static final SdkField<ResultConfigurationUpdates> RESULT_CONFIGURATION_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultConfigurationUpdates").getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::resultConfigurationUpdates)).setter(WorkGroupConfigurationUpdates.setter(Builder::resultConfigurationUpdates)).constructor(ResultConfigurationUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfigurationUpdates").build()}).build();
    private static final SdkField<Boolean> PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PublishCloudWatchMetricsEnabled").getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::publishCloudWatchMetricsEnabled)).setter(WorkGroupConfigurationUpdates.setter(Builder::publishCloudWatchMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishCloudWatchMetricsEnabled").build()}).build();
    private static final SdkField<Long> BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesScannedCutoffPerQuery").getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::bytesScannedCutoffPerQuery)).setter(WorkGroupConfigurationUpdates.setter(Builder::bytesScannedCutoffPerQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScannedCutoffPerQuery").build()}).build();
    private static final SdkField<Boolean> REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveBytesScannedCutoffPerQuery").getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::removeBytesScannedCutoffPerQuery)).setter(WorkGroupConfigurationUpdates.setter(Builder::removeBytesScannedCutoffPerQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveBytesScannedCutoffPerQuery").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterPaysEnabled").getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::requesterPaysEnabled)).setter(WorkGroupConfigurationUpdates.setter(Builder::requesterPaysEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPaysEnabled").build()}).build();
    private static final SdkField<EngineVersion> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EngineVersion").getter(WorkGroupConfigurationUpdates.getter(WorkGroupConfigurationUpdates::engineVersion)).setter(WorkGroupConfigurationUpdates.setter(Builder::engineVersion)).constructor(EngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCE_WORK_GROUP_CONFIGURATION_FIELD, RESULT_CONFIGURATION_UPDATES_FIELD, PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD, BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD, REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD, REQUESTER_PAYS_ENABLED_FIELD, ENGINE_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enforceWorkGroupConfiguration;
    private final ResultConfigurationUpdates resultConfigurationUpdates;
    private final Boolean publishCloudWatchMetricsEnabled;
    private final Long bytesScannedCutoffPerQuery;
    private final Boolean removeBytesScannedCutoffPerQuery;
    private final Boolean requesterPaysEnabled;
    private final EngineVersion engineVersion;

    private WorkGroupConfigurationUpdates(BuilderImpl builder) {
        this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
        this.resultConfigurationUpdates = builder.resultConfigurationUpdates;
        this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
        this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
        this.removeBytesScannedCutoffPerQuery = builder.removeBytesScannedCutoffPerQuery;
        this.requesterPaysEnabled = builder.requesterPaysEnabled;
        this.engineVersion = builder.engineVersion;
    }

    public final Boolean enforceWorkGroupConfiguration() {
        return this.enforceWorkGroupConfiguration;
    }

    public final ResultConfigurationUpdates resultConfigurationUpdates() {
        return this.resultConfigurationUpdates;
    }

    public final Boolean publishCloudWatchMetricsEnabled() {
        return this.publishCloudWatchMetricsEnabled;
    }

    public final Long bytesScannedCutoffPerQuery() {
        return this.bytesScannedCutoffPerQuery;
    }

    public final Boolean removeBytesScannedCutoffPerQuery() {
        return this.removeBytesScannedCutoffPerQuery;
    }

    public final Boolean requesterPaysEnabled() {
        return this.requesterPaysEnabled;
    }

    public final EngineVersion engineVersion() {
        return this.engineVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceWorkGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfigurationUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishCloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesScannedCutoffPerQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeBytesScannedCutoffPerQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPaysEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkGroupConfigurationUpdates)) {
            return false;
        }
        WorkGroupConfigurationUpdates other = (WorkGroupConfigurationUpdates)obj;
        return Objects.equals(this.enforceWorkGroupConfiguration(), other.enforceWorkGroupConfiguration()) && Objects.equals(this.resultConfigurationUpdates(), other.resultConfigurationUpdates()) && Objects.equals(this.publishCloudWatchMetricsEnabled(), other.publishCloudWatchMetricsEnabled()) && Objects.equals(this.bytesScannedCutoffPerQuery(), other.bytesScannedCutoffPerQuery()) && Objects.equals(this.removeBytesScannedCutoffPerQuery(), other.removeBytesScannedCutoffPerQuery()) && Objects.equals(this.requesterPaysEnabled(), other.requesterPaysEnabled()) && Objects.equals(this.engineVersion(), other.engineVersion());
    }

    public final String toString() {
        return ToString.builder((String)"WorkGroupConfigurationUpdates").add("EnforceWorkGroupConfiguration", (Object)this.enforceWorkGroupConfiguration()).add("ResultConfigurationUpdates", (Object)this.resultConfigurationUpdates()).add("PublishCloudWatchMetricsEnabled", (Object)this.publishCloudWatchMetricsEnabled()).add("BytesScannedCutoffPerQuery", (Object)this.bytesScannedCutoffPerQuery()).add("RemoveBytesScannedCutoffPerQuery", (Object)this.removeBytesScannedCutoffPerQuery()).add("RequesterPaysEnabled", (Object)this.requesterPaysEnabled()).add("EngineVersion", (Object)this.engineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnforceWorkGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.enforceWorkGroupConfiguration()));
            }
            case "ResultConfigurationUpdates": {
                return Optional.ofNullable(clazz.cast(this.resultConfigurationUpdates()));
            }
            case "PublishCloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.publishCloudWatchMetricsEnabled()));
            }
            case "BytesScannedCutoffPerQuery": {
                return Optional.ofNullable(clazz.cast(this.bytesScannedCutoffPerQuery()));
            }
            case "RemoveBytesScannedCutoffPerQuery": {
                return Optional.ofNullable(clazz.cast(this.removeBytesScannedCutoffPerQuery()));
            }
            case "RequesterPaysEnabled": {
                return Optional.ofNullable(clazz.cast(this.requesterPaysEnabled()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkGroupConfigurationUpdates, T> g) {
        return obj -> g.apply((WorkGroupConfigurationUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enforceWorkGroupConfiguration;
        private ResultConfigurationUpdates resultConfigurationUpdates;
        private Boolean publishCloudWatchMetricsEnabled;
        private Long bytesScannedCutoffPerQuery;
        private Boolean removeBytesScannedCutoffPerQuery;
        private Boolean requesterPaysEnabled;
        private EngineVersion engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkGroupConfigurationUpdates model) {
            this.enforceWorkGroupConfiguration(model.enforceWorkGroupConfiguration);
            this.resultConfigurationUpdates(model.resultConfigurationUpdates);
            this.publishCloudWatchMetricsEnabled(model.publishCloudWatchMetricsEnabled);
            this.bytesScannedCutoffPerQuery(model.bytesScannedCutoffPerQuery);
            this.removeBytesScannedCutoffPerQuery(model.removeBytesScannedCutoffPerQuery);
            this.requesterPaysEnabled(model.requesterPaysEnabled);
            this.engineVersion(model.engineVersion);
        }

        public final Boolean getEnforceWorkGroupConfiguration() {
            return this.enforceWorkGroupConfiguration;
        }

        public final void setEnforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
        }

        @Override
        @Transient
        public final Builder enforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
            return this;
        }

        public final ResultConfigurationUpdates.Builder getResultConfigurationUpdates() {
            return this.resultConfigurationUpdates != null ? this.resultConfigurationUpdates.toBuilder() : null;
        }

        public final void setResultConfigurationUpdates(ResultConfigurationUpdates.BuilderImpl resultConfigurationUpdates) {
            this.resultConfigurationUpdates = resultConfigurationUpdates != null ? resultConfigurationUpdates.build() : null;
        }

        @Override
        @Transient
        public final Builder resultConfigurationUpdates(ResultConfigurationUpdates resultConfigurationUpdates) {
            this.resultConfigurationUpdates = resultConfigurationUpdates;
            return this;
        }

        public final Boolean getPublishCloudWatchMetricsEnabled() {
            return this.publishCloudWatchMetricsEnabled;
        }

        public final void setPublishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
        }

        @Override
        @Transient
        public final Builder publishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
            return this;
        }

        public final Long getBytesScannedCutoffPerQuery() {
            return this.bytesScannedCutoffPerQuery;
        }

        public final void setBytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
        }

        @Override
        @Transient
        public final Builder bytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
            return this;
        }

        public final Boolean getRemoveBytesScannedCutoffPerQuery() {
            return this.removeBytesScannedCutoffPerQuery;
        }

        public final void setRemoveBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
            this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
        }

        @Override
        @Transient
        public final Builder removeBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
            this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
            return this;
        }

        public final Boolean getRequesterPaysEnabled() {
            return this.requesterPaysEnabled;
        }

        public final void setRequesterPaysEnabled(Boolean requesterPaysEnabled) {
            this.requesterPaysEnabled = requesterPaysEnabled;
        }

        @Override
        @Transient
        public final Builder requesterPaysEnabled(Boolean requesterPaysEnabled) {
            this.requesterPaysEnabled = requesterPaysEnabled;
            return this;
        }

        public final EngineVersion.Builder getEngineVersion() {
            return this.engineVersion != null ? this.engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(EngineVersion.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        @Transient
        public final Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public WorkGroupConfigurationUpdates build() {
            return new WorkGroupConfigurationUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkGroupConfigurationUpdates> {
        public Builder enforceWorkGroupConfiguration(Boolean var1);

        public Builder resultConfigurationUpdates(ResultConfigurationUpdates var1);

        default public Builder resultConfigurationUpdates(Consumer<ResultConfigurationUpdates.Builder> resultConfigurationUpdates) {
            return this.resultConfigurationUpdates((ResultConfigurationUpdates)((ResultConfigurationUpdates.Builder)ResultConfigurationUpdates.builder().applyMutation(resultConfigurationUpdates)).build());
        }

        public Builder publishCloudWatchMetricsEnabled(Boolean var1);

        public Builder bytesScannedCutoffPerQuery(Long var1);

        public Builder removeBytesScannedCutoffPerQuery(Boolean var1);

        public Builder requesterPaysEnabled(Boolean var1);

        public Builder engineVersion(EngineVersion var1);

        default public Builder engineVersion(Consumer<EngineVersion.Builder> engineVersion) {
            return this.engineVersion((EngineVersion)((EngineVersion.Builder)EngineVersion.builder().applyMutation(engineVersion)).build());
        }
    }
}

