/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search.metadata;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.search.AbstractSearchResult;
import org.jkiss.dbeaver.ui.search.metadata.SearchMetadataResult;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SearchMetadataQuery
implements ISearchQuery {
    private static final Log log = Log.getLog(SearchMetadataQuery.class);
    private final DBSStructureAssistant structureAssistant;
    private final DBCExecutionContext executionContext;
    @NotNull
    private final DBSStructureAssistant.ObjectsSearchParams params;
    private SearchMetadataResult searchResult;

    SearchMetadataQuery(@NotNull DBPDataSource dataSource, @NotNull DBSStructureAssistant<?> structureAssistant, @NotNull DBSStructureAssistant.ObjectsSearchParams params) {
        this.structureAssistant = structureAssistant;
        this.executionContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true);
        this.params = params;
    }

    public String getLabel() {
        return this.params.getMask();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new SearchMetadataResult(this);
        }
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            String objectNameMask = this.params.getMask();
            if (!this.params.isLikeCondition() && !objectNameMask.endsWith("%")) {
                objectNameMask = String.valueOf(objectNameMask) + "%";
                this.params.setMask(objectNameMask);
            }
            int totalObjects = 0;
            DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
            DBRProgressMonitor localMonitor = RuntimeUtils.makeMonitor((IProgressMonitor)monitor);
            List objects = this.structureAssistant.findObjectsByMask(localMonitor, this.executionContext, this.params);
            for (DBSObjectReference reference : objects) {
                if (monitor.isCanceled()) break;
                try {
                    DBNDatabaseNode node;
                    DBSObject object = reference.resolveObject(localMonitor);
                    if (object == null || (node = navigatorModel.getNodeByObject(localMonitor, object, false)) == null) continue;
                    this.searchResult.addObjects(Collections.singletonList(node));
                    ++totalObjects;
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
            this.searchResult.fireChange(new AbstractSearchResult.DatabaseSearchFinishEvent(this.searchResult, totalObjects));
            return Status.OK_STATUS;
        }
        catch (DBException e) {
            log.debug((Object)e);
            return GeneralUtils.makeExceptionStatus((Throwable)e);
        }
    }
}

