/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui;

import com.dbeaver.ee.qm.internal.QMPluginService;
import com.dbeaver.model.QMService;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.translator.DAIHistoryItem;
import org.jkiss.dbeaver.model.ai.translator.DAIHistoryManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class QMDBAIHistoryManager
implements DAIHistoryManager {
    private static final Log log = Log.getLog(QMDBAIHistoryManager.class);

    @NotNull
    public List<DAIHistoryItem> readTranslationHistory(@NotNull DBRProgressMonitor monitor, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, int maxCount) throws DBException {
        QMService qmService = QMPluginService.getQmService();
        if (qmService == null) {
            return Collections.emptyList();
        }
        String qmSessionId = QMUtils.getQmSessionId((DBCExecutionContext)executionContext);
        if (qmSessionId == null) {
            return Collections.emptyList();
        }
        return qmService.readSmartCompletionHistory(monitor, qmSessionId, dataSource.getDataSourceContainer().getId(), dataSource.getName(), dataSource.getCurrentCatalog(), dataSource.getCurrentSchema(), maxCount);
    }

    public void saveTranslationHistory(@NotNull DBRProgressMonitor monitor, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, @NotNull String natualText, @NotNull String sqlText) throws DBException {
        QMService qmService = QMPluginService.getQmService();
        if (qmService == null) {
            return;
        }
        String qmSessionId = QMUtils.getQmSessionId((DBCExecutionContext)executionContext);
        if (qmSessionId == null) {
            return;
        }
        qmService.saveSmartCompletionHistory(monitor, qmSessionId, dataSource.getDataSourceContainer().getId(), dataSource.getName(), dataSource.getCurrentCatalog(), dataSource.getCurrentSchema(), natualText, sqlText);
    }
}

