/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.fluent.models.ServerUpdateParametersProperties;
import com.azure.resourcemanager.mysql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.mysql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.mysql.models.ResourceIdentity;
import com.azure.resourcemanager.mysql.models.ServerVersion;
import com.azure.resourcemanager.mysql.models.Sku;
import com.azure.resourcemanager.mysql.models.SslEnforcementEnum;
import com.azure.resourcemanager.mysql.models.StorageProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ServerUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerUpdateParameters.class);
    @JsonProperty(value="identity")
    private ResourceIdentity identity;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties")
    private ServerUpdateParametersProperties innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ServerUpdateParameters withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ServerUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private ServerUpdateParametersProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public ServerUpdateParameters withStorageProfile(StorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerUpdateParameters withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public ServerVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerUpdateParameters withVersion(ServerVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public SslEnforcementEnum sslEnforcement() {
        return this.innerProperties() == null ? null : this.innerProperties().sslEnforcement();
    }

    public ServerUpdateParameters withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withSslEnforcement(sslEnforcement);
        return this;
    }

    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    public ServerUpdateParameters withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ServerUpdateParameters withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public String replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public ServerUpdateParameters withReplicationRole(String replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

