/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.mysql.fluent.models.ServerSecurityAlertPolicyInner;
import com.azure.resourcemanager.mysql.models.ServerSecurityAlertPolicyState;
import java.util.List;

public interface ServerSecurityAlertPolicy {
    public String id();

    public String name();

    public String type();

    public ServerSecurityAlertPolicyState state();

    public List<String> disabledAlerts();

    public List<String> emailAddresses();

    public Boolean emailAccountAdmins();

    public String storageEndpoint();

    public String storageAccountAccessKey();

    public Integer retentionDays();

    public ServerSecurityAlertPolicyInner innerModel();

    public Update update();

    public ServerSecurityAlertPolicy refresh();

    public ServerSecurityAlertPolicy refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithRetentionDays {
            public Update withRetentionDays(Integer var1);
        }

        public static interface WithStorageAccountAccessKey {
            public Update withStorageAccountAccessKey(String var1);
        }

        public static interface WithStorageEndpoint {
            public Update withStorageEndpoint(String var1);
        }

        public static interface WithEmailAccountAdmins {
            public Update withEmailAccountAdmins(Boolean var1);
        }

        public static interface WithEmailAddresses {
            public Update withEmailAddresses(List<String> var1);
        }

        public static interface WithDisabledAlerts {
            public Update withDisabledAlerts(List<String> var1);
        }

        public static interface WithState {
            public Update withState(ServerSecurityAlertPolicyState var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithState,
    UpdateStages.WithDisabledAlerts,
    UpdateStages.WithEmailAddresses,
    UpdateStages.WithEmailAccountAdmins,
    UpdateStages.WithStorageEndpoint,
    UpdateStages.WithStorageAccountAccessKey,
    UpdateStages.WithRetentionDays {
        public ServerSecurityAlertPolicy apply();

        public ServerSecurityAlertPolicy apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithRetentionDays {
            public WithCreate withRetentionDays(Integer var1);
        }

        public static interface WithStorageAccountAccessKey {
            public WithCreate withStorageAccountAccessKey(String var1);
        }

        public static interface WithStorageEndpoint {
            public WithCreate withStorageEndpoint(String var1);
        }

        public static interface WithEmailAccountAdmins {
            public WithCreate withEmailAccountAdmins(Boolean var1);
        }

        public static interface WithEmailAddresses {
            public WithCreate withEmailAddresses(List<String> var1);
        }

        public static interface WithDisabledAlerts {
            public WithCreate withDisabledAlerts(List<String> var1);
        }

        public static interface WithState {
            public WithCreate withState(ServerSecurityAlertPolicyState var1);
        }

        public static interface WithCreate
        extends WithState,
        WithDisabledAlerts,
        WithEmailAddresses,
        WithEmailAccountAdmins,
        WithStorageEndpoint,
        WithStorageAccountAccessKey,
        WithRetentionDays {
            public ServerSecurityAlertPolicy create();

            public ServerSecurityAlertPolicy create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingServer(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

