/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.models.PrivateEndpointProperty;
import com.azure.resourcemanager.mysql.models.PrivateEndpointProvisioningState;
import com.azure.resourcemanager.mysql.models.ServerPrivateLinkServiceConnectionStateProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ServerPrivateEndpointConnectionProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerPrivateEndpointConnectionProperties.class);
    @JsonProperty(value="privateEndpoint")
    private PrivateEndpointProperty privateEndpoint;
    @JsonProperty(value="privateLinkServiceConnectionState")
    private ServerPrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private PrivateEndpointProvisioningState provisioningState;

    public PrivateEndpointProperty privateEndpoint() {
        return this.privateEndpoint;
    }

    public ServerPrivateEndpointConnectionProperties withPrivateEndpoint(PrivateEndpointProperty privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public ServerPrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public ServerPrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(ServerPrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public PrivateEndpointProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }
}

