/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.models.InfrastructureEncryption;
import com.azure.resourcemanager.mysql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.mysql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.mysql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.mysql.models.ServerState;
import com.azure.resourcemanager.mysql.models.ServerVersion;
import com.azure.resourcemanager.mysql.models.SslEnforcementEnum;
import com.azure.resourcemanager.mysql.models.StorageProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class ServerProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerProperties.class);
    @JsonProperty(value="administratorLogin")
    private String administratorLogin;
    @JsonProperty(value="version")
    private ServerVersion version;
    @JsonProperty(value="sslEnforcement")
    private SslEnforcementEnum sslEnforcement;
    @JsonProperty(value="minimalTlsVersion")
    private MinimalTlsVersionEnum minimalTlsVersion;
    @JsonProperty(value="byokEnforcement", access=JsonProperty.Access.WRITE_ONLY)
    private String byokEnforcement;
    @JsonProperty(value="infrastructureEncryption")
    private InfrastructureEncryption infrastructureEncryption;
    @JsonProperty(value="userVisibleState")
    private ServerState userVisibleState;
    @JsonProperty(value="fullyQualifiedDomainName")
    private String fullyQualifiedDomainName;
    @JsonProperty(value="earliestRestoreDate")
    private OffsetDateTime earliestRestoreDate;
    @JsonProperty(value="storageProfile")
    private StorageProfile storageProfile;
    @JsonProperty(value="replicationRole")
    private String replicationRole;
    @JsonProperty(value="masterServerId")
    private String masterServerId;
    @JsonProperty(value="replicaCapacity")
    private Integer replicaCapacity;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccessEnum publicNetworkAccess;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<ServerPrivateEndpointConnection> privateEndpointConnections;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public ServerVersion version() {
        return this.version;
    }

    public ServerProperties withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public SslEnforcementEnum sslEnforcement() {
        return this.sslEnforcement;
    }

    public ServerProperties withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        this.sslEnforcement = sslEnforcement;
        return this;
    }

    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ServerProperties withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public String byokEnforcement() {
        return this.byokEnforcement;
    }

    public InfrastructureEncryption infrastructureEncryption() {
        return this.infrastructureEncryption;
    }

    public ServerProperties withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        this.infrastructureEncryption = infrastructureEncryption;
        return this;
    }

    public ServerState userVisibleState() {
        return this.userVisibleState;
    }

    public ServerProperties withUserVisibleState(ServerState userVisibleState) {
        this.userVisibleState = userVisibleState;
        return this;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public ServerProperties withFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        return this;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public ServerProperties withEarliestRestoreDate(OffsetDateTime earliestRestoreDate) {
        this.earliestRestoreDate = earliestRestoreDate;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ServerProperties withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String replicationRole() {
        return this.replicationRole;
    }

    public ServerProperties withReplicationRole(String replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public String masterServerId() {
        return this.masterServerId;
    }

    public ServerProperties withMasterServerId(String masterServerId) {
        this.masterServerId = masterServerId;
        return this;
    }

    public Integer replicaCapacity() {
        return this.replicaCapacity;
    }

    public ServerProperties withReplicaCapacity(Integer replicaCapacity) {
        this.replicaCapacity = replicaCapacity;
        return this;
    }

    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ServerProperties withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

