/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl;

import com.influxdb.query.dsl.Expression;
import com.influxdb.query.dsl.HasImports;
import com.influxdb.query.dsl.utils.ImportUtils;
import com.influxdb.utils.Arguments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Expressions
implements HasImports {
    private final List<Expression> expressions = new ArrayList<Expression>();

    public Expressions(Expression ... expressions) {
        Arguments.checkNotNull((Object)expressions, (String)"expressions");
        this.expressions.addAll(Arrays.stream(expressions).collect(Collectors.toList()));
    }

    public Expressions(@Nonnull Collection<? extends Expression> expressions) {
        Arguments.checkNotNull(expressions, (String)"expressions");
        this.expressions.addAll(expressions);
    }

    public Expressions addExpressions(Expression ... expressions) {
        Arguments.checkNotNull((Object)expressions, (String)"expression");
        this.expressions.addAll(Arrays.asList(expressions));
        return this;
    }

    public String toString(@Nonnull Map<String, Object> parameters, boolean prependImports) {
        StringBuilder builder = new StringBuilder();
        if (prependImports) {
            builder.append(ImportUtils.getImportsString(this));
        }
        for (Expression expression : this.expressions) {
            builder.append(expression.toString(parameters, false)).append("\n");
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(Collections.emptyMap(), true);
    }

    @Override
    public Set<String> getImports() {
        return this.expressions.stream().map(HasImports::getImports).flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new));
    }
}

