/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.IoBuff;
import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.Trace;
import com.ingres.gcf.util.TraceLog;
import com.ingres.gcf.util.Tracing;
import java.io.OutputStream;
import java.sql.SQLException;

class OutBuff
extends IoBuff
implements GcfErr {
    protected Trace trace;

    public OutBuff(OutputStream outputStream, int n, int n2, TraceLog traceLog) {
        super(outputStream, traceLog);
        this.title = "OutBuff[" + n + "]";
        this.trace = new Tracing(traceLog, "msg.tl");
        this.setBuffSize(n2);
    }

    public void begin(short s, int n) throws SQLException {
        n += 6;
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": begin TL packet " + IdMap.map(s, tlMap));
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.title + ": reserving " + n);
        }
        super.begin(n);
        this.write(this.proto_lvl == 1 ? 1280590666 : 1280593220);
        this.write(s);
    }

    public int avail() {
        return this.data_end - this.data_ptr;
    }

    public int position() {
        return this.data_ptr;
    }

    public void write(byte by) throws SQLException {
        this.need(1);
        this.write(this.data_ptr, by);
    }

    public void write(int n, byte by) throws SQLException {
        this.check(n, 1);
        this.buffer[n++] = by;
        if (n > this.data_ptr) {
            this.data_ptr = n;
        }
    }

    public void write(short s) throws SQLException {
        this.need(2);
        this.write(this.data_ptr, s);
    }

    public void write(int n, short s) throws SQLException {
        this.check(n, 2);
        this.buffer[n++] = (byte)(s & 0xFF);
        this.buffer[n++] = (byte)(s >>> 8 & 0xFF);
        if (n > this.data_ptr) {
            this.data_ptr = n;
        }
    }

    public void write(int n) throws SQLException {
        this.need(4);
        this.write(this.data_ptr, n);
    }

    public void write(int n, int n2) throws SQLException {
        this.check(n, 4);
        this.buffer[n++] = (byte)(n2 & 0xFF);
        this.buffer[n++] = (byte)(n2 >>> 8 & 0xFF);
        this.buffer[n++] = (byte)(n2 >>> 16 & 0xFF);
        this.buffer[n++] = (byte)(n2 >>> 24 & 0xFF);
        if (n > this.data_ptr) {
            this.data_ptr = n;
        }
    }

    public void write(long l) throws SQLException {
        this.need(8);
        this.write(this.data_ptr, l);
    }

    public void write(int n, long l) throws SQLException {
        this.check(n, 8);
        this.buffer[n++] = (byte)(l & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 8 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 16 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 24 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 32 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 40 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 48 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 56 & 0xFFL);
        if (n > this.data_ptr) {
            this.data_ptr = n;
        }
    }

    public void write(float f) throws SQLException {
        this.need(6);
        this.write(this.data_ptr, f);
    }

    public void write(int n, float f) throws SQLException {
        this.check(n, 6);
        int n2 = Float.floatToIntBits(f);
        byte by = (byte)((n2 & Integer.MIN_VALUE) >>> 31);
        short s = (short)((n2 & 0x7F800000) >>> 23);
        int n3 = (n2 & 0x7FFFFF) << 9;
        if (s != 0) {
            s = (short)(s + 16256);
        }
        this.buffer[n + 1] = (byte)(by << 7 | s >>> 8);
        this.buffer[n + 0] = (byte)s;
        this.buffer[n + 3] = (byte)(n3 >>> 24);
        this.buffer[n + 2] = (byte)(n3 >>> 16);
        this.buffer[n + 5] = (byte)(n3 >>> 8);
        this.buffer[n + 4] = (byte)n3;
        if ((n += 6) > this.data_ptr) {
            this.data_ptr = n;
        }
    }

    public void write(double d) throws SQLException {
        this.need(10);
        this.write(this.data_ptr, d);
    }

    public void write(int n, double d) throws SQLException {
        this.check(n, 10);
        long l = Double.doubleToLongBits(d);
        byte by = (byte)((l & Long.MIN_VALUE) >>> 63);
        short s = (short)((l & 0x7FF0000000000000L) >>> 52);
        long l2 = (l & 0xFFFFFFFFFFFFFL) << 12;
        if (s != 0) {
            s = (short)(s + 15360);
        }
        this.buffer[n + 1] = (byte)(by << 7 | s >>> 8);
        this.buffer[n + 0] = (byte)s;
        this.buffer[n + 3] = (byte)(l2 >>> 56);
        this.buffer[n + 2] = (byte)(l2 >>> 48);
        this.buffer[n + 5] = (byte)(l2 >>> 40);
        this.buffer[n + 4] = (byte)(l2 >>> 32);
        this.buffer[n + 7] = (byte)(l2 >>> 24);
        this.buffer[n + 6] = (byte)(l2 >>> 16);
        this.buffer[n + 9] = (byte)(l2 >>> 8);
        this.buffer[n + 8] = (byte)l2;
        if ((n += 10) > this.data_ptr) {
            this.data_ptr = n;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws SQLException {
        if (!this.need(n2)) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": array length " + n2 + " too long");
            }
            this.close();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        if (this.trace.enabled(4)) {
            this.trace.write(this.title + ": appending " + n2);
        }
        System.arraycopy(byArray, n, this.buffer, this.data_ptr, n2);
        this.data_ptr += n2;
    }

    public int write(ByteArray byteArray, int n, int n2) throws SQLException {
        if (!this.need(n2)) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": ByteArray length " + n2 + " too long");
            }
            this.close();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        if (this.trace.enabled(4)) {
            this.trace.write(this.title + ": appending " + n2);
        }
        n2 = byteArray.get(n, n2, this.buffer, this.data_ptr);
        this.data_ptr += n2;
        return n2;
    }

    public void send(boolean bl) throws SQLException {
        if (this.trace.enabled(3)) {
            this.trace.write(this.title + ": sending TL packet");
        }
        this.flush(bl);
    }

    private boolean need(int n) throws SQLException {
        if (this.data_ptr + n > this.data_end) {
            this.send(false);
            this.begin((short)21572, n);
        }
        return this.data_ptr + n <= this.data_end;
    }

    private void check(int n, int n2) throws SQLException {
        if (n < this.data_beg || n + n2 > this.data_end) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": position out-of-bounds");
            }
            this.close();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        if (this.trace.enabled(4)) {
            if (n != this.data_ptr) {
                this.trace.write(this.title + ": writing " + n2 + " @ " + n);
            } else {
                this.trace.write(this.title + ": appending " + n2);
            }
        }
    }
}

